/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;

public class GravesLSTMLayerSpace
extends FeedForwardLayerSpace<GravesLSTM> {
    private ParameterSpace<Double> forgetGateBiasInit;

    private GravesLSTMLayerSpace(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    public GravesLSTM getValue(double[] values) {
        GravesLSTM.Builder b = new GravesLSTM.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(GravesLSTM.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.forgetGateBiasInit != null) {
            builder.forgetGateBiasInit(((Double)this.forgetGateBiasInit.getValue(values)).doubleValue());
        }
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.forgetGateBiasInit != null) {
            list.addAll(this.forgetGateBiasInit.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("GravesLSTMLayerSpace(");
        if (this.forgetGateBiasInit != null) {
            sb.append("forgetGateBiasInit: ").append(this.forgetGateBiasInit).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<Double> getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public void setForgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GravesLSTMLayerSpace)) {
            return false;
        }
        GravesLSTMLayerSpace other = (GravesLSTMLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$forgetGateBiasInit = this.getForgetGateBiasInit();
        ParameterSpace<Double> other$forgetGateBiasInit = other.getForgetGateBiasInit();
        return !(this$forgetGateBiasInit == null ? other$forgetGateBiasInit != null : !this$forgetGateBiasInit.equals(other$forgetGateBiasInit));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GravesLSTMLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<Double> $forgetGateBiasInit = this.getForgetGateBiasInit();
        result = result * 59 + ($forgetGateBiasInit == null ? 43 : $forgetGateBiasInit.hashCode());
        return result;
    }

    private GravesLSTMLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        private ParameterSpace<Double> forgetGateBiasInit;

        public Builder forgetGateBiasInit(double forgetGateBiasInit) {
            return this.forgetGateBiasInit((ParameterSpace<Double>)new FixedValue((Object)forgetGateBiasInit));
        }

        public Builder forgetGateBiasInit(ParameterSpace<Double> forgetGateBiasInit) {
            this.forgetGateBiasInit = forgetGateBiasInit;
            return this;
        }

        @Override
        public GravesLSTMLayerSpace build() {
            return new GravesLSTMLayerSpace(this);
        }
    }
}

