/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.RBM;

public class RBMLayerSpace
extends BasePretrainNetworkLayerSpace<RBM> {
    private ParameterSpace<RBM.HiddenUnit> hiddenUnit;
    private ParameterSpace<RBM.VisibleUnit> visibleUnit;
    private ParameterSpace<Integer> k;
    private ParameterSpace<Double> sparsity;

    private RBMLayerSpace(Builder builder) {
        super(builder);
        this.hiddenUnit = builder.hiddenUnit;
        this.visibleUnit = builder.visibleUnit;
        this.k = builder.k;
        this.sparsity = builder.sparsity;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.hiddenUnit != null) {
            list.addAll(this.hiddenUnit.collectLeaves());
        }
        if (this.visibleUnit != null) {
            list.addAll(this.visibleUnit.collectLeaves());
        }
        if (this.k != null) {
            list.addAll(this.k.collectLeaves());
        }
        if (this.sparsity != null) {
            list.addAll(this.sparsity.collectLeaves());
        }
        return list;
    }

    public RBM getValue(double[] values) {
        RBM.Builder b = new RBM.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(RBM.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.hiddenUnit != null) {
            builder.hiddenUnit((RBM.HiddenUnit)this.hiddenUnit.getValue(values));
        }
        if (this.visibleUnit != null) {
            builder.visibleUnit((RBM.VisibleUnit)this.visibleUnit.getValue(values));
        }
        if (this.k != null) {
            builder.k(((Integer)this.k.getValue(values)).intValue());
        }
        if (this.sparsity != null) {
            builder.sparsity(((Double)this.sparsity.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("RBMLayerSpace(");
        if (this.hiddenUnit != null) {
            sb.append("hiddenUnit: ").append(this.hiddenUnit).append(delim);
        }
        if (this.visibleUnit != null) {
            sb.append("visibleUnit: ").append(this.visibleUnit).append(delim);
        }
        if (this.k != null) {
            sb.append("k: ").append(this.k).append(delim);
        }
        if (this.sparsity != null) {
            sb.append("sparsity: ").append(this.sparsity).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<RBM.HiddenUnit> getHiddenUnit() {
        return this.hiddenUnit;
    }

    public ParameterSpace<RBM.VisibleUnit> getVisibleUnit() {
        return this.visibleUnit;
    }

    public ParameterSpace<Integer> getK() {
        return this.k;
    }

    public ParameterSpace<Double> getSparsity() {
        return this.sparsity;
    }

    public void setHiddenUnit(ParameterSpace<RBM.HiddenUnit> hiddenUnit) {
        this.hiddenUnit = hiddenUnit;
    }

    public void setVisibleUnit(ParameterSpace<RBM.VisibleUnit> visibleUnit) {
        this.visibleUnit = visibleUnit;
    }

    public void setK(ParameterSpace<Integer> k) {
        this.k = k;
    }

    public void setSparsity(ParameterSpace<Double> sparsity) {
        this.sparsity = sparsity;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RBMLayerSpace)) {
            return false;
        }
        RBMLayerSpace other = (RBMLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<RBM.HiddenUnit> this$hiddenUnit = this.getHiddenUnit();
        ParameterSpace<RBM.HiddenUnit> other$hiddenUnit = other.getHiddenUnit();
        if (this$hiddenUnit == null ? other$hiddenUnit != null : !this$hiddenUnit.equals(other$hiddenUnit)) {
            return false;
        }
        ParameterSpace<RBM.VisibleUnit> this$visibleUnit = this.getVisibleUnit();
        ParameterSpace<RBM.VisibleUnit> other$visibleUnit = other.getVisibleUnit();
        if (this$visibleUnit == null ? other$visibleUnit != null : !this$visibleUnit.equals(other$visibleUnit)) {
            return false;
        }
        ParameterSpace<Integer> this$k = this.getK();
        ParameterSpace<Integer> other$k = other.getK();
        if (this$k == null ? other$k != null : !this$k.equals(other$k)) {
            return false;
        }
        ParameterSpace<Double> this$sparsity = this.getSparsity();
        ParameterSpace<Double> other$sparsity = other.getSparsity();
        return !(this$sparsity == null ? other$sparsity != null : !this$sparsity.equals(other$sparsity));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RBMLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<RBM.HiddenUnit> $hiddenUnit = this.getHiddenUnit();
        result = result * 59 + ($hiddenUnit == null ? 43 : $hiddenUnit.hashCode());
        ParameterSpace<RBM.VisibleUnit> $visibleUnit = this.getVisibleUnit();
        result = result * 59 + ($visibleUnit == null ? 43 : $visibleUnit.hashCode());
        ParameterSpace<Integer> $k = this.getK();
        result = result * 59 + ($k == null ? 43 : $k.hashCode());
        ParameterSpace<Double> $sparsity = this.getSparsity();
        result = result * 59 + ($sparsity == null ? 43 : $sparsity.hashCode());
        return result;
    }

    private RBMLayerSpace() {
    }

    public static class Builder
    extends BasePretrainNetworkLayerSpace.Builder<Builder> {
        private ParameterSpace<RBM.HiddenUnit> hiddenUnit;
        private ParameterSpace<RBM.VisibleUnit> visibleUnit;
        private ParameterSpace<Integer> k;
        private ParameterSpace<Double> sparsity;

        public Builder hiddenUnit(RBM.HiddenUnit hiddenUnit) {
            return this.hiddenUnit((ParameterSpace<RBM.HiddenUnit>)new FixedValue((Object)hiddenUnit));
        }

        public Builder hiddenUnit(ParameterSpace<RBM.HiddenUnit> hiddenUnit) {
            this.hiddenUnit = hiddenUnit;
            return this;
        }

        public Builder visibleUnit(RBM.VisibleUnit visibleUnit) {
            return this.visibleUnit((ParameterSpace<RBM.VisibleUnit>)new FixedValue((Object)visibleUnit));
        }

        public Builder visibleUnit(ParameterSpace<RBM.VisibleUnit> visibleUnit) {
            this.visibleUnit = visibleUnit;
            return this;
        }

        public Builder k(int k) {
            return this.k((ParameterSpace<Integer>)new FixedValue((Object)k));
        }

        public Builder k(ParameterSpace<Integer> k) {
            this.k = k;
            return this;
        }

        public Builder sparsity(double sparsity) {
            return this.sparsity((ParameterSpace<Double>)new FixedValue((Object)sparsity));
        }

        public Builder sparsity(ParameterSpace<Double> sparsity) {
            this.sparsity = sparsity;
            return this;
        }

        @Override
        public RBMLayerSpace build() {
            return new RBMLayerSpace(this);
        }
    }
}

