/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;

public class SubsamplingLayerSpace
extends LayerSpace<SubsamplingLayer> {
    protected ParameterSpace<SubsamplingLayer.PoolingType> poolingType;
    protected ParameterSpace<int[]> kernelSize;
    protected ParameterSpace<int[]> stride;
    protected ParameterSpace<int[]> padding;

    private SubsamplingLayerSpace(Builder builder) {
        super(builder);
        this.poolingType = builder.poolingType;
        this.kernelSize = builder.kernelSize;
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.poolingType != null) {
            list.addAll(this.poolingType.collectLeaves());
        }
        if (this.kernelSize != null) {
            list.addAll(this.kernelSize.collectLeaves());
        }
        if (this.stride != null) {
            list.addAll(this.stride.collectLeaves());
        }
        if (this.padding != null) {
            list.addAll(this.padding.collectLeaves());
        }
        return list;
    }

    public SubsamplingLayer getValue(double[] values) {
        SubsamplingLayer.Builder b = new SubsamplingLayer.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(SubsamplingLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.poolingType != null) {
            builder.poolingType((SubsamplingLayer.PoolingType)this.poolingType.getValue(values));
        }
        if (this.kernelSize != null) {
            builder.kernelSize((int[])this.kernelSize.getValue(values));
        }
        if (this.stride != null) {
            builder.stride((int[])this.stride.getValue(values));
        }
        if (this.padding != null) {
            builder.padding((int[])this.padding.getValue(values));
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("SubsamplingLayerSpace(");
        if (this.poolingType != null) {
            sb.append("poolingType: ").append(this.poolingType).append(delim);
        }
        if (this.kernelSize != null) {
            sb.append("kernelSize: ").append(this.kernelSize).append(delim);
        }
        if (this.stride != null) {
            sb.append("stride: ").append(this.stride).append(delim);
        }
        if (this.padding != null) {
            sb.append("padding: ").append(this.padding).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<SubsamplingLayer.PoolingType> getPoolingType() {
        return this.poolingType;
    }

    public ParameterSpace<int[]> getKernelSize() {
        return this.kernelSize;
    }

    public ParameterSpace<int[]> getStride() {
        return this.stride;
    }

    public ParameterSpace<int[]> getPadding() {
        return this.padding;
    }

    public void setPoolingType(ParameterSpace<SubsamplingLayer.PoolingType> poolingType) {
        this.poolingType = poolingType;
    }

    public void setKernelSize(ParameterSpace<int[]> kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(ParameterSpace<int[]> stride) {
        this.stride = stride;
    }

    public void setPadding(ParameterSpace<int[]> padding) {
        this.padding = padding;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsamplingLayerSpace)) {
            return false;
        }
        SubsamplingLayerSpace other = (SubsamplingLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<SubsamplingLayer.PoolingType> this$poolingType = this.getPoolingType();
        ParameterSpace<SubsamplingLayer.PoolingType> other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !this$poolingType.equals(other$poolingType)) {
            return false;
        }
        ParameterSpace<int[]> this$kernelSize = this.getKernelSize();
        ParameterSpace<int[]> other$kernelSize = other.getKernelSize();
        if (this$kernelSize == null ? other$kernelSize != null : !this$kernelSize.equals(other$kernelSize)) {
            return false;
        }
        ParameterSpace<int[]> this$stride = this.getStride();
        ParameterSpace<int[]> other$stride = other.getStride();
        if (this$stride == null ? other$stride != null : !this$stride.equals(other$stride)) {
            return false;
        }
        ParameterSpace<int[]> this$padding = this.getPadding();
        ParameterSpace<int[]> other$padding = other.getPadding();
        return !(this$padding == null ? other$padding != null : !this$padding.equals(other$padding));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubsamplingLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<SubsamplingLayer.PoolingType> $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : $poolingType.hashCode());
        ParameterSpace<int[]> $kernelSize = this.getKernelSize();
        result = result * 59 + ($kernelSize == null ? 43 : $kernelSize.hashCode());
        ParameterSpace<int[]> $stride = this.getStride();
        result = result * 59 + ($stride == null ? 43 : $stride.hashCode());
        ParameterSpace<int[]> $padding = this.getPadding();
        result = result * 59 + ($padding == null ? 43 : $padding.hashCode());
        return result;
    }

    private SubsamplingLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<SubsamplingLayer.PoolingType> poolingType;
        protected ParameterSpace<int[]> kernelSize;
        protected ParameterSpace<int[]> stride;
        protected ParameterSpace<int[]> padding;

        public Builder poolingType(SubsamplingLayer.PoolingType poolingType) {
            return this.poolingType((ParameterSpace<SubsamplingLayer.PoolingType>)new FixedValue((Object)poolingType));
        }

        public Builder poolingType(ParameterSpace<SubsamplingLayer.PoolingType> poolingType) {
            this.poolingType = poolingType;
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            return this.kernelSize((ParameterSpace<int[]>)new FixedValue((Object)kernelSize));
        }

        public Builder kernelSize(ParameterSpace<int[]> kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            return this.stride((ParameterSpace<int[]>)new FixedValue((Object)stride));
        }

        public Builder stride(ParameterSpace<int[]> stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            return this.padding((ParameterSpace<int[]>)new FixedValue((Object)padding));
        }

        public Builder padding(ParameterSpace<int[]> padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public SubsamplingLayerSpace build() {
            return new SubsamplingLayerSpace(this);
        }
    }
}

