/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import org.deeplearning4j.arbiter.layers.BasePretrainNetworkLayerSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.CollectionUtils;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.variational.LossFunctionWrapper;
import org.deeplearning4j.nn.conf.layers.variational.ReconstructionDistribution;
import org.deeplearning4j.nn.conf.layers.variational.VariationalAutoencoder;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class VariationalAutoencoderLayerSpace
extends BasePretrainNetworkLayerSpace<VariationalAutoencoder> {
    private ParameterSpace<int[]> encoderLayerSizes;
    private ParameterSpace<int[]> decoderLayerSizes;
    private ParameterSpace<ReconstructionDistribution> outputDistribution;
    private ParameterSpace<IActivation> pzxActivationFn;
    private ParameterSpace<Integer> numSamples;

    protected VariationalAutoencoderLayerSpace(Builder builder) {
        super(builder);
        this.encoderLayerSizes = builder.encoderLayerSizes;
        this.decoderLayerSizes = builder.decoderLayerSizes;
        this.outputDistribution = builder.outputDistribution;
        this.pzxActivationFn = builder.pzxActivationFn;
        this.numSamples = builder.numSamples;
        this.numParameters = CollectionUtils.countUnique(this.collectLeaves());
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        if (this.encoderLayerSizes != null) {
            list.addAll(this.encoderLayerSizes.collectLeaves());
        }
        if (this.decoderLayerSizes != null) {
            list.addAll(this.decoderLayerSizes.collectLeaves());
        }
        if (this.outputDistribution != null) {
            list.addAll(this.outputDistribution.collectLeaves());
        }
        if (this.pzxActivationFn != null) {
            list.addAll(this.pzxActivationFn.collectLeaves());
        }
        if (this.numSamples != null) {
            list.addAll(this.numSamples.collectLeaves());
        }
        return list;
    }

    public VariationalAutoencoder getValue(double[] parameterValues) {
        VariationalAutoencoder.Builder b = new VariationalAutoencoder.Builder();
        this.setLayerOptionsBuilder(b, parameterValues);
        return b.build();
    }

    protected void setLayerOptionsBuilder(VariationalAutoencoder.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.encoderLayerSizes != null) {
            builder.encoderLayerSizes((int[])this.encoderLayerSizes.getValue(values));
        }
        if (this.decoderLayerSizes != null) {
            builder.decoderLayerSizes((int[])this.decoderLayerSizes.getValue(values));
        }
        if (this.outputDistribution != null) {
            builder.reconstructionDistribution((ReconstructionDistribution)this.outputDistribution.getValue(values));
        }
        if (this.pzxActivationFn != null) {
            builder.pzxActivationFn((IActivation)this.pzxActivationFn.getValue(values));
        }
        if (this.numSamples != null) {
            builder.numSamples(((Integer)this.numSamples.getValue(values)).intValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("VariationalAutoencoderLayerSpace(");
        if (this.encoderLayerSizes != null) {
            sb.append("encoderLayerSizes: ").append(this.encoderLayerSizes).append(delim);
        }
        if (this.decoderLayerSizes != null) {
            sb.append("decoderLayerSizes: ").append(this.decoderLayerSizes).append(delim);
        }
        if (this.outputDistribution != null) {
            sb.append("reconstructionDistribution: ").append(this.outputDistribution).append(delim);
        }
        if (this.pzxActivationFn != null) {
            sb.append("pzxActivationFn: ").append(this.pzxActivationFn).append(delim);
        }
        if (this.numSamples != null) {
            sb.append("numSamples: ").append(this.numSamples).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<int[]> getEncoderLayerSizes() {
        return this.encoderLayerSizes;
    }

    public ParameterSpace<int[]> getDecoderLayerSizes() {
        return this.decoderLayerSizes;
    }

    public ParameterSpace<ReconstructionDistribution> getOutputDistribution() {
        return this.outputDistribution;
    }

    public ParameterSpace<IActivation> getPzxActivationFn() {
        return this.pzxActivationFn;
    }

    public ParameterSpace<Integer> getNumSamples() {
        return this.numSamples;
    }

    public void setEncoderLayerSizes(ParameterSpace<int[]> encoderLayerSizes) {
        this.encoderLayerSizes = encoderLayerSizes;
    }

    public void setDecoderLayerSizes(ParameterSpace<int[]> decoderLayerSizes) {
        this.decoderLayerSizes = decoderLayerSizes;
    }

    public void setOutputDistribution(ParameterSpace<ReconstructionDistribution> outputDistribution) {
        this.outputDistribution = outputDistribution;
    }

    public void setPzxActivationFn(ParameterSpace<IActivation> pzxActivationFn) {
        this.pzxActivationFn = pzxActivationFn;
    }

    public void setNumSamples(ParameterSpace<Integer> numSamples) {
        this.numSamples = numSamples;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariationalAutoencoderLayerSpace)) {
            return false;
        }
        VariationalAutoencoderLayerSpace other = (VariationalAutoencoderLayerSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<int[]> this$encoderLayerSizes = this.getEncoderLayerSizes();
        ParameterSpace<int[]> other$encoderLayerSizes = other.getEncoderLayerSizes();
        if (this$encoderLayerSizes == null ? other$encoderLayerSizes != null : !this$encoderLayerSizes.equals(other$encoderLayerSizes)) {
            return false;
        }
        ParameterSpace<int[]> this$decoderLayerSizes = this.getDecoderLayerSizes();
        ParameterSpace<int[]> other$decoderLayerSizes = other.getDecoderLayerSizes();
        if (this$decoderLayerSizes == null ? other$decoderLayerSizes != null : !this$decoderLayerSizes.equals(other$decoderLayerSizes)) {
            return false;
        }
        ParameterSpace<ReconstructionDistribution> this$outputDistribution = this.getOutputDistribution();
        ParameterSpace<ReconstructionDistribution> other$outputDistribution = other.getOutputDistribution();
        if (this$outputDistribution == null ? other$outputDistribution != null : !this$outputDistribution.equals(other$outputDistribution)) {
            return false;
        }
        ParameterSpace<IActivation> this$pzxActivationFn = this.getPzxActivationFn();
        ParameterSpace<IActivation> other$pzxActivationFn = other.getPzxActivationFn();
        if (this$pzxActivationFn == null ? other$pzxActivationFn != null : !this$pzxActivationFn.equals(other$pzxActivationFn)) {
            return false;
        }
        ParameterSpace<Integer> this$numSamples = this.getNumSamples();
        ParameterSpace<Integer> other$numSamples = other.getNumSamples();
        return !(this$numSamples == null ? other$numSamples != null : !this$numSamples.equals(other$numSamples));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VariationalAutoencoderLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<int[]> $encoderLayerSizes = this.getEncoderLayerSizes();
        result = result * 59 + ($encoderLayerSizes == null ? 43 : $encoderLayerSizes.hashCode());
        ParameterSpace<int[]> $decoderLayerSizes = this.getDecoderLayerSizes();
        result = result * 59 + ($decoderLayerSizes == null ? 43 : $decoderLayerSizes.hashCode());
        ParameterSpace<ReconstructionDistribution> $outputDistribution = this.getOutputDistribution();
        result = result * 59 + ($outputDistribution == null ? 43 : $outputDistribution.hashCode());
        ParameterSpace<IActivation> $pzxActivationFn = this.getPzxActivationFn();
        result = result * 59 + ($pzxActivationFn == null ? 43 : $pzxActivationFn.hashCode());
        ParameterSpace<Integer> $numSamples = this.getNumSamples();
        result = result * 59 + ($numSamples == null ? 43 : $numSamples.hashCode());
        return result;
    }

    private VariationalAutoencoderLayerSpace() {
    }

    public static class Builder
    extends BasePretrainNetworkLayerSpace.Builder<Builder> {
        private ParameterSpace<int[]> encoderLayerSizes;
        private ParameterSpace<int[]> decoderLayerSizes;
        private ParameterSpace<ReconstructionDistribution> outputDistribution;
        private ParameterSpace<IActivation> pzxActivationFn;
        private ParameterSpace<Integer> numSamples;

        public Builder encoderLayerSizes(int ... encoderLayerSizes) {
            return this.encoderLayerSizes((ParameterSpace<int[]>)new FixedValue((Object)encoderLayerSizes));
        }

        public Builder encoderLayerSizes(ParameterSpace<int[]> encoderLayerSizes) {
            this.encoderLayerSizes = encoderLayerSizes;
            return this;
        }

        public Builder decoderLayerSizes(int ... decoderLayerSizes) {
            return this.decoderLayerSizes((ParameterSpace<int[]>)new FixedValue((Object)decoderLayerSizes));
        }

        public Builder decoderLayerSizes(ParameterSpace<int[]> decoderLayerSizes) {
            this.decoderLayerSizes = decoderLayerSizes;
            return this;
        }

        public Builder reconstructionDistribution(ReconstructionDistribution distribution) {
            return this.reconstructionDistribution((ParameterSpace<ReconstructionDistribution>)new FixedValue((Object)distribution));
        }

        public Builder reconstructionDistribution(ParameterSpace<ReconstructionDistribution> distribution) {
            this.outputDistribution = distribution;
            return this;
        }

        public Builder lossFunction(IActivation outputActivationFn, LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(outputActivationFn, lossFunction.getILossFunction());
        }

        public Builder lossFunction(Activation outputActivationFn, LossFunctions.LossFunction lossFunction) {
            return this.lossFunction(outputActivationFn.getActivationFunction(), lossFunction.getILossFunction());
        }

        public Builder lossFunction(IActivation outputActivationFn, ILossFunction lossFunction) {
            return this.reconstructionDistribution((ReconstructionDistribution)new LossFunctionWrapper(outputActivationFn, lossFunction));
        }

        public Builder pzxActivationFn(IActivation activationFunction) {
            return this.pzxActivationFn((ParameterSpace<IActivation>)new FixedValue((Object)activationFunction));
        }

        public Builder pzxActivationFn(ParameterSpace<IActivation> activationFunction) {
            this.pzxActivationFn = activationFunction;
            return this;
        }

        public Builder pzxActivationFunction(Activation activation) {
            return this.pzxActivationFn(activation.getActivationFunction());
        }

        public Builder numSamples(int numSamples) {
            return this.numSamples((ParameterSpace<Integer>)new FixedValue((Object)numSamples));
        }

        public Builder numSamples(ParameterSpace<Integer> numSamples) {
            this.numSamples = numSamples;
            return this;
        }

        @Override
        public <E extends LayerSpace> E build() {
            return (E)new VariationalAutoencoderLayerSpace(this);
        }
    }
}

