/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.listener;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.deeplearning4j.arbiter.optimize.runner.Status;
import org.deeplearning4j.arbiter.optimize.runner.listener.candidate.UICandidateStatusListener;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.listener.EarlyStoppingListener;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.components.chart.ChartLine;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.deeplearning4j.ui.components.decorator.DecoratorAccordion;
import org.deeplearning4j.ui.components.decorator.style.StyleAccordion;
import org.deeplearning4j.ui.components.table.ComponentTable;
import org.deeplearning4j.ui.components.table.style.StyleTable;

public abstract class BaseUIStatusReportingListener<T extends Model>
implements EarlyStoppingListener<T>,
IterationListener {
    private static final StyleChart styleChart = ((StyleChart.Builder)((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(650.0, LengthUnit.Px)).height(350.0, LengthUnit.Px)).backgroundColor(Color.WHITE)).build();
    private static final StyleAccordion styleAccordion = ((StyleAccordion.Builder)new StyleAccordion.Builder().backgroundColor(Color.WHITE)).build();
    private static final StyleTable styleTable = new StyleTable.Builder().backgroundColor(Color.WHITE).borderWidth(1).columnWidths(LengthUnit.Percent, new double[]{33.0, 33.0, 34.0}).build();
    public static final int MAX_REPORTING_FREQUENCY_MS = 5000;
    public static final int MAX_SCORE_COMPONENTS = 4000;
    protected UICandidateStatusListener uiListener;
    protected boolean invoked = false;
    protected long lastReportTime = 0L;
    protected int recordEveryNthScore = 1;
    protected long scoreCount = 0L;
    protected List<Double> scoreList = new ArrayList<Double>(4000);
    protected List<Long> iterationList = new ArrayList<Long>(4000);
    protected List<Pair<Integer, Double>> scoreVsEpochEarlyStopping = new ArrayList<Pair<Integer, Double>>();
    protected Component config;

    public BaseUIStatusReportingListener(UICandidateStatusListener listener) {
        this.uiListener = listener;
    }

    public void onStart(EarlyStoppingConfiguration<T> esConfig, T net) {
        if (this.config == null) {
            this.createConfigComponent(net);
        }
        this.postReport(Status.Running, null, new Component[0]);
    }

    public void onEpoch(int epochNum, double score, EarlyStoppingConfiguration<T> esConfig, T net) {
        if (this.config == null) {
            this.createConfigComponent(net);
        }
        this.scoreVsEpochEarlyStopping.add((Pair<Integer, Double>)new Pair((Object)epochNum, (Object)score));
        this.postReport(Status.Running, null, this.createEarlyStoppingScoreVsEpochChart());
    }

    public void onCompletion(EarlyStoppingResult<T> esResult) {
        if (this.config == null) {
            this.createConfigComponent(esResult.getBestModel());
        }
    }

    private Component createEarlyStoppingScoreVsEpochChart() {
        double[] x = new double[this.scoreVsEpochEarlyStopping.size()];
        double[] y = new double[this.scoreVsEpochEarlyStopping.size()];
        int i = 0;
        for (Pair<Integer, Double> p : this.scoreVsEpochEarlyStopping) {
            x[i] = ((Integer)p.getFirst()).intValue();
            y[i] = (Double)p.getSecond();
            ++i;
        }
        return new ChartLine.Builder("Early Stopping: Score vs. Epoch", styleChart).addSeries("Score vs. Epoch", x, y).build();
    }

    public boolean invoked() {
        return this.invoked;
    }

    public void invoke() {
        this.invoked = true;
    }

    public void iterationDone(Model model, int iteration) {
        if (this.config == null) {
            this.createConfigComponent(model);
        }
        double score = model.score();
        if (this.scoreList.size() <= 4000) {
            if (this.scoreCount % (long)this.recordEveryNthScore == 0L) {
                this.scoreList.add(score);
                this.iterationList.add(this.scoreCount);
            }
            ++this.scoreCount;
        } else {
            this.recordEveryNthScore *= 2;
            ArrayList<Double> newScoreList = new ArrayList<Double>(4000);
            ArrayList<Long> newIterationList = new ArrayList<Long>(4000);
            Iterator<Double> sIter = this.scoreList.iterator();
            Iterator<Long> iIter = this.iterationList.iterator();
            int i = 0;
            while (sIter.hasNext()) {
                if (i++ % 2 == 0) {
                    newScoreList.add(sIter.next());
                    newIterationList.add(iIter.next());
                    continue;
                }
                sIter.next();
                iIter.next();
            }
            this.scoreList = newScoreList;
            this.iterationList = newIterationList;
        }
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastReportTime > 5000L) {
            this.postReport(Status.Running, null, new Component[0]);
        }
    }

    protected abstract void createConfigComponent(T var1);

    public void postReport(Status status, EarlyStoppingResult<T> esResult, Component ... additionalComponents) {
        double[] x = new double[this.scoreList.size()];
        double[] y = new double[this.scoreList.size()];
        Iterator<Double> sIter = this.scoreList.iterator();
        Iterator<Long> iIter = this.iterationList.iterator();
        for (int i = 0; sIter.hasNext() && i < x.length; ++i) {
            y[i] = sIter.next();
            x[i] = iIter.next().longValue();
        }
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(new DecoratorAccordion.Builder("Network Configuration", styleAccordion).addComponents(new Component[]{this.config}).build());
        ChartLine scoreVsIterGraph = new ChartLine.Builder("Score vs. Iteration (Loss Function Value for Current Minibatch)", styleChart).addSeries("Minibatch Score vs. Iteration", x, y).build();
        components.add(scoreVsIterGraph);
        if (esResult != null) {
            int bestEpoch = esResult.getBestModelEpoch();
            String[][] table = new String[][]{{"Termination reason:", esResult.getTerminationReason().toString()}, {"Termination details:", esResult.getTerminationDetails()}, {"Best model epoch:", bestEpoch < 0 ? "n/a" : String.valueOf(bestEpoch)}, {"Best model score:", bestEpoch < 0 ? "n/a" : String.valueOf(esResult.getBestModelScore())}, {"Total epochs:", String.valueOf(esResult.getTotalEpochs())}};
            ComponentTable rcTable = new ComponentTable.Builder(styleTable).content(table).build();
            components.add(rcTable);
        }
        if (additionalComponents != null) {
            Collections.addAll(components, additionalComponents);
        }
        this.uiListener.reportStatus(status, components.toArray(new Component[components.size()]));
        this.lastReportTime = System.currentTimeMillis();
    }
}

