/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.saver.local.graph;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver;
import org.deeplearning4j.arbiter.saver.local.graph.LocalFileGraphResultReference;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalComputationGraphSaver<A>
implements ResultSaver<GraphConfiguration, ComputationGraph, A> {
    private static Logger log = LoggerFactory.getLogger(LocalComputationGraphSaver.class);
    private String path;
    private File fPath;

    public LocalComputationGraphSaver(String path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.path = path;
        this.fPath = new File(path);
        File baseDirectory = new File(path);
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("Invalid path: is not directory. " + path);
        }
        log.info("LocalComputationGraphSaver saving networks to local directory: {}", (Object)path);
    }

    public ResultReference<GraphConfiguration, ComputationGraph, A> saveModel(OptimizationResult<GraphConfiguration, ComputationGraph, A> result) throws IOException {
        EarlyStoppingConfiguration<ComputationGraph> esc;
        Object additionalResults;
        Throwable throwable;
        String dir = new File(this.path, result.getIndex() + "/").getAbsolutePath();
        File f = new File(dir);
        f.mkdir();
        File paramsFile = new File(FilenameUtils.concat((String)dir, (String)"params.bin"));
        File jsonFile = new File(FilenameUtils.concat((String)dir, (String)"config.json"));
        File scoreFile = new File(FilenameUtils.concat((String)dir, (String)"score.txt"));
        File additionalResultsFile = new File(FilenameUtils.concat((String)dir, (String)"additionalResults.bin"));
        File esConfigFile = new File(FilenameUtils.concat((String)dir, (String)"earlyStoppingConfig.bin"));
        File numEpochsFile = new File(FilenameUtils.concat((String)dir, (String)"numEpochs.txt"));
        FileUtils.writeStringToFile((File)scoreFile, (String)String.valueOf(result.getScore()));
        String jsonConfig = ((GraphConfiguration)result.getCandidate().getValue()).getConfiguration().toJson();
        FileUtils.writeStringToFile((File)jsonFile, (String)jsonConfig);
        if (result.getResult() != null) {
            INDArray params = ((ComputationGraph)result.getResult()).params();
            throwable = null;
            try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(paramsFile.toPath(), new OpenOption[0]));){
                Nd4j.write((INDArray)params, (DataOutputStream)dos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if ((additionalResults = result.getModelSpecificResults()) != null) {
            throwable = null;
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(additionalResultsFile));){
                oos.writeObject(additionalResults);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        if ((esc = ((GraphConfiguration)result.getCandidate().getValue()).getEarlyStoppingConfiguration()) != null) {
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(esConfigFile));){
                oos.writeObject(esc);
            }
        } else {
            int nEpochs = ((GraphConfiguration)result.getCandidate().getValue()).getNumEpochs();
            FileUtils.writeStringToFile((File)numEpochsFile, (String)String.valueOf(nEpochs));
        }
        log.debug("Deeplearning4j model result (id={}, score={}) saved to directory: {}", new Object[]{result.getIndex(), result.getScore(), dir});
        return new LocalFileGraphResultReference(result.getIndex(), dir, jsonFile, paramsFile, scoreFile, additionalResultsFile, esConfigFile, numEpochsFile, (Candidate<GraphConfiguration>)result.getCandidate());
    }

    public String toString() {
        return "LocalMultiLayerNetworkScoreSaver(path=" + this.fPath.getAbsolutePath() + ")";
    }
}

