/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.saver.local.multilayer;

import java.beans.ConstructorProperties;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.arbiter.DL4JConfiguration;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class LocalFileMultiLayerNetworkResultReference<A>
implements ResultReference<DL4JConfiguration, MultiLayerNetwork, A> {
    private int index;
    private String dir;
    private File configFile;
    private File networkParamsFile;
    private File scoreFile;
    private File additionalResultsFile;
    private File esConfigFile;
    private File numEpochsFile;
    private Candidate<DL4JConfiguration> candidate;

    public OptimizationResult<DL4JConfiguration, MultiLayerNetwork, A> getResult() throws IOException {
        Object additionalResults;
        double d;
        MultiLayerNetwork net;
        block45: {
            INDArray params;
            String jsonConfig = FileUtils.readFileToString((File)this.configFile);
            try (DataInputStream dis = new DataInputStream(new FileInputStream(this.networkParamsFile));){
                params = Nd4j.read((DataInputStream)dis);
            }
            MultiLayerConfiguration conf = MultiLayerConfiguration.fromJson((String)jsonConfig);
            net = new MultiLayerNetwork(conf);
            net.init();
            net.setParams(params);
            String scoreStr = FileUtils.readFileToString((File)this.scoreFile);
            d = Double.parseDouble(scoreStr);
            EarlyStoppingConfiguration earlyStoppingConfiguration = null;
            if (this.esConfigFile != null && this.esConfigFile.exists()) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.esConfigFile));){
                    earlyStoppingConfiguration = (EarlyStoppingConfiguration)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading early stopping configuration", e);
                }
            }
            int nEpochs = 1;
            if (this.numEpochsFile != null && this.numEpochsFile.exists()) {
                String numEpochs = FileUtils.readFileToString((File)this.numEpochsFile);
                nEpochs = Integer.parseInt(numEpochs);
            }
            DL4JConfiguration dl4JConfiguration = new DL4JConfiguration(conf, earlyStoppingConfiguration, nEpochs);
            if (this.additionalResultsFile.exists()) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.additionalResultsFile));){
                    additionalResults = ois.readObject();
                    break block45;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading additional results", e);
                }
            }
            additionalResults = null;
        }
        return new OptimizationResult(this.candidate, (Object)net, Double.valueOf(d), this.index, additionalResults);
    }

    public String toString() {
        return "LocalFileGraphResultReference(" + this.dir + ")";
    }

    @ConstructorProperties(value={"index", "dir", "configFile", "networkParamsFile", "scoreFile", "additionalResultsFile", "esConfigFile", "numEpochsFile", "candidate"})
    public LocalFileMultiLayerNetworkResultReference(int index, String dir, File configFile, File networkParamsFile, File scoreFile, File additionalResultsFile, File esConfigFile, File numEpochsFile, Candidate<DL4JConfiguration> candidate) {
        this.index = index;
        this.dir = dir;
        this.configFile = configFile;
        this.networkParamsFile = networkParamsFile;
        this.scoreFile = scoreFile;
        this.additionalResultsFile = additionalResultsFile;
        this.esConfigFile = esConfigFile;
        this.numEpochsFile = numEpochsFile;
        this.candidate = candidate;
    }
}

