/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring;

import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.scoring.RegressionValue;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetAccuracyScoreFunction;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetAccuracyScoreFunctionDataSet;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetF1ScoreFunction;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetF1ScoreFunctionDataSet;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetLossScoreFunction;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetLossScoreFunctionDataSet;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetRegressionScoreFunction;
import org.deeplearning4j.arbiter.scoring.graph.GraphTestSetRegressionScoreFunctionDataSet;
import org.deeplearning4j.arbiter.scoring.multilayer.TestSetAccuracyScoreFunction;
import org.deeplearning4j.arbiter.scoring.multilayer.TestSetF1ScoreFunction;
import org.deeplearning4j.arbiter.scoring.multilayer.TestSetLossScoreFunction;
import org.deeplearning4j.arbiter.scoring.multilayer.TestSetRegressionScoreFunction;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class ScoreFunctions {
    private ScoreFunctions() {
    }

    public static ScoreFunction<MultiLayerNetwork, DataSetIterator> testSetLoss(boolean average) {
        return new TestSetLossScoreFunction(average);
    }

    public static ScoreFunction<ComputationGraph, MultiDataSetIterator> testSetLossGraph(boolean average) {
        return new GraphTestSetLossScoreFunction(average);
    }

    public static ScoreFunction<ComputationGraph, DataSetIterator> testSetLossGraphDataSet(boolean average) {
        return new GraphTestSetLossScoreFunctionDataSet(average);
    }

    public static ScoreFunction<MultiLayerNetwork, DataSetIterator> testSetAccuracy() {
        return new TestSetAccuracyScoreFunction();
    }

    public static ScoreFunction<ComputationGraph, MultiDataSetIterator> testSetAccuracyGraph() {
        return new GraphTestSetAccuracyScoreFunction();
    }

    public static ScoreFunction<ComputationGraph, DataSetIterator> testSetAccuracyGraphDataSet() {
        return new GraphTestSetAccuracyScoreFunctionDataSet();
    }

    public static ScoreFunction<MultiLayerNetwork, DataSetIterator> testSetF1() {
        return new TestSetF1ScoreFunction();
    }

    public static ScoreFunction<ComputationGraph, MultiDataSetIterator> testSetF1Graph() {
        return new GraphTestSetF1ScoreFunction();
    }

    public static ScoreFunction<ComputationGraph, DataSetIterator> testSetF1GraphDataSet() {
        return new GraphTestSetF1ScoreFunctionDataSet();
    }

    public static ScoreFunction<MultiLayerNetwork, DataSetIterator> testSetRegression(RegressionValue regressionValue) {
        return new TestSetRegressionScoreFunction(regressionValue);
    }

    public static ScoreFunction<ComputationGraph, MultiDataSetIterator> testSetRegressionGraph(RegressionValue regressionValue) {
        return new GraphTestSetRegressionScoreFunction(regressionValue);
    }

    public static ScoreFunction<ComputationGraph, DataSetIterator> testSetRegressionGraphDataSet(RegressionValue regressionValue) {
        return new GraphTestSetRegressionScoreFunctionDataSet(regressionValue);
    }
}

