/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring.graph;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public abstract class BaseGraphTestSetEvaluationScoreFunctionDataSet
implements ScoreFunction<ComputationGraph, DataSetIterator> {
    protected Evaluation getEvaluation(ComputationGraph model, DataProvider<DataSetIterator> dataProvider, Map<String, Object> dataParameters) {
        if (model.getNumOutputArrays() != 1) {
            throw new IllegalStateException("GraphSetSetAccuracyScoreFunctionDataSet cannot be applied to ComputationGraphs with more than one output. NumOutputs = " + model.getNumOutputArrays());
        }
        DataSetIterator testData = (DataSetIterator)dataProvider.testData(dataParameters);
        Evaluation evaluation = new Evaluation();
        while (testData.hasNext()) {
            DataSet next = (DataSet)testData.next();
            if (next.hasMaskArrays()) {
                INDArray[] iNDArrayArray;
                INDArray[] iNDArrayArray2;
                INDArray fMask = next.getFeaturesMaskArray();
                INDArray lMask = next.getLabelsMaskArray();
                if (fMask == null) {
                    iNDArrayArray2 = null;
                } else {
                    INDArray[] iNDArrayArray3 = new INDArray[1];
                    iNDArrayArray2 = iNDArrayArray3;
                    iNDArrayArray3[0] = fMask;
                }
                INDArray[] fMasks = iNDArrayArray2;
                if (lMask == null) {
                    iNDArrayArray = null;
                } else {
                    INDArray[] iNDArrayArray4 = new INDArray[1];
                    iNDArrayArray = iNDArrayArray4;
                    iNDArrayArray4[0] = lMask;
                }
                INDArray[] lMasks = iNDArrayArray;
                model.setLayerMaskArrays(fMasks, lMasks);
                INDArray out = model.output(new INDArray[]{next.getFeatures()})[0];
                if (lMask != null) {
                    evaluation.evalTimeSeries(next.getLabels(), out, lMask);
                } else {
                    evaluation.evalTimeSeries(next.getLabels(), out);
                }
                model.clearLayerMaskArrays();
                continue;
            }
            INDArray out = model.output(false, new INDArray[]{next.getFeatures()})[0];
            if (next.getLabels().rank() == 3) {
                evaluation.evalTimeSeries(next.getLabels(), out);
                continue;
            }
            evaluation.eval(next.getLabels(), out);
        }
        return evaluation;
    }

    public boolean minimize() {
        return false;
    }

    public abstract String toString();
}

