/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring.multilayer;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class TestSetLossScoreFunction
implements ScoreFunction<MultiLayerNetwork, DataSetIterator> {
    private final boolean average;

    public TestSetLossScoreFunction() {
        this(true);
    }

    public TestSetLossScoreFunction(boolean average) {
        this.average = average;
    }

    public double score(MultiLayerNetwork model, DataProvider<DataSetIterator> dataProvider, Map<String, Object> dataParameters) {
        DataSetIterator testData = (DataSetIterator)dataProvider.testData(dataParameters);
        double sumScore = 0.0;
        int totalExamples = 0;
        while (testData.hasNext()) {
            DataSet ds = (DataSet)testData.next();
            int numExamples = ds.numExamples();
            sumScore += (double)numExamples * model.score(ds);
            totalExamples += numExamples;
        }
        if (!this.average) {
            return sumScore;
        }
        return sumScore / (double)totalExamples;
    }

    public boolean minimize() {
        return true;
    }

    public String toString() {
        return "TestSetLossScoreFunction()";
    }
}

