/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.ComputationGraphSpace;
import org.deeplearning4j.arbiter.MultiLayerSpace;
import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper;
import org.deeplearning4j.arbiter.optimize.serde.jackson.YamlMapper;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class BaseNetworkSpace<T>
extends AbstractParameterSpace<T> {
    protected ParameterSpace<Boolean> useDropConnect;
    protected ParameterSpace<Integer> iterations;
    protected Long seed;
    protected ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
    protected ParameterSpace<Boolean> regularization;
    protected ParameterSpace<Boolean> schedules;
    protected ParameterSpace<IActivation> activationFunction;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<Double> biasLearningRate;
    protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
    protected ParameterSpace<Double> lrScoreBasedDecay;
    protected ParameterSpace<LearningRatePolicy> learningRateDecayPolicy;
    protected ParameterSpace<Map<Integer, Double>> learningRateSchedule;
    protected ParameterSpace<Double> lrPolicyDecayRate;
    protected ParameterSpace<Double> lrPolicyPower;
    protected ParameterSpace<Double> lrPolicySteps;
    protected ParameterSpace<Integer> maxNumLineSearchIterations;
    protected ParameterSpace<Boolean> miniBatch;
    protected ParameterSpace<Boolean> minimize;
    protected ParameterSpace<StepFunction> stepFunction;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> dropOut;
    protected ParameterSpace<Double> momentum;
    protected ParameterSpace<Map<Integer, Double>> momentumAfter;
    protected ParameterSpace<Updater> updater;
    protected ParameterSpace<Double> epsilon;
    protected ParameterSpace<Double> rho;
    protected ParameterSpace<Double> rmsDecay;
    protected ParameterSpace<Double> adamMeanDecay;
    protected ParameterSpace<Double> adamVarDecay;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected List<LayerConf> layerSpaces = new ArrayList<LayerConf>();
    protected ParameterSpace<Boolean> backprop;
    protected ParameterSpace<Boolean> pretrain;
    protected ParameterSpace<BackpropType> backpropType;
    protected ParameterSpace<Integer> tbpttFwdLength;
    protected ParameterSpace<Integer> tbpttBwdLength;
    protected ParameterSpace<ConvolutionMode> convolutionMode;
    protected int numEpochs = 1;

    protected BaseNetworkSpace(Builder builder) {
        this.useDropConnect = builder.useDropConnect;
        this.iterations = builder.iterations;
        this.seed = builder.seed;
        this.optimizationAlgo = builder.optimizationAlgo;
        this.regularization = builder.regularization;
        this.schedules = builder.schedules;
        this.activationFunction = builder.activationFunction;
        this.biasInit = builder.biasInit;
        this.weightInit = builder.weightInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateAfter = builder.learningRateAfter;
        this.lrScoreBasedDecay = builder.lrScoreBasedDecay;
        this.learningRateDecayPolicy = builder.learningRateDecayPolicy;
        this.learningRateSchedule = builder.learningRateSchedule;
        this.lrPolicyDecayRate = builder.lrPolicyDecayRate;
        this.lrPolicyPower = builder.lrPolicyPower;
        this.lrPolicySteps = builder.lrPolicySteps;
        this.maxNumLineSearchIterations = builder.maxNumLineSearchIterations;
        this.miniBatch = builder.miniBatch;
        this.minimize = builder.minimize;
        this.stepFunction = builder.stepFunction;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.dropOut = builder.dropOut;
        this.momentum = builder.momentum;
        this.momentumAfter = builder.momentumAfter;
        this.updater = builder.updater;
        this.epsilon = builder.epsilon;
        this.rho = builder.rho;
        this.rmsDecay = builder.rmsDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.convolutionMode = builder.convolutionMode;
        this.backprop = builder.backprop;
        this.pretrain = builder.pretrain;
        this.backpropType = builder.backpropType;
        this.tbpttFwdLength = builder.tbpttFwdLength;
        this.tbpttBwdLength = builder.tbpttBwdLength;
        this.numEpochs = builder.numEpochs;
    }

    protected BaseNetworkSpace() {
    }

    protected NeuralNetConfiguration.Builder randomGlobalConf(double[] values) {
        NeuralNetConfiguration.Builder builder = new NeuralNetConfiguration.Builder();
        if (this.useDropConnect != null) {
            builder.useDropConnect(((Boolean)this.useDropConnect.getValue(values)).booleanValue());
        }
        if (this.iterations != null) {
            builder.iterations(((Integer)this.iterations.getValue(values)).intValue());
        }
        if (this.seed != null) {
            builder.seed(this.seed.longValue());
        }
        if (this.optimizationAlgo != null) {
            builder.optimizationAlgo((OptimizationAlgorithm)this.optimizationAlgo.getValue(values));
        }
        if (this.regularization != null) {
            builder.regularization(((Boolean)this.regularization.getValue(values)).booleanValue());
        }
        if (this.activationFunction != null) {
            builder.activation((IActivation)this.activationFunction.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.learningRate != null) {
            builder.learningRate(((Double)this.learningRate.getValue(values)).doubleValue());
        }
        if (this.biasLearningRate != null) {
            builder.biasLearningRate(((Double)this.biasLearningRate.getValue(values)).doubleValue());
        }
        if (this.learningRateAfter != null) {
            builder.learningRateSchedule((Map)this.learningRateAfter.getValue(values));
        }
        if (this.lrScoreBasedDecay != null) {
            builder.learningRateScoreBasedDecayRate(((Double)this.lrScoreBasedDecay.getValue(values)).doubleValue());
        }
        if (this.learningRateDecayPolicy != null) {
            builder.learningRateDecayPolicy((LearningRatePolicy)this.learningRateDecayPolicy.getValue(values));
        }
        if (this.learningRateSchedule != null) {
            builder.learningRateSchedule((Map)this.learningRateSchedule.getValue(values));
        }
        if (this.lrPolicyDecayRate != null) {
            builder.lrPolicyDecayRate(((Double)this.lrPolicyDecayRate.getValue(values)).doubleValue());
        }
        if (this.lrPolicyPower != null) {
            builder.lrPolicyPower(((Double)this.lrPolicyPower.getValue(values)).doubleValue());
        }
        if (this.lrPolicySteps != null) {
            builder.lrPolicySteps(((Double)this.lrPolicySteps.getValue(values)).doubleValue());
        }
        if (this.maxNumLineSearchIterations != null) {
            builder.maxNumLineSearchIterations(((Integer)this.maxNumLineSearchIterations.getValue(values)).intValue());
        }
        if (this.miniBatch != null) {
            builder.miniBatch(((Boolean)this.miniBatch.getValue(values)).booleanValue());
        }
        if (this.minimize != null) {
            builder.minimize(((Boolean)this.minimize.getValue(values)).booleanValue());
        }
        if (this.stepFunction != null) {
            builder.stepFunction((StepFunction)this.stepFunction.getValue(values));
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.dropOut != null) {
            builder.dropOut(((Double)this.dropOut.getValue(values)).doubleValue());
        }
        if (this.momentum != null) {
            builder.momentum(((Double)this.momentum.getValue(values)).doubleValue());
        }
        if (this.momentumAfter != null) {
            builder.momentumAfter((Map)this.momentumAfter.getValue(values));
        }
        if (this.updater != null) {
            builder.updater((Updater)this.updater.getValue(values));
        }
        if (this.epsilon != null) {
            builder.epsilon(((Double)this.epsilon.getValue(values)).doubleValue());
        }
        if (this.rho != null) {
            builder.rho(((Double)this.rho.getValue(values)).doubleValue());
        }
        if (this.rmsDecay != null) {
            builder.rmsDecay(((Double)this.rmsDecay.getValue(values)).doubleValue());
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
        if (this.adamMeanDecay != null) {
            builder.adamMeanDecay(((Double)this.adamMeanDecay.getValue(values)).doubleValue());
        }
        if (this.adamVarDecay != null) {
            builder.adamVarDecay(((Double)this.adamVarDecay.getValue(values)).doubleValue());
        }
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
        return builder;
    }

    public List<ParameterSpace> collectLeaves() {
        Map global = this.getNestedSpaces();
        ArrayList<ParameterSpace> list = new ArrayList<ParameterSpace>();
        list.addAll(global.values());
        for (LayerConf layerConf : this.layerSpaces) {
            LayerSpace<?> ls = layerConf.getLayerSpace();
            list.addAll(ls.collectLeaves());
        }
        return list;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non leaf");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.getNestedSpaces().entrySet()) {
            sb.append((String)e.getKey()).append(": ").append(e.getValue()).append("\n");
        }
        int i = 0;
        for (LayerConf conf : this.layerSpaces) {
            sb.append("Layer config ").append(i++).append(": (Number layers:").append(conf.numLayers).append(", duplicate: ").append(conf.duplicateConfig).append("), ").append(conf.layerSpace.toString()).append("\n");
        }
        return sb.toString();
    }

    public String toJson() {
        try {
            return JsonMapper.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return YamlMapper.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseNetworkSpace)) {
            return false;
        }
        BaseNetworkSpace other = (BaseNetworkSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Boolean> this$useDropConnect = this.getUseDropConnect();
        ParameterSpace<Boolean> other$useDropConnect = other.getUseDropConnect();
        if (this$useDropConnect == null ? other$useDropConnect != null : !this$useDropConnect.equals(other$useDropConnect)) {
            return false;
        }
        ParameterSpace<Integer> this$iterations = this.getIterations();
        ParameterSpace<Integer> other$iterations = other.getIterations();
        if (this$iterations == null ? other$iterations != null : !this$iterations.equals(other$iterations)) {
            return false;
        }
        Long this$seed = this.getSeed();
        Long other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        ParameterSpace<OptimizationAlgorithm> this$optimizationAlgo = this.getOptimizationAlgo();
        ParameterSpace<OptimizationAlgorithm> other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !this$optimizationAlgo.equals(other$optimizationAlgo)) {
            return false;
        }
        ParameterSpace<Boolean> this$regularization = this.getRegularization();
        ParameterSpace<Boolean> other$regularization = other.getRegularization();
        if (this$regularization == null ? other$regularization != null : !this$regularization.equals(other$regularization)) {
            return false;
        }
        ParameterSpace<Boolean> this$schedules = this.getSchedules();
        ParameterSpace<Boolean> other$schedules = other.getSchedules();
        if (this$schedules == null ? other$schedules != null : !this$schedules.equals(other$schedules)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        ParameterSpace<Double> this$biasInit = this.getBiasInit();
        ParameterSpace<Double> other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !this$biasInit.equals(other$biasInit)) {
            return false;
        }
        ParameterSpace<WeightInit> this$weightInit = this.getWeightInit();
        ParameterSpace<WeightInit> other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !this$weightInit.equals(other$weightInit)) {
            return false;
        }
        ParameterSpace<Distribution> this$dist = this.getDist();
        ParameterSpace<Distribution> other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<Double> this$biasLearningRate = this.getBiasLearningRate();
        ParameterSpace<Double> other$biasLearningRate = other.getBiasLearningRate();
        if (this$biasLearningRate == null ? other$biasLearningRate != null : !this$biasLearningRate.equals(other$biasLearningRate)) {
            return false;
        }
        ParameterSpace<Map<Integer, Double>> this$learningRateAfter = this.getLearningRateAfter();
        ParameterSpace<Map<Integer, Double>> other$learningRateAfter = other.getLearningRateAfter();
        if (this$learningRateAfter == null ? other$learningRateAfter != null : !this$learningRateAfter.equals(other$learningRateAfter)) {
            return false;
        }
        ParameterSpace<Double> this$lrScoreBasedDecay = this.getLrScoreBasedDecay();
        ParameterSpace<Double> other$lrScoreBasedDecay = other.getLrScoreBasedDecay();
        if (this$lrScoreBasedDecay == null ? other$lrScoreBasedDecay != null : !this$lrScoreBasedDecay.equals(other$lrScoreBasedDecay)) {
            return false;
        }
        ParameterSpace<LearningRatePolicy> this$learningRateDecayPolicy = this.getLearningRateDecayPolicy();
        ParameterSpace<LearningRatePolicy> other$learningRateDecayPolicy = other.getLearningRateDecayPolicy();
        if (this$learningRateDecayPolicy == null ? other$learningRateDecayPolicy != null : !this$learningRateDecayPolicy.equals(other$learningRateDecayPolicy)) {
            return false;
        }
        ParameterSpace<Map<Integer, Double>> this$learningRateSchedule = this.getLearningRateSchedule();
        ParameterSpace<Map<Integer, Double>> other$learningRateSchedule = other.getLearningRateSchedule();
        if (this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule)) {
            return false;
        }
        ParameterSpace<Double> this$lrPolicyDecayRate = this.getLrPolicyDecayRate();
        ParameterSpace<Double> other$lrPolicyDecayRate = other.getLrPolicyDecayRate();
        if (this$lrPolicyDecayRate == null ? other$lrPolicyDecayRate != null : !this$lrPolicyDecayRate.equals(other$lrPolicyDecayRate)) {
            return false;
        }
        ParameterSpace<Double> this$lrPolicyPower = this.getLrPolicyPower();
        ParameterSpace<Double> other$lrPolicyPower = other.getLrPolicyPower();
        if (this$lrPolicyPower == null ? other$lrPolicyPower != null : !this$lrPolicyPower.equals(other$lrPolicyPower)) {
            return false;
        }
        ParameterSpace<Double> this$lrPolicySteps = this.getLrPolicySteps();
        ParameterSpace<Double> other$lrPolicySteps = other.getLrPolicySteps();
        if (this$lrPolicySteps == null ? other$lrPolicySteps != null : !this$lrPolicySteps.equals(other$lrPolicySteps)) {
            return false;
        }
        ParameterSpace<Integer> this$maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        ParameterSpace<Integer> other$maxNumLineSearchIterations = other.getMaxNumLineSearchIterations();
        if (this$maxNumLineSearchIterations == null ? other$maxNumLineSearchIterations != null : !this$maxNumLineSearchIterations.equals(other$maxNumLineSearchIterations)) {
            return false;
        }
        ParameterSpace<Boolean> this$miniBatch = this.getMiniBatch();
        ParameterSpace<Boolean> other$miniBatch = other.getMiniBatch();
        if (this$miniBatch == null ? other$miniBatch != null : !this$miniBatch.equals(other$miniBatch)) {
            return false;
        }
        ParameterSpace<Boolean> this$minimize = this.getMinimize();
        ParameterSpace<Boolean> other$minimize = other.getMinimize();
        if (this$minimize == null ? other$minimize != null : !this$minimize.equals(other$minimize)) {
            return false;
        }
        ParameterSpace<StepFunction> this$stepFunction = this.getStepFunction();
        ParameterSpace<StepFunction> other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        ParameterSpace<Double> this$l1 = this.getL1();
        ParameterSpace<Double> other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !this$l1.equals(other$l1)) {
            return false;
        }
        ParameterSpace<Double> this$l2 = this.getL2();
        ParameterSpace<Double> other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !this$l2.equals(other$l2)) {
            return false;
        }
        ParameterSpace<Double> this$dropOut = this.getDropOut();
        ParameterSpace<Double> other$dropOut = other.getDropOut();
        if (this$dropOut == null ? other$dropOut != null : !this$dropOut.equals(other$dropOut)) {
            return false;
        }
        ParameterSpace<Double> this$momentum = this.getMomentum();
        ParameterSpace<Double> other$momentum = other.getMomentum();
        if (this$momentum == null ? other$momentum != null : !this$momentum.equals(other$momentum)) {
            return false;
        }
        ParameterSpace<Map<Integer, Double>> this$momentumAfter = this.getMomentumAfter();
        ParameterSpace<Map<Integer, Double>> other$momentumAfter = other.getMomentumAfter();
        if (this$momentumAfter == null ? other$momentumAfter != null : !this$momentumAfter.equals(other$momentumAfter)) {
            return false;
        }
        ParameterSpace<Updater> this$updater = this.getUpdater();
        ParameterSpace<Updater> other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        ParameterSpace<Double> this$epsilon = this.getEpsilon();
        ParameterSpace<Double> other$epsilon = other.getEpsilon();
        if (this$epsilon == null ? other$epsilon != null : !this$epsilon.equals(other$epsilon)) {
            return false;
        }
        ParameterSpace<Double> this$rho = this.getRho();
        ParameterSpace<Double> other$rho = other.getRho();
        if (this$rho == null ? other$rho != null : !this$rho.equals(other$rho)) {
            return false;
        }
        ParameterSpace<Double> this$rmsDecay = this.getRmsDecay();
        ParameterSpace<Double> other$rmsDecay = other.getRmsDecay();
        if (this$rmsDecay == null ? other$rmsDecay != null : !this$rmsDecay.equals(other$rmsDecay)) {
            return false;
        }
        ParameterSpace<Double> this$adamMeanDecay = this.getAdamMeanDecay();
        ParameterSpace<Double> other$adamMeanDecay = other.getAdamMeanDecay();
        if (this$adamMeanDecay == null ? other$adamMeanDecay != null : !this$adamMeanDecay.equals(other$adamMeanDecay)) {
            return false;
        }
        ParameterSpace<Double> this$adamVarDecay = this.getAdamVarDecay();
        ParameterSpace<Double> other$adamVarDecay = other.getAdamVarDecay();
        if (this$adamVarDecay == null ? other$adamVarDecay != null : !this$adamVarDecay.equals(other$adamVarDecay)) {
            return false;
        }
        ParameterSpace<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        ParameterSpace<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        ParameterSpace<Double> this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        ParameterSpace<Double> other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !this$gradientNormalizationThreshold.equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        List<LayerConf> this$layerSpaces = this.getLayerSpaces();
        List<LayerConf> other$layerSpaces = other.getLayerSpaces();
        if (this$layerSpaces == null ? other$layerSpaces != null : !((Object)this$layerSpaces).equals(other$layerSpaces)) {
            return false;
        }
        ParameterSpace<Boolean> this$backprop = this.getBackprop();
        ParameterSpace<Boolean> other$backprop = other.getBackprop();
        if (this$backprop == null ? other$backprop != null : !this$backprop.equals(other$backprop)) {
            return false;
        }
        ParameterSpace<Boolean> this$pretrain = this.getPretrain();
        ParameterSpace<Boolean> other$pretrain = other.getPretrain();
        if (this$pretrain == null ? other$pretrain != null : !this$pretrain.equals(other$pretrain)) {
            return false;
        }
        ParameterSpace<BackpropType> this$backpropType = this.getBackpropType();
        ParameterSpace<BackpropType> other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !this$backpropType.equals(other$backpropType)) {
            return false;
        }
        ParameterSpace<Integer> this$tbpttFwdLength = this.getTbpttFwdLength();
        ParameterSpace<Integer> other$tbpttFwdLength = other.getTbpttFwdLength();
        if (this$tbpttFwdLength == null ? other$tbpttFwdLength != null : !this$tbpttFwdLength.equals(other$tbpttFwdLength)) {
            return false;
        }
        ParameterSpace<Integer> this$tbpttBwdLength = this.getTbpttBwdLength();
        ParameterSpace<Integer> other$tbpttBwdLength = other.getTbpttBwdLength();
        if (this$tbpttBwdLength == null ? other$tbpttBwdLength != null : !this$tbpttBwdLength.equals(other$tbpttBwdLength)) {
            return false;
        }
        ParameterSpace<ConvolutionMode> this$convolutionMode = this.getConvolutionMode();
        ParameterSpace<ConvolutionMode> other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !this$convolutionMode.equals(other$convolutionMode)) {
            return false;
        }
        return this.getNumEpochs() == other.getNumEpochs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseNetworkSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Boolean> $useDropConnect = this.getUseDropConnect();
        result = result * 59 + ($useDropConnect == null ? 43 : $useDropConnect.hashCode());
        ParameterSpace<Integer> $iterations = this.getIterations();
        result = result * 59 + ($iterations == null ? 43 : $iterations.hashCode());
        Long $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        ParameterSpace<OptimizationAlgorithm> $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : $optimizationAlgo.hashCode());
        ParameterSpace<Boolean> $regularization = this.getRegularization();
        result = result * 59 + ($regularization == null ? 43 : $regularization.hashCode());
        ParameterSpace<Boolean> $schedules = this.getSchedules();
        result = result * 59 + ($schedules == null ? 43 : $schedules.hashCode());
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        ParameterSpace<Double> $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : $biasInit.hashCode());
        ParameterSpace<WeightInit> $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : $weightInit.hashCode());
        ParameterSpace<Distribution> $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<Double> $biasLearningRate = this.getBiasLearningRate();
        result = result * 59 + ($biasLearningRate == null ? 43 : $biasLearningRate.hashCode());
        ParameterSpace<Map<Integer, Double>> $learningRateAfter = this.getLearningRateAfter();
        result = result * 59 + ($learningRateAfter == null ? 43 : $learningRateAfter.hashCode());
        ParameterSpace<Double> $lrScoreBasedDecay = this.getLrScoreBasedDecay();
        result = result * 59 + ($lrScoreBasedDecay == null ? 43 : $lrScoreBasedDecay.hashCode());
        ParameterSpace<LearningRatePolicy> $learningRateDecayPolicy = this.getLearningRateDecayPolicy();
        result = result * 59 + ($learningRateDecayPolicy == null ? 43 : $learningRateDecayPolicy.hashCode());
        ParameterSpace<Map<Integer, Double>> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        ParameterSpace<Double> $lrPolicyDecayRate = this.getLrPolicyDecayRate();
        result = result * 59 + ($lrPolicyDecayRate == null ? 43 : $lrPolicyDecayRate.hashCode());
        ParameterSpace<Double> $lrPolicyPower = this.getLrPolicyPower();
        result = result * 59 + ($lrPolicyPower == null ? 43 : $lrPolicyPower.hashCode());
        ParameterSpace<Double> $lrPolicySteps = this.getLrPolicySteps();
        result = result * 59 + ($lrPolicySteps == null ? 43 : $lrPolicySteps.hashCode());
        ParameterSpace<Integer> $maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        result = result * 59 + ($maxNumLineSearchIterations == null ? 43 : $maxNumLineSearchIterations.hashCode());
        ParameterSpace<Boolean> $miniBatch = this.getMiniBatch();
        result = result * 59 + ($miniBatch == null ? 43 : $miniBatch.hashCode());
        ParameterSpace<Boolean> $minimize = this.getMinimize();
        result = result * 59 + ($minimize == null ? 43 : $minimize.hashCode());
        ParameterSpace<StepFunction> $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        ParameterSpace<Double> $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : $l1.hashCode());
        ParameterSpace<Double> $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : $l2.hashCode());
        ParameterSpace<Double> $dropOut = this.getDropOut();
        result = result * 59 + ($dropOut == null ? 43 : $dropOut.hashCode());
        ParameterSpace<Double> $momentum = this.getMomentum();
        result = result * 59 + ($momentum == null ? 43 : $momentum.hashCode());
        ParameterSpace<Map<Integer, Double>> $momentumAfter = this.getMomentumAfter();
        result = result * 59 + ($momentumAfter == null ? 43 : $momentumAfter.hashCode());
        ParameterSpace<Updater> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        ParameterSpace<Double> $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : $epsilon.hashCode());
        ParameterSpace<Double> $rho = this.getRho();
        result = result * 59 + ($rho == null ? 43 : $rho.hashCode());
        ParameterSpace<Double> $rmsDecay = this.getRmsDecay();
        result = result * 59 + ($rmsDecay == null ? 43 : $rmsDecay.hashCode());
        ParameterSpace<Double> $adamMeanDecay = this.getAdamMeanDecay();
        result = result * 59 + ($adamMeanDecay == null ? 43 : $adamMeanDecay.hashCode());
        ParameterSpace<Double> $adamVarDecay = this.getAdamVarDecay();
        result = result * 59 + ($adamVarDecay == null ? 43 : $adamVarDecay.hashCode());
        ParameterSpace<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        ParameterSpace<Double> $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : $gradientNormalizationThreshold.hashCode());
        List<LayerConf> $layerSpaces = this.getLayerSpaces();
        result = result * 59 + ($layerSpaces == null ? 43 : ((Object)$layerSpaces).hashCode());
        ParameterSpace<Boolean> $backprop = this.getBackprop();
        result = result * 59 + ($backprop == null ? 43 : $backprop.hashCode());
        ParameterSpace<Boolean> $pretrain = this.getPretrain();
        result = result * 59 + ($pretrain == null ? 43 : $pretrain.hashCode());
        ParameterSpace<BackpropType> $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : $backpropType.hashCode());
        ParameterSpace<Integer> $tbpttFwdLength = this.getTbpttFwdLength();
        result = result * 59 + ($tbpttFwdLength == null ? 43 : $tbpttFwdLength.hashCode());
        ParameterSpace<Integer> $tbpttBwdLength = this.getTbpttBwdLength();
        result = result * 59 + ($tbpttBwdLength == null ? 43 : $tbpttBwdLength.hashCode());
        ParameterSpace<ConvolutionMode> $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : $convolutionMode.hashCode());
        result = result * 59 + this.getNumEpochs();
        return result;
    }

    public ParameterSpace<Boolean> getUseDropConnect() {
        return this.useDropConnect;
    }

    public ParameterSpace<Integer> getIterations() {
        return this.iterations;
    }

    public Long getSeed() {
        return this.seed;
    }

    public ParameterSpace<OptimizationAlgorithm> getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public ParameterSpace<Boolean> getRegularization() {
        return this.regularization;
    }

    public ParameterSpace<Boolean> getSchedules() {
        return this.schedules;
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public ParameterSpace<Double> getBiasInit() {
        return this.biasInit;
    }

    public ParameterSpace<WeightInit> getWeightInit() {
        return this.weightInit;
    }

    public ParameterSpace<Distribution> getDist() {
        return this.dist;
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<Double> getBiasLearningRate() {
        return this.biasLearningRate;
    }

    public ParameterSpace<Map<Integer, Double>> getLearningRateAfter() {
        return this.learningRateAfter;
    }

    public ParameterSpace<Double> getLrScoreBasedDecay() {
        return this.lrScoreBasedDecay;
    }

    public ParameterSpace<LearningRatePolicy> getLearningRateDecayPolicy() {
        return this.learningRateDecayPolicy;
    }

    public ParameterSpace<Map<Integer, Double>> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public ParameterSpace<Double> getLrPolicyDecayRate() {
        return this.lrPolicyDecayRate;
    }

    public ParameterSpace<Double> getLrPolicyPower() {
        return this.lrPolicyPower;
    }

    public ParameterSpace<Double> getLrPolicySteps() {
        return this.lrPolicySteps;
    }

    public ParameterSpace<Integer> getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public ParameterSpace<Boolean> getMiniBatch() {
        return this.miniBatch;
    }

    public ParameterSpace<Boolean> getMinimize() {
        return this.minimize;
    }

    public ParameterSpace<StepFunction> getStepFunction() {
        return this.stepFunction;
    }

    public ParameterSpace<Double> getL1() {
        return this.l1;
    }

    public ParameterSpace<Double> getL2() {
        return this.l2;
    }

    public ParameterSpace<Double> getDropOut() {
        return this.dropOut;
    }

    public ParameterSpace<Double> getMomentum() {
        return this.momentum;
    }

    public ParameterSpace<Map<Integer, Double>> getMomentumAfter() {
        return this.momentumAfter;
    }

    public ParameterSpace<Updater> getUpdater() {
        return this.updater;
    }

    public ParameterSpace<Double> getEpsilon() {
        return this.epsilon;
    }

    public ParameterSpace<Double> getRho() {
        return this.rho;
    }

    public ParameterSpace<Double> getRmsDecay() {
        return this.rmsDecay;
    }

    public ParameterSpace<Double> getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    public ParameterSpace<Double> getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public ParameterSpace<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public ParameterSpace<Double> getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public List<LayerConf> getLayerSpaces() {
        return this.layerSpaces;
    }

    public ParameterSpace<Boolean> getBackprop() {
        return this.backprop;
    }

    public ParameterSpace<Boolean> getPretrain() {
        return this.pretrain;
    }

    public ParameterSpace<BackpropType> getBackpropType() {
        return this.backpropType;
    }

    public ParameterSpace<Integer> getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public ParameterSpace<Integer> getTbpttBwdLength() {
        return this.tbpttBwdLength;
    }

    public ParameterSpace<ConvolutionMode> getConvolutionMode() {
        return this.convolutionMode;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public void setUseDropConnect(ParameterSpace<Boolean> useDropConnect) {
        this.useDropConnect = useDropConnect;
    }

    public void setIterations(ParameterSpace<Integer> iterations) {
        this.iterations = iterations;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(ParameterSpace<OptimizationAlgorithm> optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setRegularization(ParameterSpace<Boolean> regularization) {
        this.regularization = regularization;
    }

    public void setSchedules(ParameterSpace<Boolean> schedules) {
        this.schedules = schedules;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setBiasInit(ParameterSpace<Double> biasInit) {
        this.biasInit = biasInit;
    }

    public void setWeightInit(ParameterSpace<WeightInit> weightInit) {
        this.weightInit = weightInit;
    }

    public void setDist(ParameterSpace<Distribution> dist) {
        this.dist = dist;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setBiasLearningRate(ParameterSpace<Double> biasLearningRate) {
        this.biasLearningRate = biasLearningRate;
    }

    public void setLearningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
        this.learningRateAfter = learningRateAfter;
    }

    public void setLrScoreBasedDecay(ParameterSpace<Double> lrScoreBasedDecay) {
        this.lrScoreBasedDecay = lrScoreBasedDecay;
    }

    public void setLearningRateDecayPolicy(ParameterSpace<LearningRatePolicy> learningRateDecayPolicy) {
        this.learningRateDecayPolicy = learningRateDecayPolicy;
    }

    public void setLearningRateSchedule(ParameterSpace<Map<Integer, Double>> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    public void setLrPolicyDecayRate(ParameterSpace<Double> lrPolicyDecayRate) {
        this.lrPolicyDecayRate = lrPolicyDecayRate;
    }

    public void setLrPolicyPower(ParameterSpace<Double> lrPolicyPower) {
        this.lrPolicyPower = lrPolicyPower;
    }

    public void setLrPolicySteps(ParameterSpace<Double> lrPolicySteps) {
        this.lrPolicySteps = lrPolicySteps;
    }

    public void setMaxNumLineSearchIterations(ParameterSpace<Integer> maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setMiniBatch(ParameterSpace<Boolean> miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setMinimize(ParameterSpace<Boolean> minimize) {
        this.minimize = minimize;
    }

    public void setStepFunction(ParameterSpace<StepFunction> stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setL1(ParameterSpace<Double> l1) {
        this.l1 = l1;
    }

    public void setL2(ParameterSpace<Double> l2) {
        this.l2 = l2;
    }

    public void setDropOut(ParameterSpace<Double> dropOut) {
        this.dropOut = dropOut;
    }

    public void setMomentum(ParameterSpace<Double> momentum) {
        this.momentum = momentum;
    }

    public void setMomentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public void setUpdater(ParameterSpace<Updater> updater) {
        this.updater = updater;
    }

    public void setEpsilon(ParameterSpace<Double> epsilon) {
        this.epsilon = epsilon;
    }

    public void setRho(ParameterSpace<Double> rho) {
        this.rho = rho;
    }

    public void setRmsDecay(ParameterSpace<Double> rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setAdamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    public void setAdamVarDecay(ParameterSpace<Double> adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setGradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public void setLayerSpaces(List<LayerConf> layerSpaces) {
        this.layerSpaces = layerSpaces;
    }

    public void setBackprop(ParameterSpace<Boolean> backprop) {
        this.backprop = backprop;
    }

    public void setPretrain(ParameterSpace<Boolean> pretrain) {
        this.pretrain = pretrain;
    }

    public void setBackpropType(ParameterSpace<BackpropType> backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(ParameterSpace<Integer> tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBwdLength(ParameterSpace<Integer> tbpttBwdLength) {
        this.tbpttBwdLength = tbpttBwdLength;
    }

    public void setConvolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    static {
        JsonMapper.getMapper().registerSubtypes(new Class[]{ComputationGraphSpace.class, MultiLayerSpace.class});
        YamlMapper.getMapper().registerSubtypes(new Class[]{ComputationGraphSpace.class, MultiLayerSpace.class});
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private ParameterSpace<IActivation> activationFunction;
        private ParameterSpace<WeightInit> weightInit;
        private ParameterSpace<Double> biasInit;
        private ParameterSpace<Boolean> useDropConnect;
        private ParameterSpace<Integer> iterations;
        private Long seed;
        private ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
        private ParameterSpace<Boolean> regularization;
        private ParameterSpace<Boolean> schedules;
        private ParameterSpace<Distribution> dist;
        private ParameterSpace<Double> learningRate;
        private ParameterSpace<Double> biasLearningRate;
        private ParameterSpace<Map<Integer, Double>> learningRateAfter;
        private ParameterSpace<Double> lrScoreBasedDecay;
        private ParameterSpace<LearningRatePolicy> learningRateDecayPolicy;
        private ParameterSpace<Map<Integer, Double>> learningRateSchedule;
        private ParameterSpace<Double> lrPolicyDecayRate;
        private ParameterSpace<Double> lrPolicyPower;
        private ParameterSpace<Double> lrPolicySteps;
        private ParameterSpace<Integer> maxNumLineSearchIterations;
        private ParameterSpace<Boolean> miniBatch;
        private ParameterSpace<Boolean> minimize;
        private ParameterSpace<StepFunction> stepFunction;
        private ParameterSpace<Double> l1;
        private ParameterSpace<Double> l2;
        private ParameterSpace<Double> dropOut;
        private ParameterSpace<Double> momentum;
        private ParameterSpace<Map<Integer, Double>> momentumAfter;
        private ParameterSpace<Updater> updater;
        private ParameterSpace<Double> epsilon;
        private ParameterSpace<Double> rho;
        private ParameterSpace<Double> rmsDecay;
        private ParameterSpace<GradientNormalization> gradientNormalization;
        private ParameterSpace<Double> gradientNormalizationThreshold;
        private ParameterSpace<Double> adamMeanDecay;
        private ParameterSpace<Double> adamVarDecay;
        private ParameterSpace<Boolean> backprop;
        private ParameterSpace<Boolean> pretrain;
        private ParameterSpace<BackpropType> backpropType;
        private ParameterSpace<Integer> tbpttFwdLength;
        private ParameterSpace<Integer> tbpttBwdLength;
        private ParameterSpace<ConvolutionMode> convolutionMode;
        private EarlyStoppingConfiguration earlyStoppingConfiguration;
        private int numEpochs = 1;

        protected Builder() {
        }

        public T useDropConnect(boolean useDropConnect) {
            return this.useDropConnect((ParameterSpace<Boolean>)new FixedValue((Object)useDropConnect));
        }

        public T useDropConnect(ParameterSpace<Boolean> parameterSpace) {
            this.useDropConnect = parameterSpace;
            return (T)this;
        }

        public T iterations(int iterations) {
            return this.iterations((ParameterSpace<Integer>)new FixedValue((Object)iterations));
        }

        public T iterations(ParameterSpace<Integer> parameterSpace) {
            this.iterations = parameterSpace;
            return (T)this;
        }

        public T seed(long seed) {
            this.seed = seed;
            return (T)this;
        }

        public T optimizationAlgo(OptimizationAlgorithm optimizationAlgorithm) {
            return this.optimizationAlgo((ParameterSpace<OptimizationAlgorithm>)new FixedValue((Object)optimizationAlgorithm));
        }

        public T optimizationAlgo(ParameterSpace<OptimizationAlgorithm> parameterSpace) {
            this.optimizationAlgo = parameterSpace;
            return (T)this;
        }

        public T regularization(boolean useRegularization) {
            return this.regularization((ParameterSpace<Boolean>)new FixedValue((Object)useRegularization));
        }

        public T regularization(ParameterSpace<Boolean> parameterSpace) {
            this.regularization = parameterSpace;
            return (T)this;
        }

        public T schedules(boolean schedules) {
            return this.schedules((ParameterSpace<Boolean>)new FixedValue((Object)schedules));
        }

        public T schedules(ParameterSpace<Boolean> schedules) {
            this.schedules = schedules;
            return (T)this;
        }

        @Deprecated
        public T activation(String activationFunction) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)Activation.fromString((String)activationFunction)));
        }

        public T activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public T activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            return this.learningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T learningRate(ParameterSpace<Double> learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double learningRate) {
            return this.biasLearningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T biasLearningRate(ParameterSpace<Double> biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateAfter(Map<Integer, Double> learningRateAfter) {
            return this.learningRateAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateAfter));
        }

        public T learningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return (T)this;
        }

        public T learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            return this.learningRateScoreBasedDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrScoreBasedDecay));
        }

        public T learningRateScoreBasedDecayRate(ParameterSpace<Double> lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return (T)this;
        }

        public T learningRateDecayPolicy(LearningRatePolicy learningRatePolicy) {
            return this.learningRateDecayPolicy((ParameterSpace<LearningRatePolicy>)new FixedValue((Object)learningRatePolicy));
        }

        public T learningRateDecayPolicy(ParameterSpace<LearningRatePolicy> learningRateDecayPolicy) {
            this.learningRateDecayPolicy = learningRateDecayPolicy;
            return (T)this;
        }

        public T learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            return this.learningRateSchedule((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateSchedule));
        }

        public T learningRateSchedule(ParameterSpace<Map<Integer, Double>> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return (T)this;
        }

        public T lrPolicyDecayRate(double lrPolicyDecayRate) {
            return this.lrPolicyDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrPolicyDecayRate));
        }

        public T lrPolicyDecayRate(ParameterSpace<Double> lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return (T)this;
        }

        public T lrPolicyPower(double lrPolicyPower) {
            return this.lrPolicyPower((ParameterSpace<Double>)new FixedValue((Object)lrPolicyPower));
        }

        public T lrPolicyPower(ParameterSpace<Double> lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return (T)this;
        }

        public T lrPolicySteps(double lrPolicySteps) {
            return this.lrPolicySteps((ParameterSpace<Double>)new FixedValue((Object)lrPolicySteps));
        }

        public T lrPolicySteps(ParameterSpace<Double> lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return (T)this;
        }

        public T maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            return this.maxNumLineSearchIterations((ParameterSpace<Integer>)new FixedValue((Object)maxNumLineSearchIterations));
        }

        public T maxNumLineSearchIterations(ParameterSpace<Integer> maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return (T)this;
        }

        public T miniBatch(boolean minibatch) {
            return this.miniBatch((ParameterSpace<Boolean>)new FixedValue((Object)minibatch));
        }

        public T miniBatch(ParameterSpace<Boolean> miniBatch) {
            this.miniBatch = miniBatch;
            return (T)this;
        }

        public T minimize(boolean minimize) {
            return this.minimize((ParameterSpace<Boolean>)new FixedValue((Object)minimize));
        }

        public T minimize(ParameterSpace<Boolean> minimize) {
            this.minimize = minimize;
            return (T)this;
        }

        public T stepFunction(StepFunction stepFunction) {
            return this.stepFunction((ParameterSpace<StepFunction>)new FixedValue((Object)stepFunction));
        }

        public T stepFunction(ParameterSpace<StepFunction> stepFunction) {
            this.stepFunction = stepFunction;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T dropOut(double dropOut) {
            return this.dropOut((ParameterSpace<Double>)new FixedValue((Object)dropOut));
        }

        public T dropOut(ParameterSpace<Double> dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public T momentum(double momentum) {
            return this.momentum((ParameterSpace<Double>)new FixedValue((Object)momentum));
        }

        public T momentum(ParameterSpace<Double> momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            return this.momentumAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(momentumAfter));
        }

        public T momentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            return this.updater((ParameterSpace<Updater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<Updater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T epsilon(double epsilon) {
            return this.epsilon((ParameterSpace<Double>)new FixedValue((Object)epsilon));
        }

        public T epsilon(ParameterSpace<Double> epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        public T rho(double rho) {
            return this.rho((ParameterSpace<Double>)new FixedValue((Object)rho));
        }

        public T rho(ParameterSpace<Double> rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            return this.rmsDecay((ParameterSpace<Double>)new FixedValue((Object)rmsDecay));
        }

        public T rmsDecay(ParameterSpace<Double> rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }

        public T backprop(boolean backprop) {
            return this.backprop((ParameterSpace<Boolean>)new FixedValue((Object)backprop));
        }

        public T backprop(ParameterSpace<Boolean> backprop) {
            this.backprop = backprop;
            return (T)this;
        }

        public T pretrain(boolean pretrain) {
            return this.pretrain((ParameterSpace<Boolean>)new FixedValue((Object)pretrain));
        }

        public T pretrain(ParameterSpace<Boolean> pretrain) {
            this.pretrain = pretrain;
            return (T)this;
        }

        public T backpropType(BackpropType backpropType) {
            return this.backpropType((ParameterSpace<BackpropType>)new FixedValue((Object)backpropType));
        }

        public T backpropType(ParameterSpace<BackpropType> backpropType) {
            this.backpropType = backpropType;
            return (T)this;
        }

        public T tbpttFwdLength(int tbpttFwdLength) {
            return this.tbpttFwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttFwdLength));
        }

        public T tbpttFwdLength(ParameterSpace<Integer> tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return (T)this;
        }

        public T tbpttBwdLength(int tbpttBwdLength) {
            return this.tbpttBwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttBwdLength));
        }

        public T tbpttBwdLength(ParameterSpace<Integer> tbpttBwdLength) {
            this.tbpttBwdLength = tbpttBwdLength;
            return (T)this;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            return this.convolutionMode((ParameterSpace<ConvolutionMode>)new FixedValue((Object)convolutionMode));
        }

        public T convolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T numEpochs(int numEpochs) {
            this.numEpochs = numEpochs;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            return this.biasInit((ParameterSpace<Double>)new FixedValue((Object)biasInit));
        }

        public T biasInit(ParameterSpace<Double> biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            return this.adamMeanDecay((ParameterSpace<Double>)new FixedValue((Object)adamMeanDecay));
        }

        public T adamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            return this.adamVarDecay((ParameterSpace<Double>)new FixedValue((Object)adamVarDecay));
        }

        public T adamVarDecay(ParameterSpace<Double> adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public abstract <E extends BaseNetworkSpace> E build();
    }

    public static class LayerConf {
        protected LayerSpace<?> layerSpace;
        protected String layerName;
        protected String[] inputs;
        protected ParameterSpace<Integer> numLayers;
        protected boolean duplicateConfig;

        @ConstructorProperties(value={"layerSpace", "layerName", "inputs", "numLayers", "duplicateConfig"})
        public LayerConf(LayerSpace<?> layerSpace, String layerName, String[] inputs, ParameterSpace<Integer> numLayers, boolean duplicateConfig) {
            this.layerSpace = layerSpace;
            this.layerName = layerName;
            this.inputs = inputs;
            this.numLayers = numLayers;
            this.duplicateConfig = duplicateConfig;
        }

        public LayerSpace<?> getLayerSpace() {
            return this.layerSpace;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public ParameterSpace<Integer> getNumLayers() {
            return this.numLayers;
        }

        public boolean isDuplicateConfig() {
            return this.duplicateConfig;
        }

        public void setLayerSpace(LayerSpace<?> layerSpace) {
            this.layerSpace = layerSpace;
        }

        public void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public void setInputs(String[] inputs) {
            this.inputs = inputs;
        }

        public void setNumLayers(ParameterSpace<Integer> numLayers) {
            this.numLayers = numLayers;
        }

        public void setDuplicateConfig(boolean duplicateConfig) {
            this.duplicateConfig = duplicateConfig;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayerConf)) {
                return false;
            }
            LayerConf other = (LayerConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LayerSpace<?> this$layerSpace = this.getLayerSpace();
            LayerSpace<?> other$layerSpace = other.getLayerSpace();
            if (this$layerSpace == null ? other$layerSpace != null : !((Object)this$layerSpace).equals(other$layerSpace)) {
                return false;
            }
            String this$layerName = this.getLayerName();
            String other$layerName = other.getLayerName();
            if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
                return false;
            }
            ParameterSpace<Integer> this$numLayers = this.getNumLayers();
            ParameterSpace<Integer> other$numLayers = other.getNumLayers();
            if (this$numLayers == null ? other$numLayers != null : !this$numLayers.equals(other$numLayers)) {
                return false;
            }
            return this.isDuplicateConfig() == other.isDuplicateConfig();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LayerConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LayerSpace<?> $layerSpace = this.getLayerSpace();
            result = result * 59 + ($layerSpace == null ? 43 : ((Object)$layerSpace).hashCode());
            String $layerName = this.getLayerName();
            result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInputs());
            ParameterSpace<Integer> $numLayers = this.getNumLayers();
            result = result * 59 + ($numLayers == null ? 43 : $numLayers.hashCode());
            result = result * 59 + (this.isDuplicateConfig() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BaseNetworkSpace.LayerConf(layerSpace=" + this.getLayerSpace() + ", layerName=" + this.getLayerName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ", numLayers=" + this.getNumLayers() + ", duplicateConfig=" + this.isDuplicateConfig() + ")";
        }

        public LayerConf() {
        }
    }
}

