/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.arbiter.BaseNetworkSpace;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper;
import org.deeplearning4j.arbiter.optimize.serde.jackson.YamlMapper;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.shade.jackson.annotation.JsonProperty;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonTypeName(value="ComputationGraphSpace")
public class ComputationGraphSpace
extends BaseNetworkSpace<GraphConfiguration> {
    @JsonProperty
    protected List<BaseNetworkSpace.LayerConf> layerSpaces = new ArrayList<BaseNetworkSpace.LayerConf>();
    @JsonProperty
    protected List<VertexConf> vertices = new ArrayList<VertexConf>();
    @JsonProperty
    protected String[] networkInputs;
    @JsonProperty
    protected String[] networkOutputs;
    @JsonProperty
    protected ParameterSpace<InputType[]> inputTypes;
    @JsonProperty
    protected int numParameters;
    protected EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration;

    protected ComputationGraphSpace(Builder builder) {
        super(builder);
        this.earlyStoppingConfiguration = builder.earlyStoppingConfiguration;
        this.layerSpaces = builder.layerList;
        this.vertices = builder.vertexList;
        this.networkInputs = builder.networkInputs;
        this.networkOutputs = builder.networkOutputs;
        this.inputTypes = builder.inputTypes;
        List list = LeafUtils.getUniqueObjects(this.collectLeaves());
        for (ParameterSpace ps : list) {
            this.numParameters += ps.numParameters();
        }
    }

    public GraphConfiguration getValue(double[] values) {
        NeuralNetConfiguration.Builder builder = this.randomGlobalConf(values);
        ComputationGraphConfiguration.GraphBuilder graphBuilder = builder.graphBuilder();
        graphBuilder.addInputs(this.networkInputs);
        graphBuilder.setOutputs(this.networkOutputs);
        if (this.inputTypes != null) {
            graphBuilder.setInputTypes((InputType[])this.inputTypes.getValue(values));
        }
        for (BaseNetworkSpace.LayerConf c : this.layerSpaces) {
            Layer l = (Layer)c.layerSpace.getValue(values);
            graphBuilder.addLayer(c.getLayerName(), l, c.getInputs());
        }
        for (VertexConf gv : this.vertices) {
            graphBuilder.addVertex(gv.getVertexName(), gv.getGraphVertex(), gv.getInputs());
        }
        if (this.backprop != null) {
            graphBuilder.backprop(((Boolean)this.backprop.getValue(values)).booleanValue());
        }
        if (this.pretrain != null) {
            graphBuilder.pretrain(((Boolean)this.pretrain.getValue(values)).booleanValue());
        }
        if (this.backpropType != null) {
            graphBuilder.backpropType((BackpropType)this.backpropType.getValue(values));
        }
        if (this.tbpttFwdLength != null) {
            graphBuilder.tBPTTForwardLength(((Integer)this.tbpttFwdLength.getValue(values)).intValue());
        }
        if (this.tbpttBwdLength != null) {
            graphBuilder.tBPTTBackwardLength(((Integer)this.tbpttBwdLength.getValue(values)).intValue());
        }
        ComputationGraphConfiguration configuration = graphBuilder.build();
        return new GraphConfiguration(configuration, this.earlyStoppingConfiguration, this.numEpochs);
    }

    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        for (BaseNetworkSpace.LayerConf lc : this.layerSpaces) {
            list.addAll(lc.layerSpace.collectLeaves());
        }
        if (this.inputTypes != null) {
            list.add(this.inputTypes);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (BaseNetworkSpace.LayerConf layerConf : this.layerSpaces) {
            sb.append("Layer config: \"").append(layerConf.layerName).append("\", ").append(layerConf.layerSpace).append(", inputs: ").append(layerConf.inputs == null ? "[]" : Arrays.toString(layerConf.inputs)).append("\n");
        }
        for (VertexConf vertexConf : this.vertices) {
            sb.append("GraphVertex: \"").append(vertexConf.vertexName).append("\", ").append(vertexConf.graphVertex).append(", inputs: ").append(vertexConf.inputs == null ? "[]" : Arrays.toString(vertexConf.inputs)).append("\n");
        }
        if (this.earlyStoppingConfiguration != null) {
            sb.append("Early stopping configuration:").append(this.earlyStoppingConfiguration.toString()).append("\n");
        } else {
            sb.append("Training # epochs:").append(this.numEpochs).append("\n");
        }
        if (this.inputTypes != null) {
            sb.append("Input types: ").append(this.inputTypes).append("\n");
        }
        return sb.toString();
    }

    public static ComputationGraphSpace fromJson(String json) {
        try {
            return (ComputationGraphSpace)((Object)JsonMapper.getMapper().readValue(json, ComputationGraphSpace.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ComputationGraphSpace fromYaml(String yaml) {
        try {
            return (ComputationGraphSpace)((Object)YamlMapper.getMapper().readValue(yaml, ComputationGraphSpace.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ComputationGraphSpace() {
    }

    @Override
    public List<BaseNetworkSpace.LayerConf> getLayerSpaces() {
        return this.layerSpaces;
    }

    public List<VertexConf> getVertices() {
        return this.vertices;
    }

    public String[] getNetworkInputs() {
        return this.networkInputs;
    }

    public String[] getNetworkOutputs() {
        return this.networkOutputs;
    }

    public ParameterSpace<InputType[]> getInputTypes() {
        return this.inputTypes;
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public EarlyStoppingConfiguration<ComputationGraph> getEarlyStoppingConfiguration() {
        return this.earlyStoppingConfiguration;
    }

    @Override
    public void setLayerSpaces(List<BaseNetworkSpace.LayerConf> layerSpaces) {
        this.layerSpaces = layerSpaces;
    }

    public void setVertices(List<VertexConf> vertices) {
        this.vertices = vertices;
    }

    public void setNetworkInputs(String[] networkInputs) {
        this.networkInputs = networkInputs;
    }

    public void setNetworkOutputs(String[] networkOutputs) {
        this.networkOutputs = networkOutputs;
    }

    public void setInputTypes(ParameterSpace<InputType[]> inputTypes) {
        this.inputTypes = inputTypes;
    }

    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    public void setEarlyStoppingConfiguration(EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration) {
        this.earlyStoppingConfiguration = earlyStoppingConfiguration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputationGraphSpace)) {
            return false;
        }
        ComputationGraphSpace other = (ComputationGraphSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BaseNetworkSpace.LayerConf> this$layerSpaces = this.getLayerSpaces();
        List<BaseNetworkSpace.LayerConf> other$layerSpaces = other.getLayerSpaces();
        if (this$layerSpaces == null ? other$layerSpaces != null : !((Object)this$layerSpaces).equals(other$layerSpaces)) {
            return false;
        }
        List<VertexConf> this$vertices = this.getVertices();
        List<VertexConf> other$vertices = other.getVertices();
        if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNetworkInputs(), other.getNetworkInputs())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNetworkOutputs(), other.getNetworkOutputs())) {
            return false;
        }
        ParameterSpace<InputType[]> this$inputTypes = this.getInputTypes();
        ParameterSpace<InputType[]> other$inputTypes = other.getInputTypes();
        if (this$inputTypes == null ? other$inputTypes != null : !this$inputTypes.equals(other$inputTypes)) {
            return false;
        }
        if (this.getNumParameters() != other.getNumParameters()) {
            return false;
        }
        EarlyStoppingConfiguration<ComputationGraph> this$earlyStoppingConfiguration = this.getEarlyStoppingConfiguration();
        EarlyStoppingConfiguration<ComputationGraph> other$earlyStoppingConfiguration = other.getEarlyStoppingConfiguration();
        return !(this$earlyStoppingConfiguration == null ? other$earlyStoppingConfiguration != null : !this$earlyStoppingConfiguration.equals(other$earlyStoppingConfiguration));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ComputationGraphSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        List<BaseNetworkSpace.LayerConf> $layerSpaces = this.getLayerSpaces();
        result = result * 59 + ($layerSpaces == null ? 43 : ((Object)$layerSpaces).hashCode());
        List<VertexConf> $vertices = this.getVertices();
        result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNetworkInputs());
        result = result * 59 + Arrays.deepHashCode(this.getNetworkOutputs());
        ParameterSpace<InputType[]> $inputTypes = this.getInputTypes();
        result = result * 59 + ($inputTypes == null ? 43 : $inputTypes.hashCode());
        result = result * 59 + this.getNumParameters();
        EarlyStoppingConfiguration<ComputationGraph> $earlyStoppingConfiguration = this.getEarlyStoppingConfiguration();
        result = result * 59 + ($earlyStoppingConfiguration == null ? 43 : $earlyStoppingConfiguration.hashCode());
        return result;
    }

    public static class Builder
    extends BaseNetworkSpace.Builder<Builder> {
        protected List<BaseNetworkSpace.LayerConf> layerList = new ArrayList<BaseNetworkSpace.LayerConf>();
        protected List<VertexConf> vertexList = new ArrayList<VertexConf>();
        protected EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration;
        protected String[] networkInputs;
        protected String[] networkOutputs;
        protected ParameterSpace<InputType[]> inputTypes;

        public Builder earlyStoppingConfiguration(EarlyStoppingConfiguration<ComputationGraph> earlyStoppingConfiguration) {
            this.earlyStoppingConfiguration = earlyStoppingConfiguration;
            return this;
        }

        public Builder addLayer(String layerName, LayerSpace<? extends Layer> layerSpace, String ... layerInputs) {
            this.layerList.add(new BaseNetworkSpace.LayerConf(layerSpace, layerName, layerInputs, (ParameterSpace<Integer>)new FixedValue((Object)1), false));
            return this;
        }

        public Builder addVertex(String vertexName, GraphVertex vertex, String ... vertexInputs) {
            this.vertexList.add(new VertexConf(vertex, vertexName, vertexInputs));
            return this;
        }

        public Builder addInputs(String ... networkInputs) {
            this.networkInputs = networkInputs;
            return this;
        }

        public Builder setOutputs(String ... networkOutputs) {
            this.networkOutputs = networkOutputs;
            return this;
        }

        public Builder setInputTypes(InputType ... inputTypes) {
            return this.setInputTypes((ParameterSpace<InputType[]>)new FixedValue((Object)inputTypes));
        }

        public Builder setInputTypes(ParameterSpace<InputType[]> inputTypes) {
            this.inputTypes = inputTypes;
            return this;
        }

        @Override
        public ComputationGraphSpace build() {
            return new ComputationGraphSpace(this);
        }
    }

    protected static class VertexConf {
        protected GraphVertex graphVertex;
        protected String vertexName;
        protected String[] inputs;

        @ConstructorProperties(value={"graphVertex", "vertexName", "inputs"})
        public VertexConf(GraphVertex graphVertex, String vertexName, String[] inputs) {
            this.graphVertex = graphVertex;
            this.vertexName = vertexName;
            this.inputs = inputs;
        }

        public GraphVertex getGraphVertex() {
            return this.graphVertex;
        }

        public String getVertexName() {
            return this.vertexName;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public void setGraphVertex(GraphVertex graphVertex) {
            this.graphVertex = graphVertex;
        }

        public void setVertexName(String vertexName) {
            this.vertexName = vertexName;
        }

        public void setInputs(String[] inputs) {
            this.inputs = inputs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VertexConf)) {
                return false;
            }
            VertexConf other = (VertexConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GraphVertex this$graphVertex = this.getGraphVertex();
            GraphVertex other$graphVertex = other.getGraphVertex();
            if (this$graphVertex == null ? other$graphVertex != null : !this$graphVertex.equals(other$graphVertex)) {
                return false;
            }
            String this$vertexName = this.getVertexName();
            String other$vertexName = other.getVertexName();
            if (this$vertexName == null ? other$vertexName != null : !this$vertexName.equals(other$vertexName)) {
                return false;
            }
            return Arrays.deepEquals(this.getInputs(), other.getInputs());
        }

        protected boolean canEqual(Object other) {
            return other instanceof VertexConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GraphVertex $graphVertex = this.getGraphVertex();
            result = result * 59 + ($graphVertex == null ? 43 : $graphVertex.hashCode());
            String $vertexName = this.getVertexName();
            result = result * 59 + ($vertexName == null ? 43 : $vertexName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInputs());
            return result;
        }

        public String toString() {
            return "ComputationGraphSpace.VertexConf(graphVertex=" + this.getGraphVertex() + ", vertexName=" + this.getVertexName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ")";
        }

        public VertexConf() {
        }
    }
}

