/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.BaseNetworkSpace;
import org.deeplearning4j.arbiter.DL4JConfiguration;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper;
import org.deeplearning4j.arbiter.optimize.serde.jackson.YamlMapper;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class MultiLayerSpace
extends BaseNetworkSpace<DL4JConfiguration> {
    @JsonProperty
    protected ParameterSpace<InputType> inputType;
    @JsonProperty
    protected ParameterSpace<Map<Integer, InputPreProcessor>> inputPreProcessors;
    @JsonProperty
    protected EarlyStoppingConfiguration<MultiLayerNetwork> earlyStoppingConfiguration;
    @JsonProperty
    protected int numParameters;

    protected MultiLayerSpace(Builder builder) {
        super(builder);
        this.inputType = builder.inputType;
        this.inputPreProcessors = builder.inputPreProcessors;
        this.earlyStoppingConfiguration = builder.earlyStoppingConfiguration;
        this.layerSpaces = builder.layerSpaces;
        List<ParameterSpace> allLeaves = this.collectLeaves();
        List list = LeafUtils.getUniqueObjects(allLeaves);
        for (ParameterSpace ps : list) {
            this.numParameters += ps.numParameters();
        }
    }

    protected MultiLayerSpace() {
    }

    public DL4JConfiguration getValue(double[] values) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (BaseNetworkSpace.LayerConf c : this.layerSpaces) {
            int n = (Integer)c.numLayers.getValue(values);
            if (c.duplicateConfig) {
                Layer l = (Layer)c.layerSpace.getValue(values);
                for (int i = 0; i < n; ++i) {
                    layers.add(l.clone());
                }
                continue;
            }
            throw new UnsupportedOperationException("Not yet implemented");
        }
        NeuralNetConfiguration.Builder builder = this.randomGlobalConf(values);
        NeuralNetConfiguration.ListBuilder listBuilder = builder.list();
        for (int i = 0; i < layers.size(); ++i) {
            listBuilder.layer(i, (Layer)layers.get(i));
        }
        if (this.backprop != null) {
            listBuilder.backprop(((Boolean)this.backprop.getValue(values)).booleanValue());
        }
        if (this.pretrain != null) {
            listBuilder.pretrain(((Boolean)this.pretrain.getValue(values)).booleanValue());
        }
        if (this.backpropType != null) {
            listBuilder.backpropType((BackpropType)this.backpropType.getValue(values));
        }
        if (this.tbpttFwdLength != null) {
            listBuilder.tBPTTForwardLength(((Integer)this.tbpttFwdLength.getValue(values)).intValue());
        }
        if (this.tbpttBwdLength != null) {
            listBuilder.tBPTTBackwardLength(((Integer)this.tbpttBwdLength.getValue(values)).intValue());
        }
        if (this.inputType != null) {
            listBuilder.setInputType((InputType)this.inputType.getValue(values));
        }
        if (this.inputPreProcessors != null) {
            listBuilder.setInputPreProcessors((Map)this.inputPreProcessors.getValue(values));
        }
        MultiLayerConfiguration configuration = listBuilder.build();
        return new DL4JConfiguration(configuration, this.earlyStoppingConfiguration, this.numEpochs);
    }

    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        List<ParameterSpace> list = super.collectLeaves();
        for (BaseNetworkSpace.LayerConf lc : this.layerSpaces) {
            list.addAll(lc.numLayers.collectLeaves());
            list.addAll(lc.layerSpace.collectLeaves());
        }
        if (this.inputType != null) {
            list.addAll(this.inputType.collectLeaves());
        }
        if (this.inputPreProcessors != null) {
            list.addAll(this.inputPreProcessors.collectLeaves());
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        int i = 0;
        for (BaseNetworkSpace.LayerConf conf : this.layerSpaces) {
            sb.append("Layer config ").append(i++).append(": (Number layers:").append(conf.numLayers).append(", duplicate: ").append(conf.duplicateConfig).append("), ").append(conf.layerSpace.toString()).append("\n");
        }
        if (this.inputType != null) {
            sb.append("inputType: ").append(this.inputType).append("\n");
        }
        if (this.inputPreProcessors != null) {
            sb.append("inputPreProcessors: ").append(this.inputPreProcessors).append("\n");
        }
        if (this.earlyStoppingConfiguration != null) {
            sb.append("Early stopping configuration:").append(this.earlyStoppingConfiguration.toString()).append("\n");
        } else {
            sb.append("Training # epochs:").append(this.numEpochs).append("\n");
        }
        return sb.toString();
    }

    public LayerSpace<?> getLayerSpace(int layerNumber) {
        return ((BaseNetworkSpace.LayerConf)this.layerSpaces.get(layerNumber)).getLayerSpace();
    }

    public static MultiLayerSpace fromJson(String json) {
        try {
            return (MultiLayerSpace)((Object)JsonMapper.getMapper().readValue(json, MultiLayerSpace.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MultiLayerSpace fromYaml(String yaml) {
        try {
            return (MultiLayerSpace)((Object)YamlMapper.getMapper().readValue(yaml, MultiLayerSpace.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParameterSpace<InputType> getInputType() {
        return this.inputType;
    }

    public ParameterSpace<Map<Integer, InputPreProcessor>> getInputPreProcessors() {
        return this.inputPreProcessors;
    }

    public EarlyStoppingConfiguration<MultiLayerNetwork> getEarlyStoppingConfiguration() {
        return this.earlyStoppingConfiguration;
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public void setInputType(ParameterSpace<InputType> inputType) {
        this.inputType = inputType;
    }

    public void setInputPreProcessors(ParameterSpace<Map<Integer, InputPreProcessor>> inputPreProcessors) {
        this.inputPreProcessors = inputPreProcessors;
    }

    public void setEarlyStoppingConfiguration(EarlyStoppingConfiguration<MultiLayerNetwork> earlyStoppingConfiguration) {
        this.earlyStoppingConfiguration = earlyStoppingConfiguration;
    }

    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiLayerSpace)) {
            return false;
        }
        MultiLayerSpace other = (MultiLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<InputType> this$inputType = this.getInputType();
        ParameterSpace<InputType> other$inputType = other.getInputType();
        if (this$inputType == null ? other$inputType != null : !this$inputType.equals(other$inputType)) {
            return false;
        }
        ParameterSpace<Map<Integer, InputPreProcessor>> this$inputPreProcessors = this.getInputPreProcessors();
        ParameterSpace<Map<Integer, InputPreProcessor>> other$inputPreProcessors = other.getInputPreProcessors();
        if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !this$inputPreProcessors.equals(other$inputPreProcessors)) {
            return false;
        }
        EarlyStoppingConfiguration<MultiLayerNetwork> this$earlyStoppingConfiguration = this.getEarlyStoppingConfiguration();
        EarlyStoppingConfiguration<MultiLayerNetwork> other$earlyStoppingConfiguration = other.getEarlyStoppingConfiguration();
        if (this$earlyStoppingConfiguration == null ? other$earlyStoppingConfiguration != null : !this$earlyStoppingConfiguration.equals(other$earlyStoppingConfiguration)) {
            return false;
        }
        return this.getNumParameters() == other.getNumParameters();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<InputType> $inputType = this.getInputType();
        result = result * 59 + ($inputType == null ? 43 : $inputType.hashCode());
        ParameterSpace<Map<Integer, InputPreProcessor>> $inputPreProcessors = this.getInputPreProcessors();
        result = result * 59 + ($inputPreProcessors == null ? 43 : $inputPreProcessors.hashCode());
        EarlyStoppingConfiguration<MultiLayerNetwork> $earlyStoppingConfiguration = this.getEarlyStoppingConfiguration();
        result = result * 59 + ($earlyStoppingConfiguration == null ? 43 : $earlyStoppingConfiguration.hashCode());
        result = result * 59 + this.getNumParameters();
        return result;
    }

    public static class Builder
    extends BaseNetworkSpace.Builder<Builder> {
        protected List<BaseNetworkSpace.LayerConf> layerSpaces = new ArrayList<BaseNetworkSpace.LayerConf>();
        protected ParameterSpace<InputType> inputType;
        protected ParameterSpace<Map<Integer, InputPreProcessor>> inputPreProcessors;
        protected EarlyStoppingConfiguration<MultiLayerNetwork> earlyStoppingConfiguration;

        public Builder setInputType(InputType inputType) {
            return this.setInputType((ParameterSpace<InputType>)new FixedValue((Object)inputType));
        }

        public Builder setInputType(ParameterSpace<InputType> inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder addLayer(LayerSpace<?> layerSpace) {
            return this.addLayer(layerSpace, (ParameterSpace<Integer>)new FixedValue((Object)1), true);
        }

        public Builder addLayer(LayerSpace<? extends Layer> layerSpace, ParameterSpace<Integer> numLayersDistribution, boolean duplicateConfig) {
            String layerName = "layer_" + this.layerSpaces.size();
            this.layerSpaces.add(new BaseNetworkSpace.LayerConf(layerSpace, layerName, null, numLayersDistribution, duplicateConfig));
            return this;
        }

        public Builder earlyStoppingConfiguration(EarlyStoppingConfiguration<MultiLayerNetwork> earlyStoppingConfiguration) {
            this.earlyStoppingConfiguration = earlyStoppingConfiguration;
            return this;
        }

        public Builder setInputPreProcessors(Map<Integer, InputPreProcessor> inputPreProcessors) {
            return this.setInputPreProcessors((ParameterSpace<Map<Integer, InputPreProcessor>>)new FixedValue(inputPreProcessors));
        }

        public Builder setInputPreProcessors(ParameterSpace<Map<Integer, InputPreProcessor>> inputPreProcessors) {
            this.inputPreProcessors = inputPreProcessors;
            return this;
        }

        @Override
        public MultiLayerSpace build() {
            return new MultiLayerSpace(this);
        }
    }
}

