/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.data;

import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.nd4j.linalg.dataset.api.iterator.DataSetIteratorFactory;

public class DataSetIteratorFactoryProvider
implements DataProvider {
    public static final String FACTORY_KEY = "org.deeplearning4j.arbiter.data.data.factory";

    public DataSetIteratorFactory trainData(Map<String, Object> dataParameters) {
        return this.create(dataParameters);
    }

    public DataSetIteratorFactory testData(Map<String, Object> dataParameters) {
        return this.create(dataParameters);
    }

    public Class<?> getDataType() {
        return DataSetIteratorFactory.class;
    }

    private DataSetIteratorFactory create(Map<String, Object> dataParameters) {
        if (!dataParameters.containsKey(FACTORY_KEY)) {
            throw new IllegalArgumentException("No data set iterator factory class found. Please specify a class name with key org.deeplearning4j.arbiter.data.data.factory");
        }
        String value = dataParameters.get(FACTORY_KEY).toString();
        try {
            Class<?> clazz = Class.forName(value);
            return (DataSetIteratorFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

