/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;

public class ActivationLayerSpace
extends LayerSpace<ActivationLayer> {
    private ParameterSpace<IActivation> activationFunction;

    protected ActivationLayerSpace(Builder builder) {
        super(builder);
        this.activationFunction = builder.activationFunction;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public ActivationLayer getValue(double[] parameterValues) {
        ActivationLayer.Builder b = new ActivationLayer.Builder();
        super.setLayerOptionsBuilder((Layer.Builder)b, parameterValues);
        b.activation((IActivation)this.activationFunction.getValue(parameterValues));
        return b.build();
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        return "ActivationLayerSpace(" + super.toString(delim) + ")";
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActivationLayerSpace)) {
            return false;
        }
        ActivationLayerSpace other = (ActivationLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        return !(this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ActivationLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        return result;
    }

    private ActivationLayerSpace() {
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        private ParameterSpace<IActivation> activationFunction;

        public Builder activation(Activation activation) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)activation));
        }

        public Builder activation(IActivation iActivation) {
            return this.activationFn((ParameterSpace<IActivation>)new FixedValue((Object)iActivation));
        }

        public Builder activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public Builder activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        @Override
        public ActivationLayerSpace build() {
            return new ActivationLayerSpace(this);
        }
    }
}

