/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.Map;
import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BaseLayerSpace<L extends BaseLayer>
extends LayerSpace<L> {
    protected ParameterSpace<IActivation> activationFunction;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<Double> biasLearningRate;
    protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
    protected ParameterSpace<Double> lrScoreBasedDecay;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> momentum;
    protected ParameterSpace<Map<Integer, Double>> momentumAfter;
    protected ParameterSpace<Updater> updater;
    protected ParameterSpace<Double> epsilon;
    protected ParameterSpace<Double> rho;
    protected ParameterSpace<Double> rmsDecay;
    protected ParameterSpace<Double> adamMeanDecay;
    protected ParameterSpace<Double> adamVarDecay;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected int numParameters;

    protected BaseLayerSpace(Builder builder) {
        this.activationFunction = builder.activationFunction;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.learningRate = builder.learningRate;
        this.biasLearningRate = builder.biasLearningRate;
        this.learningRateAfter = builder.learningRateAfter;
        this.lrScoreBasedDecay = builder.lrScoreBasedDecay;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.momentum = builder.momentum;
        this.momentumAfter = builder.momentumAfter;
        this.updater = builder.updater;
        this.epsilon = builder.epsilon;
        this.rho = builder.rho;
        this.rmsDecay = builder.rmsDecay;
        this.adamMeanDecay = builder.adamMeanDecay;
        this.adamVarDecay = builder.adamVarDecay;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    @Override
    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non-leaf parameter space");
    }

    protected void setLayerOptionsBuilder(BaseLayer.Builder builder, double[] values) {
        if (this.activationFunction != null) {
            builder.activation((IActivation)this.activationFunction.getValue(values));
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.learningRate != null) {
            builder.learningRate(((Double)this.learningRate.getValue(values)).doubleValue());
        }
        if (this.biasLearningRate != null) {
            builder.biasLearningRate(((Double)this.biasLearningRate.getValue(values)).doubleValue());
        }
        if (this.learningRateAfter != null) {
            builder.learningRateSchedule((Map)this.learningRateAfter.getValue(values));
        }
        if (this.lrScoreBasedDecay != null) {
            builder.learningRate(((Double)this.lrScoreBasedDecay.getValue(values)).doubleValue());
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.dropOut != null) {
            builder.dropOut(((Double)this.dropOut.getValue(values)).doubleValue());
        }
        if (this.momentum != null) {
            builder.momentum(((Double)this.momentum.getValue(values)).doubleValue());
        }
        if (this.momentumAfter != null) {
            builder.momentumAfter((Map)this.momentumAfter.getValue(values));
        }
        if (this.updater != null) {
            builder.updater((Updater)this.updater.getValue(values));
        }
        if (this.epsilon != null) {
            builder.epsilon(((Double)this.epsilon.getValue(values)).doubleValue());
        }
        if (this.rho != null) {
            builder.rho(((Double)this.rho.getValue(values)).doubleValue());
        }
        if (this.rmsDecay != null) {
            builder.rmsDecay(((Double)this.rmsDecay.getValue(values)).doubleValue());
        }
        if (this.adamMeanDecay != null) {
            builder.adamMeanDecay(((Double)this.adamMeanDecay.getValue(values)).doubleValue());
        }
        if (this.adamVarDecay != null) {
            builder.adamVarDecay(((Double)this.adamVarDecay.getValue(values)).doubleValue());
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    protected String toString(String delim) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.activationFunction != null) {
            sb.append("activationFunction: ").append(this.activationFunction).append(delim);
        }
        if (this.weightInit != null) {
            sb.append("weightInit: ").append(this.weightInit).append(delim);
        }
        if (this.biasInit != null) {
            sb.append("biasInit: ").append(this.biasInit).append(delim);
        }
        if (this.dist != null) {
            sb.append("dist: ").append(this.dist).append(delim);
        }
        if (this.learningRate != null) {
            sb.append("learningRate: ").append(this.learningRate).append(delim);
        }
        if (this.biasLearningRate != null) {
            sb.append("biasLearningRate: ").append(this.biasLearningRate).append(delim);
        }
        if (this.learningRateAfter != null) {
            sb.append("learningRateAfter: ").append(this.learningRateAfter).append(delim);
        }
        if (this.lrScoreBasedDecay != null) {
            sb.append("lrScoreBasedDecay: ").append(this.lrScoreBasedDecay).append(delim);
        }
        if (this.l1 != null) {
            sb.append("l1: ").append(this.l1).append(delim);
        }
        if (this.l2 != null) {
            sb.append("l2: ").append(this.l2).append(delim);
        }
        if (this.momentum != null) {
            sb.append("momentum: ").append(this.momentum).append(delim);
        }
        if (this.momentumAfter != null) {
            sb.append("momentumAfter: ").append(this.momentumAfter).append(delim);
        }
        if (this.updater != null) {
            sb.append("updater: ").append(this.updater).append(delim);
        }
        if (this.epsilon != null) {
            sb.append("epsilon: ").append(this.epsilon).append(delim);
        }
        if (this.rho != null) {
            sb.append("rho: ").append(this.rho).append(delim);
        }
        if (this.rmsDecay != null) {
            sb.append("rmsDecay: ").append(this.rmsDecay).append(delim);
        }
        if (this.adamMeanDecay != null) {
            sb.append("adamMeanDecay: ").append(this.adamMeanDecay).append(delim);
        }
        if (this.adamVarDecay != null) {
            sb.append("adamVarDecay: ").append(this.adamVarDecay).append(delim);
        }
        if (this.gradientNormalization != null) {
            sb.append("gradientNormalization: ").append(this.gradientNormalization).append(delim);
        }
        if (this.gradientNormalizationThreshold != null) {
            sb.append("gradientNormalizationThreshold").append(this.gradientNormalizationThreshold);
        }
        if ((s = sb.toString()).endsWith(delim)) {
            int last = s.lastIndexOf(delim);
            return s.substring(0, last);
        }
        return s;
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public ParameterSpace<WeightInit> getWeightInit() {
        return this.weightInit;
    }

    public ParameterSpace<Double> getBiasInit() {
        return this.biasInit;
    }

    public ParameterSpace<Distribution> getDist() {
        return this.dist;
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<Double> getBiasLearningRate() {
        return this.biasLearningRate;
    }

    public ParameterSpace<Map<Integer, Double>> getLearningRateAfter() {
        return this.learningRateAfter;
    }

    public ParameterSpace<Double> getLrScoreBasedDecay() {
        return this.lrScoreBasedDecay;
    }

    public ParameterSpace<Double> getL1() {
        return this.l1;
    }

    public ParameterSpace<Double> getL2() {
        return this.l2;
    }

    public ParameterSpace<Double> getMomentum() {
        return this.momentum;
    }

    public ParameterSpace<Map<Integer, Double>> getMomentumAfter() {
        return this.momentumAfter;
    }

    public ParameterSpace<Updater> getUpdater() {
        return this.updater;
    }

    public ParameterSpace<Double> getEpsilon() {
        return this.epsilon;
    }

    public ParameterSpace<Double> getRho() {
        return this.rho;
    }

    public ParameterSpace<Double> getRmsDecay() {
        return this.rmsDecay;
    }

    public ParameterSpace<Double> getAdamMeanDecay() {
        return this.adamMeanDecay;
    }

    public ParameterSpace<Double> getAdamVarDecay() {
        return this.adamVarDecay;
    }

    public ParameterSpace<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public ParameterSpace<Double> getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    @Override
    public int getNumParameters() {
        return this.numParameters;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setWeightInit(ParameterSpace<WeightInit> weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(ParameterSpace<Double> biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(ParameterSpace<Distribution> dist) {
        this.dist = dist;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setBiasLearningRate(ParameterSpace<Double> biasLearningRate) {
        this.biasLearningRate = biasLearningRate;
    }

    public void setLearningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
        this.learningRateAfter = learningRateAfter;
    }

    public void setLrScoreBasedDecay(ParameterSpace<Double> lrScoreBasedDecay) {
        this.lrScoreBasedDecay = lrScoreBasedDecay;
    }

    public void setL1(ParameterSpace<Double> l1) {
        this.l1 = l1;
    }

    public void setL2(ParameterSpace<Double> l2) {
        this.l2 = l2;
    }

    public void setMomentum(ParameterSpace<Double> momentum) {
        this.momentum = momentum;
    }

    public void setMomentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
        this.momentumAfter = momentumAfter;
    }

    public void setUpdater(ParameterSpace<Updater> updater) {
        this.updater = updater;
    }

    public void setEpsilon(ParameterSpace<Double> epsilon) {
        this.epsilon = epsilon;
    }

    public void setRho(ParameterSpace<Double> rho) {
        this.rho = rho;
    }

    public void setRmsDecay(ParameterSpace<Double> rmsDecay) {
        this.rmsDecay = rmsDecay;
    }

    public void setAdamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
        this.adamMeanDecay = adamMeanDecay;
    }

    public void setAdamVarDecay(ParameterSpace<Double> adamVarDecay) {
        this.adamVarDecay = adamVarDecay;
    }

    public void setGradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    @Override
    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLayerSpace)) {
            return false;
        }
        BaseLayerSpace other = (BaseLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        ParameterSpace<WeightInit> this$weightInit = this.getWeightInit();
        ParameterSpace<WeightInit> other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !this$weightInit.equals(other$weightInit)) {
            return false;
        }
        ParameterSpace<Double> this$biasInit = this.getBiasInit();
        ParameterSpace<Double> other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !this$biasInit.equals(other$biasInit)) {
            return false;
        }
        ParameterSpace<Distribution> this$dist = this.getDist();
        ParameterSpace<Distribution> other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<Double> this$biasLearningRate = this.getBiasLearningRate();
        ParameterSpace<Double> other$biasLearningRate = other.getBiasLearningRate();
        if (this$biasLearningRate == null ? other$biasLearningRate != null : !this$biasLearningRate.equals(other$biasLearningRate)) {
            return false;
        }
        ParameterSpace<Map<Integer, Double>> this$learningRateAfter = this.getLearningRateAfter();
        ParameterSpace<Map<Integer, Double>> other$learningRateAfter = other.getLearningRateAfter();
        if (this$learningRateAfter == null ? other$learningRateAfter != null : !this$learningRateAfter.equals(other$learningRateAfter)) {
            return false;
        }
        ParameterSpace<Double> this$lrScoreBasedDecay = this.getLrScoreBasedDecay();
        ParameterSpace<Double> other$lrScoreBasedDecay = other.getLrScoreBasedDecay();
        if (this$lrScoreBasedDecay == null ? other$lrScoreBasedDecay != null : !this$lrScoreBasedDecay.equals(other$lrScoreBasedDecay)) {
            return false;
        }
        ParameterSpace<Double> this$l1 = this.getL1();
        ParameterSpace<Double> other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !this$l1.equals(other$l1)) {
            return false;
        }
        ParameterSpace<Double> this$l2 = this.getL2();
        ParameterSpace<Double> other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !this$l2.equals(other$l2)) {
            return false;
        }
        ParameterSpace<Double> this$momentum = this.getMomentum();
        ParameterSpace<Double> other$momentum = other.getMomentum();
        if (this$momentum == null ? other$momentum != null : !this$momentum.equals(other$momentum)) {
            return false;
        }
        ParameterSpace<Map<Integer, Double>> this$momentumAfter = this.getMomentumAfter();
        ParameterSpace<Map<Integer, Double>> other$momentumAfter = other.getMomentumAfter();
        if (this$momentumAfter == null ? other$momentumAfter != null : !this$momentumAfter.equals(other$momentumAfter)) {
            return false;
        }
        ParameterSpace<Updater> this$updater = this.getUpdater();
        ParameterSpace<Updater> other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        ParameterSpace<Double> this$epsilon = this.getEpsilon();
        ParameterSpace<Double> other$epsilon = other.getEpsilon();
        if (this$epsilon == null ? other$epsilon != null : !this$epsilon.equals(other$epsilon)) {
            return false;
        }
        ParameterSpace<Double> this$rho = this.getRho();
        ParameterSpace<Double> other$rho = other.getRho();
        if (this$rho == null ? other$rho != null : !this$rho.equals(other$rho)) {
            return false;
        }
        ParameterSpace<Double> this$rmsDecay = this.getRmsDecay();
        ParameterSpace<Double> other$rmsDecay = other.getRmsDecay();
        if (this$rmsDecay == null ? other$rmsDecay != null : !this$rmsDecay.equals(other$rmsDecay)) {
            return false;
        }
        ParameterSpace<Double> this$adamMeanDecay = this.getAdamMeanDecay();
        ParameterSpace<Double> other$adamMeanDecay = other.getAdamMeanDecay();
        if (this$adamMeanDecay == null ? other$adamMeanDecay != null : !this$adamMeanDecay.equals(other$adamMeanDecay)) {
            return false;
        }
        ParameterSpace<Double> this$adamVarDecay = this.getAdamVarDecay();
        ParameterSpace<Double> other$adamVarDecay = other.getAdamVarDecay();
        if (this$adamVarDecay == null ? other$adamVarDecay != null : !this$adamVarDecay.equals(other$adamVarDecay)) {
            return false;
        }
        ParameterSpace<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        ParameterSpace<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        ParameterSpace<Double> this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        ParameterSpace<Double> other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !this$gradientNormalizationThreshold.equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        return this.getNumParameters() == other.getNumParameters();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        ParameterSpace<WeightInit> $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : $weightInit.hashCode());
        ParameterSpace<Double> $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : $biasInit.hashCode());
        ParameterSpace<Distribution> $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<Double> $biasLearningRate = this.getBiasLearningRate();
        result = result * 59 + ($biasLearningRate == null ? 43 : $biasLearningRate.hashCode());
        ParameterSpace<Map<Integer, Double>> $learningRateAfter = this.getLearningRateAfter();
        result = result * 59 + ($learningRateAfter == null ? 43 : $learningRateAfter.hashCode());
        ParameterSpace<Double> $lrScoreBasedDecay = this.getLrScoreBasedDecay();
        result = result * 59 + ($lrScoreBasedDecay == null ? 43 : $lrScoreBasedDecay.hashCode());
        ParameterSpace<Double> $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : $l1.hashCode());
        ParameterSpace<Double> $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : $l2.hashCode());
        ParameterSpace<Double> $momentum = this.getMomentum();
        result = result * 59 + ($momentum == null ? 43 : $momentum.hashCode());
        ParameterSpace<Map<Integer, Double>> $momentumAfter = this.getMomentumAfter();
        result = result * 59 + ($momentumAfter == null ? 43 : $momentumAfter.hashCode());
        ParameterSpace<Updater> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        ParameterSpace<Double> $epsilon = this.getEpsilon();
        result = result * 59 + ($epsilon == null ? 43 : $epsilon.hashCode());
        ParameterSpace<Double> $rho = this.getRho();
        result = result * 59 + ($rho == null ? 43 : $rho.hashCode());
        ParameterSpace<Double> $rmsDecay = this.getRmsDecay();
        result = result * 59 + ($rmsDecay == null ? 43 : $rmsDecay.hashCode());
        ParameterSpace<Double> $adamMeanDecay = this.getAdamMeanDecay();
        result = result * 59 + ($adamMeanDecay == null ? 43 : $adamMeanDecay.hashCode());
        ParameterSpace<Double> $adamVarDecay = this.getAdamVarDecay();
        result = result * 59 + ($adamVarDecay == null ? 43 : $adamVarDecay.hashCode());
        ParameterSpace<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        ParameterSpace<Double> $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : $gradientNormalizationThreshold.hashCode());
        result = result * 59 + this.getNumParameters();
        return result;
    }

    protected BaseLayerSpace() {
    }

    public static abstract class Builder<T>
    extends LayerSpace.Builder<T> {
        protected ParameterSpace<IActivation> activationFunction;
        protected ParameterSpace<WeightInit> weightInit;
        protected ParameterSpace<Double> biasInit;
        protected ParameterSpace<Distribution> dist;
        protected ParameterSpace<Double> learningRate;
        protected ParameterSpace<Double> biasLearningRate;
        protected ParameterSpace<Map<Integer, Double>> learningRateAfter;
        protected ParameterSpace<Double> lrScoreBasedDecay;
        protected ParameterSpace<Double> l1;
        protected ParameterSpace<Double> l2;
        protected ParameterSpace<Double> dropOut;
        protected ParameterSpace<Updater> updater;
        protected ParameterSpace<Double> momentum;
        protected ParameterSpace<Map<Integer, Double>> momentumAfter;
        protected ParameterSpace<Double> epsilon;
        protected ParameterSpace<Double> rho;
        protected ParameterSpace<Double> rmsDecay;
        protected ParameterSpace<Double> adamMeanDecay;
        protected ParameterSpace<Double> adamVarDecay;
        protected ParameterSpace<GradientNormalization> gradientNormalization;
        protected ParameterSpace<Double> gradientNormalizationThreshold;

        @Deprecated
        public T activation(String activationFunction) {
            return this.activation(Activation.fromString((String)activationFunction));
        }

        public T activation(Activation activation) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)activation));
        }

        public T activation(IActivation iActivation) {
            return this.activationFn((ParameterSpace<IActivation>)new FixedValue((Object)iActivation));
        }

        public T activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public T activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T learningRate(double learningRate) {
            return this.learningRate((ParameterSpace<Double>)new FixedValue((Object)learningRate));
        }

        public T learningRate(ParameterSpace<Double> learningRate) {
            this.learningRate = learningRate;
            return (T)this;
        }

        public T biasLearningRate(double biasLearningRate) {
            return this.biasLearningRate((ParameterSpace<Double>)new FixedValue((Object)biasLearningRate));
        }

        public T biasLearningRate(ParameterSpace<Double> biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return (T)this;
        }

        public T learningRateAfter(Map<Integer, Double> learningRateAfter) {
            return this.learningRateAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(learningRateAfter));
        }

        public T learningRateAfter(ParameterSpace<Map<Integer, Double>> learningRateAfter) {
            this.learningRateAfter = learningRateAfter;
            return (T)this;
        }

        public T learningRateScoreBasedDecayRate(double lrScoreBasedDecay) {
            return this.learningRateScoreBasedDecayRate((ParameterSpace<Double>)new FixedValue((Object)lrScoreBasedDecay));
        }

        public T learningRateScoreBasedDecayRate(ParameterSpace<Double> lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T momentum(double momentum) {
            return this.momentum((ParameterSpace<Double>)new FixedValue((Object)momentum));
        }

        public T momentum(ParameterSpace<Double> momentum) {
            this.momentum = momentum;
            return (T)this;
        }

        public T momentumAfter(Map<Integer, Double> momentumAfter) {
            return this.momentumAfter((ParameterSpace<Map<Integer, Double>>)new FixedValue(momentumAfter));
        }

        public T momentumAfter(ParameterSpace<Map<Integer, Double>> momentumAfter) {
            this.momentumAfter = momentumAfter;
            return (T)this;
        }

        public T updater(Updater updater) {
            return this.updater((ParameterSpace<Updater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<Updater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T epsilon(double epsilon) {
            return this.epsilon((ParameterSpace<Double>)new FixedValue((Object)epsilon));
        }

        public T epsilon(ParameterSpace<Double> epsilon) {
            this.epsilon = epsilon;
            return (T)this;
        }

        public T rho(double rho) {
            return this.rho((ParameterSpace<Double>)new FixedValue((Object)rho));
        }

        public T rho(ParameterSpace<Double> rho) {
            this.rho = rho;
            return (T)this;
        }

        public T rmsDecay(double rmsDecay) {
            return this.rmsDecay((ParameterSpace<Double>)new FixedValue((Object)rmsDecay));
        }

        public T rmsDecay(ParameterSpace<Double> rmsDecay) {
            this.rmsDecay = rmsDecay;
            return (T)this;
        }

        public T adamMeanDecay(double adamMeanDecay) {
            return this.adamMeanDecay((ParameterSpace<Double>)new FixedValue((Object)adamMeanDecay));
        }

        public T adamMeanDecay(ParameterSpace<Double> adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return (T)this;
        }

        public T adamVarDecay(double adamVarDecay) {
            return this.adamVarDecay((ParameterSpace<Double>)new FixedValue((Object)adamVarDecay));
        }

        public T adamVarDecay(ParameterSpace<Double> adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }
    }
}

