/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public class BatchNormalizationSpace
extends FeedForwardLayerSpace<BatchNormalization> {
    protected ParameterSpace<Double> decay;
    protected ParameterSpace<Double> eps;
    protected ParameterSpace<Boolean> isMinibatch;
    protected ParameterSpace<Boolean> lockGammaBeta;
    protected ParameterSpace<Double> gamma;
    protected ParameterSpace<Double> beta;

    private BatchNormalizationSpace(Builder builder) {
        super(builder);
        this.decay = builder.decay;
        this.eps = builder.eps;
        this.isMinibatch = builder.isMinibatch;
        this.lockGammaBeta = builder.lockGammaBeta;
        this.gamma = builder.gamma;
        this.beta = builder.beta;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public BatchNormalization getValue(double[] parameterValues) {
        BatchNormalization.Builder b = new BatchNormalization.Builder();
        this.setLayerOptionsBuilder(b, parameterValues);
        return b.build();
    }

    protected void setLayerOptionsBuilder(BatchNormalization.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.decay != null) {
            builder.decay(((Double)this.decay.getValue(values)).doubleValue());
        }
        if (this.eps != null) {
            builder.eps(((Double)this.eps.getValue(values)).doubleValue());
        }
        if (this.isMinibatch != null) {
            builder.minibatch(((Boolean)this.isMinibatch.getValue(values)).booleanValue());
        }
        if (this.lockGammaBeta != null) {
            builder.lockGammaBeta(((Boolean)this.lockGammaBeta.getValue(values)).booleanValue());
        }
        if (this.gamma != null) {
            builder.gamma(((Double)this.gamma.getValue(values)).doubleValue());
        }
        if (this.beta != null) {
            builder.beta(((Double)this.beta.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchNormalizationSpace(").append(super.toString(delim));
        if (this.decay != null) {
            sb.append("decay: ").append(this.decay).append(delim);
        }
        if (this.eps != null) {
            sb.append("eps: ").append(this.eps).append(delim);
        }
        if (this.isMinibatch != null) {
            sb.append("isMinibatch: ").append(this.isMinibatch).append(delim);
        }
        if (this.lockGammaBeta != null) {
            sb.append("lockGammaBeta: ").append(this.lockGammaBeta).append(delim);
        }
        if (this.gamma != null) {
            sb.append("gamma: ").append(this.gamma).append(delim);
        }
        if (this.beta != null) {
            sb.append("beta: ").append(this.beta).append(delim);
        }
        sb.append(")");
        return sb.toString();
    }

    public ParameterSpace<Double> getDecay() {
        return this.decay;
    }

    public ParameterSpace<Double> getEps() {
        return this.eps;
    }

    public ParameterSpace<Boolean> getIsMinibatch() {
        return this.isMinibatch;
    }

    public ParameterSpace<Boolean> getLockGammaBeta() {
        return this.lockGammaBeta;
    }

    public ParameterSpace<Double> getGamma() {
        return this.gamma;
    }

    public ParameterSpace<Double> getBeta() {
        return this.beta;
    }

    public void setDecay(ParameterSpace<Double> decay) {
        this.decay = decay;
    }

    public void setEps(ParameterSpace<Double> eps) {
        this.eps = eps;
    }

    public void setIsMinibatch(ParameterSpace<Boolean> isMinibatch) {
        this.isMinibatch = isMinibatch;
    }

    public void setLockGammaBeta(ParameterSpace<Boolean> lockGammaBeta) {
        this.lockGammaBeta = lockGammaBeta;
    }

    public void setGamma(ParameterSpace<Double> gamma) {
        this.gamma = gamma;
    }

    public void setBeta(ParameterSpace<Double> beta) {
        this.beta = beta;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchNormalizationSpace)) {
            return false;
        }
        BatchNormalizationSpace other = (BatchNormalizationSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$decay = this.getDecay();
        ParameterSpace<Double> other$decay = other.getDecay();
        if (this$decay == null ? other$decay != null : !this$decay.equals(other$decay)) {
            return false;
        }
        ParameterSpace<Double> this$eps = this.getEps();
        ParameterSpace<Double> other$eps = other.getEps();
        if (this$eps == null ? other$eps != null : !this$eps.equals(other$eps)) {
            return false;
        }
        ParameterSpace<Boolean> this$isMinibatch = this.getIsMinibatch();
        ParameterSpace<Boolean> other$isMinibatch = other.getIsMinibatch();
        if (this$isMinibatch == null ? other$isMinibatch != null : !this$isMinibatch.equals(other$isMinibatch)) {
            return false;
        }
        ParameterSpace<Boolean> this$lockGammaBeta = this.getLockGammaBeta();
        ParameterSpace<Boolean> other$lockGammaBeta = other.getLockGammaBeta();
        if (this$lockGammaBeta == null ? other$lockGammaBeta != null : !this$lockGammaBeta.equals(other$lockGammaBeta)) {
            return false;
        }
        ParameterSpace<Double> this$gamma = this.getGamma();
        ParameterSpace<Double> other$gamma = other.getGamma();
        if (this$gamma == null ? other$gamma != null : !this$gamma.equals(other$gamma)) {
            return false;
        }
        ParameterSpace<Double> this$beta = this.getBeta();
        ParameterSpace<Double> other$beta = other.getBeta();
        return !(this$beta == null ? other$beta != null : !this$beta.equals(other$beta));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BatchNormalizationSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<Double> $decay = this.getDecay();
        result = result * 59 + ($decay == null ? 43 : $decay.hashCode());
        ParameterSpace<Double> $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : $eps.hashCode());
        ParameterSpace<Boolean> $isMinibatch = this.getIsMinibatch();
        result = result * 59 + ($isMinibatch == null ? 43 : $isMinibatch.hashCode());
        ParameterSpace<Boolean> $lockGammaBeta = this.getLockGammaBeta();
        result = result * 59 + ($lockGammaBeta == null ? 43 : $lockGammaBeta.hashCode());
        ParameterSpace<Double> $gamma = this.getGamma();
        result = result * 59 + ($gamma == null ? 43 : $gamma.hashCode());
        ParameterSpace<Double> $beta = this.getBeta();
        result = result * 59 + ($beta == null ? 43 : $beta.hashCode());
        return result;
    }

    private BatchNormalizationSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<Double> decay;
        protected ParameterSpace<Double> eps;
        protected ParameterSpace<Boolean> isMinibatch;
        protected ParameterSpace<Boolean> lockGammaBeta;
        protected ParameterSpace<Double> gamma;
        protected ParameterSpace<Double> beta;

        public Builder minibatch(boolean minibatch) {
            return this.minibatch((ParameterSpace<Boolean>)new FixedValue((Object)minibatch));
        }

        public Builder minibatch(ParameterSpace<Boolean> minibatch) {
            this.isMinibatch = minibatch;
            return this;
        }

        public Builder gamma(double gamma) {
            return this.gamma((ParameterSpace<Double>)new FixedValue((Object)gamma));
        }

        public Builder gamma(ParameterSpace<Double> gamma) {
            this.gamma = gamma;
            return this;
        }

        public Builder beta(double beta) {
            return this.beta((ParameterSpace<Double>)new FixedValue((Object)beta));
        }

        public Builder beta(ParameterSpace<Double> beta) {
            this.beta = beta;
            return this;
        }

        public Builder eps(double eps) {
            return this.eps((ParameterSpace<Double>)new FixedValue((Object)eps));
        }

        public Builder eps(ParameterSpace<Double> eps) {
            this.eps = eps;
            return this;
        }

        public Builder decay(double decay) {
            return this.decay((ParameterSpace<Double>)new FixedValue((Object)decay));
        }

        public Builder decay(ParameterSpace<Double> decay) {
            this.decay = decay;
            return this;
        }

        public Builder lockGammaBeta(boolean lockGammaBeta) {
            return this.lockGammaBeta((ParameterSpace<Boolean>)new FixedValue((Object)lockGammaBeta));
        }

        public Builder lockGammaBeta(ParameterSpace<Boolean> lockGammaBeta) {
            this.lockGammaBeta = lockGammaBeta;
            return this;
        }

        @Override
        public BatchNormalizationSpace build() {
            return new BatchNormalizationSpace(this);
        }
    }
}

