/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public class ConvolutionLayerSpace
extends FeedForwardLayerSpace<ConvolutionLayer> {
    protected ParameterSpace<int[]> kernelSize;
    protected ParameterSpace<int[]> stride;
    protected ParameterSpace<int[]> padding;
    protected ParameterSpace<ConvolutionMode> convolutionMode;

    private ConvolutionLayerSpace(Builder builder) {
        super(builder);
        this.kernelSize = builder.kernelSize;
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.convolutionMode = builder.convolutionMode;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public ConvolutionLayer getValue(double[] values) {
        ConvolutionLayer.Builder b = new ConvolutionLayer.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(ConvolutionLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.kernelSize != null) {
            builder.kernelSize((int[])this.kernelSize.getValue(values));
        }
        if (this.stride != null) {
            builder.stride((int[])this.stride.getValue(values));
        }
        if (this.padding != null) {
            builder.padding((int[])this.padding.getValue(values));
        }
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("ConvolutionLayerSpace(");
        if (this.kernelSize != null) {
            sb.append("kernelSize: ").append(this.kernelSize).append(delim);
        }
        if (this.stride != null) {
            sb.append("stride: ").append(this.stride).append(delim);
        }
        if (this.padding != null) {
            sb.append("padding: ").append(this.padding).append(delim);
        }
        if (this.convolutionMode != null) {
            sb.append("convolutionMode: ").append(this.convolutionMode).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<int[]> getKernelSize() {
        return this.kernelSize;
    }

    public ParameterSpace<int[]> getStride() {
        return this.stride;
    }

    public ParameterSpace<int[]> getPadding() {
        return this.padding;
    }

    public ParameterSpace<ConvolutionMode> getConvolutionMode() {
        return this.convolutionMode;
    }

    public void setKernelSize(ParameterSpace<int[]> kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(ParameterSpace<int[]> stride) {
        this.stride = stride;
    }

    public void setPadding(ParameterSpace<int[]> padding) {
        this.padding = padding;
    }

    public void setConvolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvolutionLayerSpace)) {
            return false;
        }
        ConvolutionLayerSpace other = (ConvolutionLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<int[]> this$kernelSize = this.getKernelSize();
        ParameterSpace<int[]> other$kernelSize = other.getKernelSize();
        if (this$kernelSize == null ? other$kernelSize != null : !this$kernelSize.equals(other$kernelSize)) {
            return false;
        }
        ParameterSpace<int[]> this$stride = this.getStride();
        ParameterSpace<int[]> other$stride = other.getStride();
        if (this$stride == null ? other$stride != null : !this$stride.equals(other$stride)) {
            return false;
        }
        ParameterSpace<int[]> this$padding = this.getPadding();
        ParameterSpace<int[]> other$padding = other.getPadding();
        if (this$padding == null ? other$padding != null : !this$padding.equals(other$padding)) {
            return false;
        }
        ParameterSpace<ConvolutionMode> this$convolutionMode = this.getConvolutionMode();
        ParameterSpace<ConvolutionMode> other$convolutionMode = other.getConvolutionMode();
        return !(this$convolutionMode == null ? other$convolutionMode != null : !this$convolutionMode.equals(other$convolutionMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConvolutionLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ParameterSpace<int[]> $kernelSize = this.getKernelSize();
        result = result * 59 + ($kernelSize == null ? 43 : $kernelSize.hashCode());
        ParameterSpace<int[]> $stride = this.getStride();
        result = result * 59 + ($stride == null ? 43 : $stride.hashCode());
        ParameterSpace<int[]> $padding = this.getPadding();
        result = result * 59 + ($padding == null ? 43 : $padding.hashCode());
        ParameterSpace<ConvolutionMode> $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : $convolutionMode.hashCode());
        return result;
    }

    private ConvolutionLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<int[]> kernelSize;
        protected ParameterSpace<int[]> stride;
        protected ParameterSpace<int[]> padding;
        protected ParameterSpace<ConvolutionMode> convolutionMode;

        public Builder kernelSize(int ... kernelSize) {
            return this.kernelSize((ParameterSpace<int[]>)new FixedValue((Object)kernelSize));
        }

        public Builder kernelSize(ParameterSpace<int[]> kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            return this.stride((ParameterSpace<int[]>)new FixedValue((Object)stride));
        }

        public Builder stride(ParameterSpace<int[]> stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            return this.padding((ParameterSpace<int[]>)new FixedValue((Object)padding));
        }

        public Builder padding(ParameterSpace<int[]> padding) {
            this.padding = padding;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            return this.convolutionMode((ParameterSpace<ConvolutionMode>)new FixedValue((Object)convolutionMode));
        }

        public Builder convolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        @Override
        public ConvolutionLayerSpace build() {
            return new ConvolutionLayerSpace(this);
        }
    }
}

