/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class LayerSpace<L extends Layer>
extends AbstractParameterSpace<L> {
    protected ParameterSpace<Double> dropOut;
    protected int numParameters;

    protected LayerSpace(Builder builder) {
        this.dropOut = builder.dropOut;
    }

    public List<ParameterSpace> collectLeaves() {
        LinkedList<LayerSpace<L>> stack = new LinkedList<LayerSpace<L>>();
        stack.add(this);
        ArrayList<ParameterSpace> out = new ArrayList<ParameterSpace>();
        while (!stack.isEmpty()) {
            ParameterSpace next = (ParameterSpace)stack.removeLast();
            if (next.isLeaf()) {
                out.add(next);
                continue;
            }
            Map m = next.getNestedSpaces();
            ParameterSpace[] arr = m.values().toArray(new ParameterSpace[m.size()]);
            for (int i = arr.length - 1; i >= 0; --i) {
                stack.add((LayerSpace<L>)arr[i]);
            }
        }
        return out;
    }

    public int numParameters() {
        return this.numParameters;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non-leaf parameter space");
    }

    protected void setLayerOptionsBuilder(Layer.Builder builder, double[] values) {
        if (this.dropOut != null) {
            builder.dropOut(((Double)this.dropOut.getValue(values)).doubleValue());
        }
    }

    public String toString() {
        return this.toString(", ");
    }

    protected String toString(String delim) {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.dropOut != null) {
            sb.append("dropOut: ").append(this.dropOut).append(delim);
        }
        if ((s = sb.toString()).endsWith(delim)) {
            int last = s.lastIndexOf(delim);
            return s.substring(0, last);
        }
        return s;
    }

    public ParameterSpace<Double> getDropOut() {
        return this.dropOut;
    }

    public int getNumParameters() {
        return this.numParameters;
    }

    public void setDropOut(ParameterSpace<Double> dropOut) {
        this.dropOut = dropOut;
    }

    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LayerSpace)) {
            return false;
        }
        LayerSpace other = (LayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Double> this$dropOut = this.getDropOut();
        ParameterSpace<Double> other$dropOut = other.getDropOut();
        if (this$dropOut == null ? other$dropOut != null : !this$dropOut.equals(other$dropOut)) {
            return false;
        }
        return this.getNumParameters() == other.getNumParameters();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LayerSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Double> $dropOut = this.getDropOut();
        result = result * 59 + ($dropOut == null ? 43 : $dropOut.hashCode());
        result = result * 59 + this.getNumParameters();
        return result;
    }

    protected LayerSpace() {
    }

    public static abstract class Builder<T> {
        protected ParameterSpace<Double> dropOut;

        public T dropOut(double dropOut) {
            return this.dropOut((ParameterSpace<Double>)new FixedValue((Object)dropOut));
        }

        public T dropOut(ParameterSpace<Double> dropOut) {
            this.dropOut = dropOut;
            return (T)this;
        }

        public abstract <E extends LayerSpace> E build();
    }
}

