/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.saver.local;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.deeplearning4j.arbiter.DL4JConfiguration;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.util.ModelSerializer;

public class LocalFileNetResultReference
implements ResultReference {
    private int index;
    private String dir;
    private boolean isGraph;
    private File modelFile;
    private File scoreFile;
    private File additionalResultsFile;
    private File esConfigFile;
    private File numEpochsFile;
    private Candidate<DL4JConfiguration> candidate;

    public OptimizationResult getResult() throws IOException {
        Object additionalResults;
        double d;
        Object m;
        block32: {
            m = this.isGraph ? ModelSerializer.restoreComputationGraph((File)this.modelFile, (boolean)false) : ModelSerializer.restoreMultiLayerNetwork((File)this.modelFile, (boolean)false);
            String scoreStr = FileUtils.readFileToString((File)this.scoreFile);
            d = Double.parseDouble(scoreStr);
            EarlyStoppingConfiguration earlyStoppingConfiguration = null;
            if (this.esConfigFile != null && this.esConfigFile.exists()) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.esConfigFile));){
                    earlyStoppingConfiguration = (EarlyStoppingConfiguration)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading early stopping configuration", e);
                }
            }
            int nEpochs = 1;
            if (this.numEpochsFile != null && this.numEpochsFile.exists()) {
                String numEpochs = FileUtils.readFileToString((File)this.numEpochsFile);
                nEpochs = Integer.parseInt(numEpochs);
            }
            Serializable dl4jConfiguration = this.isGraph ? new GraphConfiguration(m.getConfiguration(), earlyStoppingConfiguration, nEpochs) : new DL4JConfiguration(((MultiLayerNetwork)m).getLayerWiseConfigurations(), earlyStoppingConfiguration, nEpochs);
            if (this.additionalResultsFile.exists()) {
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.additionalResultsFile));){
                    additionalResults = ois.readObject();
                    break block32;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading additional results", e);
                }
            }
            additionalResults = null;
        }
        return new OptimizationResult(this.candidate, m, Double.valueOf(d), this.index, additionalResults, null);
    }

    public String toString() {
        return "LocalFileNetResultReference(" + this.dir + ")";
    }

    @ConstructorProperties(value={"index", "dir", "isGraph", "modelFile", "scoreFile", "additionalResultsFile", "esConfigFile", "numEpochsFile", "candidate"})
    public LocalFileNetResultReference(int index, String dir, boolean isGraph, File modelFile, File scoreFile, File additionalResultsFile, File esConfigFile, File numEpochsFile, Candidate<DL4JConfiguration> candidate) {
        this.index = index;
        this.dir = dir;
        this.isGraph = isGraph;
        this.modelFile = modelFile;
        this.scoreFile = scoreFile;
        this.additionalResultsFile = additionalResultsFile;
        this.esConfigFile = esConfigFile;
        this.numEpochsFile = numEpochsFile;
        this.candidate = candidate;
    }
}

