/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.task;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.deeplearning4j.arbiter.DL4JConfiguration;
import org.deeplearning4j.arbiter.listener.DL4JArbiterStatusReportingListener;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.TaskCreator;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.evaluation.ModelEvaluator;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.optimize.runner.CandidateInfo;
import org.deeplearning4j.arbiter.optimize.runner.CandidateStatus;
import org.deeplearning4j.arbiter.optimize.runner.listener.StatusListener;
import org.deeplearning4j.arbiter.scoring.util.ScoreUtil;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.trainer.EarlyStoppingTrainer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class MultiLayerNetworkTaskCreator
implements TaskCreator {
    private ModelEvaluator modelEvaluator;

    public Callable<OptimizationResult> create(Candidate candidate, DataProvider dataProvider, ScoreFunction scoreFunction, List<StatusListener> statusListeners) {
        return new DL4JLearningTask(candidate, dataProvider, scoreFunction, this.modelEvaluator, statusListeners);
    }

    @ConstructorProperties(value={"modelEvaluator"})
    public MultiLayerNetworkTaskCreator(ModelEvaluator modelEvaluator) {
        this.modelEvaluator = modelEvaluator;
    }

    public MultiLayerNetworkTaskCreator() {
    }

    private static class DL4JLearningTask
    implements Callable<OptimizationResult> {
        private Candidate candidate;
        private DataProvider dataProvider;
        private ScoreFunction scoreFunction;
        private ModelEvaluator modelEvaluator;
        private List<StatusListener> listeners;
        private long startTime;

        public DL4JLearningTask(Candidate candidate, DataProvider dataProvider, ScoreFunction scoreFunction, ModelEvaluator modelEvaluator, List<StatusListener> listeners) {
            this.candidate = candidate;
            this.dataProvider = dataProvider;
            this.scoreFunction = scoreFunction;
            this.modelEvaluator = modelEvaluator;
            this.listeners = listeners;
        }

        @Override
        public OptimizationResult call() throws Exception {
            try {
                return this.callHelper();
            }
            catch (Exception e) {
                String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
                CandidateInfo ci = new CandidateInfo(this.candidate.getIndex(), CandidateStatus.Failed, null, this.startTime, null, null, this.candidate.getFlatParameters(), stackTrace);
                return new OptimizationResult(this.candidate, null, null, this.candidate.getIndex(), null, ci);
            }
        }

        private OptimizationResult callHelper() throws Exception {
            this.startTime = System.currentTimeMillis();
            CandidateInfo ci = new CandidateInfo(this.candidate.getIndex(), CandidateStatus.Running, null, System.currentTimeMillis(), null, null, this.candidate.getFlatParameters(), null);
            MultiLayerNetwork net = new MultiLayerNetwork(((DL4JConfiguration)this.candidate.getValue()).getMultiLayerConfiguration());
            net.init();
            if (this.listeners != null) {
                net.setListeners(new IterationListener[]{new DL4JArbiterStatusReportingListener(this.listeners, ci)});
            }
            DataSetIterator dataSetIterator = ScoreUtil.getIterator(this.dataProvider.trainData(this.candidate.getDataParameters()));
            EarlyStoppingConfiguration esConfig = ((DL4JConfiguration)this.candidate.getValue()).getEarlyStoppingConfiguration();
            EarlyStoppingResult esResult = null;
            if (esConfig != null) {
                EarlyStoppingTrainer trainer = new EarlyStoppingTrainer(esConfig, net, dataSetIterator, null);
                esResult = trainer.fit();
                net = (MultiLayerNetwork)esResult.getBestModel();
                switch (esResult.getTerminationReason()) {
                    case Error: {
                        ci.setCandidateStatus(CandidateStatus.Failed);
                        ci.setExceptionStackTrace(esResult.getTerminationDetails());
                        break;
                    }
                    case IterationTerminationCondition: 
                    case EpochTerminationCondition: {
                        ci.setCandidateStatus(CandidateStatus.Complete);
                    }
                }
            } else {
                int nEpochs = ((DL4JConfiguration)this.candidate.getValue()).getNumEpochs();
                for (int i = 0; i < nEpochs; ++i) {
                    net.fit(dataSetIterator);
                }
                ci.setCandidateStatus(CandidateStatus.Complete);
            }
            Object additionalEvaluation = null;
            if (esConfig != null && esResult.getTerminationReason() != EarlyStoppingResult.TerminationReason.Error) {
                additionalEvaluation = this.modelEvaluator != null ? this.modelEvaluator.evaluateModel((Object)net, this.dataProvider) : null;
            }
            Double score = null;
            if (net != null) {
                score = this.scoreFunction.score((Object)net, this.dataProvider, this.candidate.getDataParameters());
                ci.setScore(score);
            }
            return new OptimizationResult(this.candidate, (Object)net, score, this.candidate.getIndex(), additionalEvaluation, ci);
        }
    }
}

