/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.ui.data;

import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.compress.utils.IOUtils;
import org.deeplearning4j.api.storage.Persistable;

public abstract class BaseJavaPersistable
implements Persistable {
    private String sessionId;
    private long timestamp;

    public BaseJavaPersistable(Builder builder) {
        this.sessionId = builder.sessionId;
        this.timestamp = builder.timestamp;
    }

    protected BaseJavaPersistable() {
    }

    public String getTypeID() {
        return "ArbiterUI";
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String getSessionID() {
        return this.sessionId;
    }

    public int encodingLengthBytes() {
        byte[] encoded = this.encode();
        return encoded.length;
    }

    public byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    public void encode(ByteBuffer buffer) {
        buffer.put(this.encode());
    }

    public void encode(OutputStream outputStream) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(this);
        }
    }

    public void decode(byte[] decode) {
        BaseJavaPersistable r;
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decode));){
            r = (BaseJavaPersistable)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ArrayList classHeirarchy = new ArrayList();
        for (Class<?> currClass = this.getClass(); currClass != Object.class; currClass = currClass.getSuperclass()) {
            classHeirarchy.add(currClass);
        }
        for (int i = classHeirarchy.size() - 1; i >= 0; --i) {
            Field[] allFields;
            for (Field f2 : allFields = ((Class)classHeirarchy.get(i)).getDeclaredFields()) {
                if (Modifier.isStatic(f2.getModifiers())) continue;
                f2.setAccessible(true);
                try {
                    f2.set(this, f2.get(r));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void decode(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        this.decode(bytes);
    }

    public void decode(InputStream inputStream) throws IOException {
        this.decode(IOUtils.toByteArray((InputStream)inputStream));
    }

    @ConstructorProperties(value={"sessionId", "timestamp"})
    public BaseJavaPersistable(String sessionId, long timestamp) {
        this.sessionId = sessionId;
        this.timestamp = timestamp;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String sessionId;
        protected long timestamp;

        public T sessionId(String sessionId) {
            this.sessionId = sessionId;
            return (T)this;
        }

        public T timestamp(long timestamp) {
            this.timestamp = timestamp;
            return (T)this;
        }
    }
}

