/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.ui.data;

import org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration;
import org.deeplearning4j.arbiter.ui.data.BaseJavaPersistable;
import org.deeplearning4j.arbiter.ui.misc.JsonMapper;

public class GlobalConfigPersistable
extends BaseJavaPersistable {
    public static final String GLOBAL_WORKER_ID = "global";
    private String optimizationConfigJson;
    private int[] candidateCounts;
    private String optimizationRunner;

    public GlobalConfigPersistable(String sessionId, long timestamp) {
        super(sessionId, timestamp);
    }

    public GlobalConfigPersistable(Builder builder) {
        super(builder);
        this.optimizationConfigJson = builder.optimizationConfigJson;
        this.candidateCounts = builder.candidateCounts;
        if (this.candidateCounts == null) {
            this.candidateCounts = new int[4];
        }
        this.optimizationRunner = builder.optimizationRunner;
    }

    public GlobalConfigPersistable() {
    }

    @Override
    public String getTypeID() {
        return "ArbiterUI";
    }

    public String getWorkerID() {
        return GLOBAL_WORKER_ID;
    }

    public OptimizationConfiguration getOptimizationConfiguration() {
        return JsonMapper.fromJson(this.optimizationConfigJson, OptimizationConfiguration.class);
    }

    public int getCandidatesQueued() {
        return this.candidateCounts[0];
    }

    public int getCandidatesCompleted() {
        return this.candidateCounts[1];
    }

    public int getCandidatesFailed() {
        return this.candidateCounts[2];
    }

    public int getCandidatesTotal() {
        return this.candidateCounts[3];
    }

    public String getOptimizationConfigJson() {
        return this.optimizationConfigJson;
    }

    public int[] getCandidateCounts() {
        return this.candidateCounts;
    }

    public String getOptimizationRunner() {
        return this.optimizationRunner;
    }

    public static class Builder
    extends BaseJavaPersistable.Builder<Builder> {
        private String optimizationConfigJson;
        private int[] candidateCounts;
        private String optimizationRunner;

        public Builder optimizationConfigJson(String optimizationConfigJson) {
            this.optimizationConfigJson = optimizationConfigJson;
            return this;
        }

        public Builder candidateCounts(int queued, int completed, int failed, int total) {
            this.candidateCounts = new int[]{queued, completed, failed, total};
            return this;
        }

        public Builder optimizationRunner(String optimizationRunner) {
            this.optimizationRunner = optimizationRunner;
            return this;
        }

        public GlobalConfigPersistable build() {
            return new GlobalConfigPersistable(this);
        }
    }
}

