/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.ui.data;

import java.util.Arrays;
import org.deeplearning4j.arbiter.optimize.runner.CandidateStatus;
import org.deeplearning4j.arbiter.ui.data.BaseJavaPersistable;

public class ModelInfoPersistable
extends BaseJavaPersistable {
    private String workerId;
    private Integer modelIdx;
    private Double score;
    private CandidateStatus status;
    private long lastUpdateTime;
    private long numParameters;
    private int numLayers;
    private double[] paramSpaceValues;
    private int totalNumUpdates;
    private int[] iter;
    private float[] scoreVsIter;
    private String modelConfigJson;
    private String exceptionStackTrace;

    public ModelInfoPersistable(String sessionId, String workerId, long timeStamp) {
        super(sessionId, timeStamp);
        this.workerId = workerId;
    }

    private ModelInfoPersistable(Builder builder) {
        super(builder);
        this.workerId = builder.workerId;
        this.modelIdx = builder.modelIdx;
        this.score = builder.score;
        this.status = builder.status;
        this.iter = builder.iter;
        this.scoreVsIter = builder.scoreVsIter;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.numParameters = builder.numParameters;
        this.numLayers = builder.numLayers;
        this.paramSpaceValues = builder.paramSpaceValues;
        this.modelConfigJson = builder.modelConfigJson;
        this.totalNumUpdates = builder.totalNumUpdates;
        this.exceptionStackTrace = builder.exceptionStackTrace;
    }

    public ModelInfoPersistable() {
    }

    public String getWorkerID() {
        return this.workerId;
    }

    public Integer getModelIdx() {
        return this.modelIdx;
    }

    public Double getScore() {
        return this.score;
    }

    public CandidateStatus getStatus() {
        return this.status;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public long getNumParameters() {
        return this.numParameters;
    }

    public int getNumLayers() {
        return this.numLayers;
    }

    public double[] getParamSpaceValues() {
        return this.paramSpaceValues;
    }

    public int getTotalNumUpdates() {
        return this.totalNumUpdates;
    }

    public int[] getIter() {
        return this.iter;
    }

    public float[] getScoreVsIter() {
        return this.scoreVsIter;
    }

    public String getModelConfigJson() {
        return this.modelConfigJson;
    }

    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public void setModelIdx(Integer modelIdx) {
        this.modelIdx = modelIdx;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public void setStatus(CandidateStatus status) {
        this.status = status;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setNumParameters(long numParameters) {
        this.numParameters = numParameters;
    }

    public void setNumLayers(int numLayers) {
        this.numLayers = numLayers;
    }

    public void setParamSpaceValues(double[] paramSpaceValues) {
        this.paramSpaceValues = paramSpaceValues;
    }

    public void setTotalNumUpdates(int totalNumUpdates) {
        this.totalNumUpdates = totalNumUpdates;
    }

    public void setIter(int[] iter) {
        this.iter = iter;
    }

    public void setScoreVsIter(float[] scoreVsIter) {
        this.scoreVsIter = scoreVsIter;
    }

    public void setModelConfigJson(String modelConfigJson) {
        this.modelConfigJson = modelConfigJson;
    }

    public void setExceptionStackTrace(String exceptionStackTrace) {
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelInfoPersistable)) {
            return false;
        }
        ModelInfoPersistable other = (ModelInfoPersistable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workerId = this.getWorkerID();
        String other$workerId = other.getWorkerID();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        Integer this$modelIdx = this.getModelIdx();
        Integer other$modelIdx = other.getModelIdx();
        if (this$modelIdx == null ? other$modelIdx != null : !((Object)this$modelIdx).equals(other$modelIdx)) {
            return false;
        }
        Double this$score = this.getScore();
        Double other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        CandidateStatus this$status = this.getStatus();
        CandidateStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        if (this.getNumParameters() != other.getNumParameters()) {
            return false;
        }
        if (this.getNumLayers() != other.getNumLayers()) {
            return false;
        }
        if (!Arrays.equals(this.getParamSpaceValues(), other.getParamSpaceValues())) {
            return false;
        }
        if (this.getTotalNumUpdates() != other.getTotalNumUpdates()) {
            return false;
        }
        if (!Arrays.equals(this.getIter(), other.getIter())) {
            return false;
        }
        if (!Arrays.equals(this.getScoreVsIter(), other.getScoreVsIter())) {
            return false;
        }
        String this$modelConfigJson = this.getModelConfigJson();
        String other$modelConfigJson = other.getModelConfigJson();
        if (this$modelConfigJson == null ? other$modelConfigJson != null : !this$modelConfigJson.equals(other$modelConfigJson)) {
            return false;
        }
        String this$exceptionStackTrace = this.getExceptionStackTrace();
        String other$exceptionStackTrace = other.getExceptionStackTrace();
        return !(this$exceptionStackTrace == null ? other$exceptionStackTrace != null : !this$exceptionStackTrace.equals(other$exceptionStackTrace));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelInfoPersistable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workerId = this.getWorkerID();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        Integer $modelIdx = this.getModelIdx();
        result = result * 59 + ($modelIdx == null ? 43 : ((Object)$modelIdx).hashCode());
        Double $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        CandidateStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        long $numParameters = this.getNumParameters();
        result = result * 59 + (int)($numParameters >>> 32 ^ $numParameters);
        result = result * 59 + this.getNumLayers();
        result = result * 59 + Arrays.hashCode(this.getParamSpaceValues());
        result = result * 59 + this.getTotalNumUpdates();
        result = result * 59 + Arrays.hashCode(this.getIter());
        result = result * 59 + Arrays.hashCode(this.getScoreVsIter());
        String $modelConfigJson = this.getModelConfigJson();
        result = result * 59 + ($modelConfigJson == null ? 43 : $modelConfigJson.hashCode());
        String $exceptionStackTrace = this.getExceptionStackTrace();
        result = result * 59 + ($exceptionStackTrace == null ? 43 : $exceptionStackTrace.hashCode());
        return result;
    }

    public String toString() {
        return "ModelInfoPersistable(workerId=" + this.getWorkerID() + ", modelIdx=" + this.getModelIdx() + ", score=" + this.getScore() + ", status=" + this.getStatus() + ", lastUpdateTime=" + this.getLastUpdateTime() + ", numParameters=" + this.getNumParameters() + ", numLayers=" + this.getNumLayers() + ", paramSpaceValues=" + Arrays.toString(this.getParamSpaceValues()) + ", totalNumUpdates=" + this.getTotalNumUpdates() + ", iter=" + Arrays.toString(this.getIter()) + ", scoreVsIter=" + Arrays.toString(this.getScoreVsIter()) + ", modelConfigJson=" + this.getModelConfigJson() + ", exceptionStackTrace=" + this.getExceptionStackTrace() + ")";
    }

    public static class Builder
    extends BaseJavaPersistable.Builder<Builder> {
        private String workerId;
        private Integer modelIdx;
        private Double score;
        private CandidateStatus status;
        private long lastUpdateTime;
        private long numParameters;
        private int numLayers;
        private int totalNumUpdates;
        private double[] paramSpaceValues;
        private int[] iter;
        private float[] scoreVsIter;
        private String modelConfigJson;
        private String exceptionStackTrace;

        public Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public Builder modelIdx(Integer idx) {
            this.modelIdx = idx;
            return this;
        }

        public Builder score(Double score) {
            this.score = score;
            return this;
        }

        public Builder status(CandidateStatus status) {
            this.status = status;
            return this;
        }

        public Builder scoreVsIter(int[] iter, float[] scoreVsIter) {
            this.iter = iter;
            this.scoreVsIter = scoreVsIter;
            return this;
        }

        public Builder lastUpdateTime(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public Builder numParameters(long numParameters) {
            this.numParameters = numParameters;
            return this;
        }

        public Builder numLayers(int numLayers) {
            this.numLayers = numLayers;
            return this;
        }

        public Builder totalNumUpdates(int totalNumUpdates) {
            this.totalNumUpdates = totalNumUpdates;
            return this;
        }

        public Builder paramSpaceValues(double[] paramSpaceValues) {
            this.paramSpaceValues = paramSpaceValues;
            return this;
        }

        public Builder modelConfigJson(String modelConfigJson) {
            this.modelConfigJson = modelConfigJson;
            return this;
        }

        public Builder exceptionStackTrace(String exceptionStackTrace) {
            this.exceptionStackTrace = exceptionStackTrace;
            return this;
        }

        public ModelInfoPersistable build() {
            return new ModelInfoPersistable(this);
        }
    }
}

