/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.ui.misc;

import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class UIUtils {
    public static double[] graphNiceRange(double max, double min, int nTick) {
        if (max == min || !Double.isFinite(max)) {
            if (max == 0.0 || !Double.isFinite(max)) {
                return new double[]{0.0, 1.0};
            }
            return UIUtils.graphNiceRange(1.5 * max, 0.5 * max, nTick);
        }
        double range = UIUtils.niceNum(max - min, false);
        double d = UIUtils.niceNum(range / (double)(nTick - 1), true);
        double graphMin = Math.floor(min / d) * d;
        double graphMax = Math.ceil(max / d) * d;
        return new double[]{graphMin, graphMax};
    }

    public static double niceNum(double x, boolean round) {
        double exp = Math.floor(Math.log10(x));
        double f2 = x / Math.pow(10.0, exp);
        double nf = round ? (f2 < 1.5 ? 1.0 : (f2 < 3.0 ? 2.0 : (f2 < 7.0 ? 5.0 : 10.0))) : (f2 <= 1.0 ? 1.0 : (f2 <= 2.0 ? 2.0 : (f2 <= 5.0 ? 5.0 : 10.0)));
        return nf * Math.pow(10.0, exp);
    }

    public static String formatDuration(long durationMs) {
        Period period = Period.seconds((int)((int)(durationMs / 1000L)));
        Period p2 = period.normalizedStandard(PeriodType.yearMonthDayTime());
        PeriodFormatter formatter = new PeriodFormatterBuilder().appendYears().appendSuffix(" yr ").appendMonths().appendSuffix(" months ").appendDays().appendSuffix(" days ").appendHours().appendSuffix(" hr ").appendMinutes().appendSuffix(" min ").appendSeconds().appendSuffix(" sec").toFormatter();
        return formatter.print((ReadablePeriod)p2);
    }
}

