/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.ui.module;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.arbiter.BaseNetworkSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.termination.TerminationCondition;
import org.deeplearning4j.arbiter.optimize.config.OptimizationConfiguration;
import org.deeplearning4j.arbiter.optimize.runner.CandidateStatus;
import org.deeplearning4j.arbiter.ui.UpdateStatus;
import org.deeplearning4j.arbiter.ui.data.GlobalConfigPersistable;
import org.deeplearning4j.arbiter.ui.data.ModelInfoPersistable;
import org.deeplearning4j.arbiter.ui.misc.JsonMapper;
import org.deeplearning4j.arbiter.ui.misc.UIUtils;
import org.deeplearning4j.arbiter.ui.views.html.ArbiterUI;
import org.deeplearning4j.arbiter.util.ObjectUtils;
import org.deeplearning4j.ui.api.Component;
import org.deeplearning4j.ui.api.FunctionType;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.LengthUnit;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.Style;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.components.chart.ChartLine;
import org.deeplearning4j.ui.components.chart.ChartScatter;
import org.deeplearning4j.ui.components.chart.style.StyleChart;
import org.deeplearning4j.ui.components.component.ComponentDiv;
import org.deeplearning4j.ui.components.component.style.StyleDiv;
import org.deeplearning4j.ui.components.table.ComponentTable;
import org.deeplearning4j.ui.components.table.style.StyleTable;
import org.deeplearning4j.ui.components.text.ComponentText;
import org.deeplearning4j.ui.components.text.style.StyleText;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;

public class ArbiterModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(ArbiterModule.class);
    private static final DecimalFormat DECIMAL_FORMAT_2DP = new DecimalFormat("#.00");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm ZZ");
    public static final String ARBITER_UI_TYPE_ID = "ArbiterUI";
    private static final String JSON = "application/json";
    private AtomicBoolean loggedArbiterAddress = new AtomicBoolean(false);
    private Map<String, StatsStorage> knownSessionIDs = Collections.synchronizedMap(new LinkedHashMap());
    private String currentSessionID;
    private Map<String, Long> lastUpdateForSession = Collections.synchronizedMap(new HashMap());
    private static final StyleTable STYLE_TABLE = ((StyleTable.Builder)new StyleTable.Builder().width(100.0, LengthUnit.Percent)).backgroundColor(Color.WHITE).borderWidth(1).columnWidths(LengthUnit.Percent, new double[]{30.0, 70.0}).build();
    private static final StyleTable STYLE_TABLE3_25_25_50 = ((StyleTable.Builder)new StyleTable.Builder().width(100.0, LengthUnit.Percent)).backgroundColor(Color.WHITE).borderWidth(1).columnWidths(LengthUnit.Percent, new double[]{25.0, 25.0, 50.0}).build();
    private static final StyleDiv STYLE_DIV_WIDTH_100_PC = ((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).build();
    private static final ComponentDiv DIV_SPACER_20PX = new ComponentDiv((Style)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).height(20.0, LengthUnit.Px)).build(), new Component[0]);
    private static final ComponentDiv DIV_SPACER_60PX = new ComponentDiv((Style)((StyleDiv.Builder)((StyleDiv.Builder)new StyleDiv.Builder().width(100.0, LengthUnit.Percent)).height(60.0, LengthUnit.Px)).build(), new Component[0]);
    private static final StyleChart STYLE_CHART_560_320 = ((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(560.0, LengthUnit.Px)).height(320.0, LengthUnit.Px)).build();
    private static final StyleChart STYLE_CHART_800_400 = ((StyleChart.Builder)((StyleChart.Builder)new StyleChart.Builder().width(800.0, LengthUnit.Px)).height(400.0, LengthUnit.Px)).build();
    private StyleText STYLE_TEXT_SZ12 = new StyleText.Builder().fontSize(12.0).build();
    private StyleText STYLE_TEXT_SZ10_WHITESPACE_PRE = new StyleText.Builder().fontSize(10.0).whitespacePre(true).build();

    public List<String> getCallbackTypeIDs() {
        return Collections.singletonList(ARBITER_UI_TYPE_ID);
    }

    public List<Route> getRoutes() {
        Route r1 = new Route("/arbiter", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)ArbiterUI.apply()));
        Route r3 = new Route("/arbiter/lastUpdate", HttpMethod.GET, FunctionType.Supplier, this::getLastUpdateTime);
        Route r4 = new Route("/arbiter/lastUpdate/:ids", HttpMethod.GET, FunctionType.Function, this::getModelLastUpdateTimes);
        Route r5 = new Route("/arbiter/candidateInfo/:id", HttpMethod.GET, FunctionType.Function, this::getCandidateInfo);
        Route r6 = new Route("/arbiter/config", HttpMethod.GET, FunctionType.Supplier, this::getOptimizationConfig);
        Route r7 = new Route("/arbiter/results", HttpMethod.GET, FunctionType.Supplier, this::getSummaryResults);
        Route r8 = new Route("/arbiter/summary", HttpMethod.GET, FunctionType.Supplier, this::getSummaryStatus);
        Route r9a = new Route("/arbiter/sessions/all", HttpMethod.GET, FunctionType.Supplier, this::listSessions);
        Route r9b = new Route("/arbiter/sessions/current", HttpMethod.GET, FunctionType.Supplier, this::currentSession);
        Route r9c = new Route("/arbiter/sessions/set/:to", HttpMethod.GET, FunctionType.Function, this::setSession);
        return Arrays.asList(r1, r3, r4, r5, r6, r7, r8, r9a, r9b, r9c);
    }

    public void reportStorageEvents(Collection<StatsStorageEvent> events) {
        boolean attachedArbiter = false;
        for (StatsStorageEvent sse : events) {
            Long lastUpdate;
            if (!ARBITER_UI_TYPE_ID.equals(sse.getTypeID())) continue;
            if (sse.getEventType() == StatsStorageListener.EventType.PostStaticInfo) {
                this.knownSessionIDs.put(sse.getSessionID(), sse.getStatsStorage());
            }
            if ((lastUpdate = this.lastUpdateForSession.get(sse.getSessionID())) == null) {
                this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
            } else if (sse.getTimestamp() > lastUpdate) {
                this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
            }
            attachedArbiter = true;
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
        if (attachedArbiter && !this.loggedArbiterAddress.getAndSet(true)) {
            String address = UIServer.getInstance().getAddress();
            address = address + "/arbiter";
            log.info("DL4J Arbiter Hyperparameter Optimization UI: {}", (Object)address);
        }
    }

    public synchronized void onAttach(StatsStorage statsStorage) {
        for (String sessionID : statsStorage.listSessionIDs()) {
            for (String typeID : statsStorage.listTypeIDsForSession(sessionID)) {
                if (!ARBITER_UI_TYPE_ID.equals(typeID)) continue;
                this.knownSessionIDs.put(sessionID, statsStorage);
            }
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
    }

    private Result currentSession() {
        String sid = this.currentSessionID == null ? "" : this.currentSessionID;
        return Results.ok((String)JsonMapper.asJson(sid)).as(JSON);
    }

    private Result listSessions() {
        return Results.ok((String)JsonMapper.asJson(this.knownSessionIDs.keySet())).as(JSON);
    }

    private Result setSession(String newSessionID) {
        log.info("SET TO SESSION: {}", (Object)newSessionID);
        if (this.knownSessionIDs.containsKey(newSessionID)) {
            this.currentSessionID = newSessionID;
            return Results.ok();
        }
        return Results.badRequest((String)("Unknown session ID: " + newSessionID));
    }

    private void getDefaultSession() {
        if (this.currentSessionID != null) {
            return;
        }
        long mostRecentTime = Long.MIN_VALUE;
        String sessionID = null;
        for (Map.Entry<String, StatsStorage> entry : this.knownSessionIDs.entrySet()) {
            Persistable p;
            long thisTime;
            List staticInfos = entry.getValue().getAllStaticInfos(entry.getKey(), ARBITER_UI_TYPE_ID);
            if (staticInfos == null || staticInfos.size() == 0 || (thisTime = (p = (Persistable)staticInfos.get(0)).getTimeStamp()) <= mostRecentTime) continue;
            mostRecentTime = thisTime;
            sessionID = entry.getKey();
        }
        if (sessionID != null) {
            this.currentSessionID = sessionID;
        }
    }

    public void onDetach(StatsStorage statsStorage) {
        for (String s : this.knownSessionIDs.keySet()) {
            if (this.knownSessionIDs.get(s) != statsStorage) continue;
            this.knownSessionIDs.remove(s);
        }
    }

    private Result getLastUpdateTime() {
        long t = System.currentTimeMillis();
        UpdateStatus us = new UpdateStatus(t, t, t);
        return Results.ok((JsonNode)Json.toJson((Object)us));
    }

    private Result getModelLastUpdateTimes(String modelIDs) {
        if (this.currentSessionID == null) {
            return Results.ok();
        }
        StatsStorage ss = this.knownSessionIDs.get(this.currentSessionID);
        if (ss == null) {
            log.warn("getModelLastUpdateTimes(): Session ID is unknown: {}", (Object)this.currentSessionID);
            return Results.ok((String)"-1");
        }
        String[] split = modelIDs.split(",");
        long[] lastUpdateTimes = new long[split.length];
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            Persistable p = ss.getLatestUpdate(this.currentSessionID, ARBITER_UI_TYPE_ID, s);
            if (p == null) continue;
            lastUpdateTimes[i] = p.getTimeStamp();
        }
        return Results.ok((JsonNode)Json.toJson((Object)lastUpdateTimes));
    }

    private Result getCandidateInfo(String candidateId) {
        String modelJson;
        StatsStorage ss = this.knownSessionIDs.get(this.currentSessionID);
        if (ss == null) {
            log.warn("getModelLastUpdateTimes(): Session ID is unknown: {}", (Object)this.currentSessionID);
            return Results.ok();
        }
        GlobalConfigPersistable gcp = (GlobalConfigPersistable)ss.getStaticInfo(this.currentSessionID, ARBITER_UI_TYPE_ID, "global");
        OptimizationConfiguration oc = gcp.getOptimizationConfiguration();
        Persistable p = ss.getLatestUpdate(this.currentSessionID, ARBITER_UI_TYPE_ID, candidateId);
        if (p == null) {
            String title = "No results found for model " + candidateId + ".";
            ComponentText ct = new ComponentText.Builder(title, this.STYLE_TEXT_SZ12).build();
            return Results.ok((String)JsonMapper.asJson(ct)).as(JSON);
        }
        ModelInfoPersistable mip = (ModelInfoPersistable)p;
        ArrayList<Object> components = new ArrayList<Object>();
        long runtimeDurationMs = mip.getLastUpdateTime() - mip.getTimeStamp();
        double avgMinibatchesPerSec = (double)mip.getTotalNumUpdates() / ((double)runtimeDurationMs / 1000.0);
        String avgMinibatchesPerSecStr = DECIMAL_FORMAT_2DP.format(avgMinibatchesPerSec);
        String runtimeStr = UIUtils.formatDuration(runtimeDurationMs);
        if (mip.getStatus() == CandidateStatus.Failed) {
            runtimeStr = "";
            avgMinibatchesPerSecStr = "";
        }
        String[][] table = new String[][]{{"Model Index", String.valueOf(mip.getModelIdx())}, {"Status", mip.getStatus().toString()}, {"Model Score", mip.getScore() == null ? "" : String.valueOf(mip.getScore())}, {"Created", TIME_FORMATTER.print(mip.getTimeStamp())}, {"Runtime", runtimeStr}, {"Total Number of Model Updates", String.valueOf(mip.getTotalNumUpdates())}, {"Average # Updates / Sec", avgMinibatchesPerSecStr}, {"Number of Parameters", String.valueOf(mip.getNumParameters())}, {"Number of Layers", String.valueOf(mip.getNumLayers())}};
        ComponentTable cTable = new ComponentTable.Builder(STYLE_TABLE).content(table).header(new String[]{"Model Information", ""}).build();
        components.add(cTable);
        double[] paramSpaceValues = mip.getParamSpaceValues();
        if (paramSpaceValues != null) {
            BaseNetworkSpace bns = (BaseNetworkSpace)oc.getCandidateGenerator().getParameterSpace();
            Map m = bns.getNestedSpaces();
            String[][] hSpaceTable = new String[m.size()][3];
            int i = 0;
            for (Map.Entry e : m.entrySet()) {
                hSpaceTable[i][0] = (String)e.getKey();
                Object currCandidateValue = ((ParameterSpace)e.getValue()).getValue(paramSpaceValues);
                hSpaceTable[i][1] = ObjectUtils.valueToString((Object)currCandidateValue);
                hSpaceTable[i][2] = ((ParameterSpace)e.getValue()).toString();
                ++i;
            }
            String[] hSpaceTableHeader = new String[]{"Hyperparameter", "Model Value", "Hyperparameter Space"};
            ComponentTable ct2 = new ComponentTable.Builder(STYLE_TABLE3_25_25_50).content(hSpaceTable).header(hSpaceTableHeader).build();
            String title = "Global Network Configuration";
            components.add(DIV_SPACER_20PX);
            components.add(new ComponentText.Builder(title, this.STYLE_TEXT_SZ12).build());
            components.add(ct2);
            List layerConfs = bns.getLayerSpaces();
            for (BaseNetworkSpace.LayerConf l : layerConfs) {
                LayerSpace ls = l.getLayerSpace();
                Map lpsm = ls.getNestedSpaces();
                String[][] t = new String[lpsm.size()][3];
                i = 0;
                for (Map.Entry e : lpsm.entrySet()) {
                    t[i][0] = (String)e.getKey();
                    Object currCandidateValue = ((ParameterSpace)e.getValue()).getValue(paramSpaceValues);
                    t[i][1] = ObjectUtils.valueToString((Object)currCandidateValue);
                    t[i][2] = ((ParameterSpace)e.getValue()).toString();
                    ++i;
                }
                ComponentTable ct3 = new ComponentTable.Builder(STYLE_TABLE3_25_25_50).content(t).header(hSpaceTableHeader).build();
                title = "Layer Space: " + ls.getClass().getSimpleName() + ", Name: " + l.getLayerName();
                components.add(DIV_SPACER_20PX);
                components.add(new ComponentText.Builder(title, this.STYLE_TEXT_SZ12).build());
                components.add(ct3);
            }
        }
        int[] iters = mip.getIter();
        float[] scores = mip.getScoreVsIter();
        if (iters != null) {
            double[] si = new double[iters.length];
            double[] scoresD = new double[iters.length];
            double minScore = Double.MAX_VALUE;
            double maxScore = -1.7976931348623157E308;
            for (int i = 0; i < iters.length; ++i) {
                si[i] = iters[i];
                scoresD[i] = scores[i];
                minScore = Math.min(minScore, scoresD[i]);
                maxScore = Math.max(maxScore, scoresD[i]);
            }
            double[] chartMinMax = UIUtils.graphNiceRange(maxScore, minScore, 5);
            ChartLine cl = ((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder("Model Score vs. Iteration", STYLE_CHART_800_400).addSeries("Score", si, scoresD).setYMin(Double.valueOf(chartMinMax[0]))).setYMax(Double.valueOf(chartMinMax[1]))).build();
            components.add(DIV_SPACER_60PX);
            components.add(cl);
        }
        if ((modelJson = mip.getModelConfigJson()) != null) {
            components.add(DIV_SPACER_60PX);
            components.add(new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, new Component[]{new ComponentText("Model Configuration", this.STYLE_TEXT_SZ12)}));
            ComponentText jsonText = new ComponentText(modelJson, this.STYLE_TEXT_SZ10_WHITESPACE_PRE);
            ComponentDiv cd = new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, new Component[]{jsonText});
            components.add(cd);
        }
        if (mip.getExceptionStackTrace() != null) {
            components.add(DIV_SPACER_60PX);
            components.add(new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, new Component[]{new ComponentText("Model Exception - Stack Trace", this.STYLE_TEXT_SZ12)}));
            ComponentText exText = new ComponentText(mip.getExceptionStackTrace(), this.STYLE_TEXT_SZ10_WHITESPACE_PRE);
            ComponentDiv cd = new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, new Component[]{exText});
            components.add(cd);
        }
        ComponentDiv cd = new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, components);
        return Results.ok((String)JsonMapper.asJson(cd)).as(JSON);
    }

    private Result getOptimizationConfig() {
        StatsStorage ss = this.knownSessionIDs.get(this.currentSessionID);
        if (ss == null) {
            log.warn("getOptimizationConfig(): Session ID is unknown: {}", (Object)this.currentSessionID);
            return Results.ok();
        }
        Persistable p = ss.getStaticInfo(this.currentSessionID, ARBITER_UI_TYPE_ID, "global");
        if (p == null) {
            log.info("No static info");
            return Results.ok();
        }
        ArrayList<Object> components = new ArrayList<Object>();
        GlobalConfigPersistable gcp = (GlobalConfigPersistable)p;
        OptimizationConfiguration oc = gcp.getOptimizationConfiguration();
        String[] tableHeader = new String[]{"Configuration", "Value"};
        String[][] table = new String[][]{{"Candidate Generator", oc.getCandidateGenerator().getClass().getSimpleName()}, {"Data Provider", oc.getDataProvider().toString()}, {"Score Function", oc.getScoreFunction().toString()}, {"Result Saver", oc.getResultSaver().toString()}};
        ComponentTable ct = new ComponentTable.Builder(STYLE_TABLE).content(table).header(tableHeader).build();
        components.add(ct);
        String title = "Global Network Configuration";
        components.add(DIV_SPACER_20PX);
        components.add(new ComponentText.Builder(title, this.STYLE_TEXT_SZ12).build());
        BaseNetworkSpace ps = (BaseNetworkSpace)oc.getCandidateGenerator().getParameterSpace();
        Map m = ps.getNestedSpaces();
        String[][] hSpaceTable = new String[m.size()][2];
        int i = 0;
        for (Map.Entry e : m.entrySet()) {
            hSpaceTable[i][0] = (String)e.getKey();
            hSpaceTable[i][1] = ((ParameterSpace)e.getValue()).toString();
            ++i;
        }
        components.add(DIV_SPACER_20PX);
        String[] hSpaceTableHeader = new String[]{"Hyperparameter", "Hyperparameter Configuration"};
        ComponentTable ct2 = new ComponentTable.Builder(STYLE_TABLE).content(hSpaceTable).header(hSpaceTableHeader).build();
        components.add(ct2);
        List layerConfs = ps.getLayerSpaces();
        for (BaseNetworkSpace.LayerConf l : layerConfs) {
            LayerSpace ls = l.getLayerSpace();
            Map lpsm = ls.getNestedSpaces();
            String[][] t = new String[lpsm.size()][2];
            i = 0;
            for (Map.Entry e : lpsm.entrySet()) {
                t[i][0] = (String)e.getKey();
                t[i][1] = ((ParameterSpace)e.getValue()).toString();
                ++i;
            }
            ComponentTable ct3 = new ComponentTable.Builder(STYLE_TABLE).content(t).header(hSpaceTableHeader).build();
            title = "Layer Space: " + ls.getClass().getSimpleName() + ", Name: " + l.getLayerName();
            components.add(DIV_SPACER_20PX);
            components.add(new ComponentText.Builder(title, this.STYLE_TEXT_SZ12).build());
            components.add(ct3);
        }
        ComponentDiv cd = new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, components);
        return Results.ok((String)JsonMapper.asJson(cd)).as(JSON);
    }

    private Result getSummaryResults() {
        StatsStorage ss = this.knownSessionIDs.get(this.currentSessionID);
        if (ss == null) {
            log.warn("getSummaryResults(): Session ID is unknown: {}", (Object)this.currentSessionID);
            return Results.ok();
        }
        ArrayList allModelInfoTemp = new ArrayList(ss.getLatestUpdateAllWorkers(this.currentSessionID, ARBITER_UI_TYPE_ID));
        ArrayList<String[]> table = new ArrayList<String[]>();
        for (Persistable per : allModelInfoTemp) {
            ModelInfoPersistable mip = (ModelInfoPersistable)per;
            String score = mip.getScore() == null ? "" : mip.getScore().toString();
            table.add(new String[]{mip.getModelIdx().toString(), score, mip.getStatus().toString()});
        }
        return Results.ok((String)JsonMapper.asJson(table)).as(JSON);
    }

    private Result getSummaryStatus() {
        StatsStorage ss = this.knownSessionIDs.get(this.currentSessionID);
        if (ss == null) {
            log.warn("getOptimizationConfig(): Session ID is unknown: {}", (Object)this.currentSessionID);
            return Results.ok();
        }
        Persistable p = ss.getStaticInfo(this.currentSessionID, ARBITER_UI_TYPE_ID, "global");
        if (p == null) {
            log.info("No static info");
            return Results.ok();
        }
        GlobalConfigPersistable gcp = (GlobalConfigPersistable)p;
        OptimizationConfiguration oc = gcp.getOptimizationConfiguration();
        long execStartTime = oc.getExecutionStartTime();
        ArrayList allModelInfoTemp = new ArrayList(ss.getLatestUpdateAllWorkers(this.currentSessionID, ARBITER_UI_TYPE_ID));
        ArrayList<ModelInfoPersistable> allModelInfo = new ArrayList<ModelInfoPersistable>();
        for (Persistable per : allModelInfoTemp) {
            ModelInfoPersistable mip = (ModelInfoPersistable)per;
            if (mip.getStatus() != CandidateStatus.Complete || mip.getScore() == null || !Double.isFinite(mip.getScore())) continue;
            allModelInfo.add(mip);
        }
        allModelInfo.sort(Comparator.comparingLong(Persistable::getTimeStamp));
        Pair<List<Component>, ModelInfoPersistable> chartsAndBest = this.getSummaryChartsAndBest(allModelInfo, oc.getScoreFunction().minimize(), execStartTime);
        ArrayList<Object> components = new ArrayList<Object>();
        List tcs = oc.getTerminationConditions();
        Double bestScore = null;
        String bestModelString = null;
        if (chartsAndBest.getSecond() != null) {
            long bestTime = ((ModelInfoPersistable)chartsAndBest.getSecond()).getTimeStamp();
            bestScore = ((ModelInfoPersistable)chartsAndBest.getSecond()).getScore();
            String sinceBest = UIUtils.formatDuration(System.currentTimeMillis() - bestTime);
            bestModelString = "Model " + ((ModelInfoPersistable)chartsAndBest.getSecond()).getModelIdx() + ", Found at " + TIME_FORMATTER.print(bestTime) + " (" + sinceBest + " ago)";
        }
        String execStartTimeStr = "";
        String execTotalRuntimeStr = "";
        if (execStartTime > 0L) {
            execStartTimeStr = TIME_FORMATTER.print(execStartTime);
            execTotalRuntimeStr = UIUtils.formatDuration(System.currentTimeMillis() - execStartTime);
        }
        String[][] table = new String[][]{{"Models Completed", String.valueOf(gcp.getCandidatesCompleted())}, {"Models Queued/Running", String.valueOf(gcp.getCandidatesQueued())}, {"Models Failed", String.valueOf(gcp.getCandidatesFailed())}, {"Models Total", String.valueOf(gcp.getCandidatesTotal())}, {"Best Score", bestScore != null ? String.valueOf(bestScore) : ""}, {"Best Scoring Model", bestModelString != null ? bestModelString : ""}, {"Optimization Runner", gcp.getOptimizationRunner()}, {"Execution Start Time", execStartTimeStr}, {"Total Runtime", execTotalRuntimeStr}};
        ComponentTable ct = new ComponentTable.Builder(STYLE_TABLE).content(table).header(new String[]{"Status", ""}).build();
        components.add(ct);
        String[][] tcTable = new String[tcs.size()][2];
        for (int i = 0; i < tcs.size(); ++i) {
            tcTable[i][0] = "Termination Condition " + i;
            tcTable[i][1] = ((TerminationCondition)tcs.get(i)).toString();
        }
        components.add(DIV_SPACER_20PX);
        ComponentTable ct2 = new ComponentTable.Builder(STYLE_TABLE).content(tcTable).header(new String[]{"Termination Condition", ""}).build();
        components.add(ct2);
        components.addAll((Collection)chartsAndBest.getFirst());
        ComponentDiv cd = new ComponentDiv((Style)STYLE_DIV_WIDTH_100_PC, components);
        return Results.ok((String)JsonMapper.asJson(cd)).as(JSON);
    }

    private Pair<List<Component>, ModelInfoPersistable> getSummaryChartsAndBest(List<ModelInfoPersistable> allModelInfo, boolean minimize, long execStartTime) {
        ArrayList<Double> bestX = new ArrayList<Double>();
        ArrayList<Double> bestY = new ArrayList<Double>();
        double[] allX = new double[allModelInfo.size()];
        double[] allY = new double[allModelInfo.size()];
        double bestScore = minimize ? Double.MAX_VALUE : -1.7976931348623157E308;
        double worstScore = minimize ? -1.7976931348623157E308 : Double.MAX_VALUE;
        double lastTime = -1.0;
        ModelInfoPersistable bestModel = null;
        for (int i = 0; i < allModelInfo.size(); ++i) {
            double t;
            ModelInfoPersistable mip = allModelInfo.get(i);
            double currScore = mip.getScore();
            allX[i] = t = (double)(mip.getTimeStamp() - execStartTime) / 60000.0;
            allY[i] = currScore;
            if (i == 0) {
                bestX.add(t);
                bestY.add(currScore);
                bestScore = currScore;
                bestModel = mip;
            } else if (!minimize && currScore > bestScore || minimize && currScore < bestScore) {
                bestX.add(t);
                bestY.add(bestScore);
                bestX.add(t);
                bestY.add(currScore);
                bestScore = currScore;
                bestModel = mip;
            }
            if (!minimize && currScore < worstScore || minimize && currScore > worstScore) {
                worstScore = currScore;
            }
            if (!(t > lastTime)) continue;
            lastTime = t;
        }
        double[] scatterGraphMinMax = UIUtils.graphNiceRange(Math.max(bestScore, worstScore), Math.min(bestScore, worstScore), 5);
        double[] lineGraphMinMax = UIUtils.graphNiceRange(bestY.stream().mapToDouble(s -> s).max().orElse(0.0), bestY.stream().mapToDouble(s -> s).min().orElse(0.0), 5);
        if (bestX.size() > 0) {
            bestX.add(lastTime);
            bestY.add((Double)bestY.get(bestY.size() - 1));
        }
        double[] bestXd = new double[bestX.size()];
        double[] bestYd = new double[bestXd.length];
        for (int i = 0; i < bestX.size(); ++i) {
            bestXd[i] = (Double)bestX.get(i);
            bestYd[i] = (Double)bestY.get(i);
        }
        ArrayList<Object> components = new ArrayList<Object>(2);
        ChartLine cl = ((ChartLine.Builder)((ChartLine.Builder)new ChartLine.Builder("Best Model Score vs. Time (Minutes)", STYLE_CHART_560_320).addSeries("Best Score vs. Time", bestXd, bestYd).setYMin(Double.valueOf(lineGraphMinMax[0]))).setYMax(Double.valueOf(lineGraphMinMax[1]))).build();
        components.add(cl);
        ChartScatter cs = ((ChartScatter.Builder)((ChartScatter.Builder)new ChartScatter.Builder("All Candidate Scores vs. Time (Minutes)", STYLE_CHART_560_320).addSeries("Candidates", allX, allY).setYMin(Double.valueOf(scatterGraphMinMax[0]))).setYMax(Double.valueOf(scatterGraphMinMax[1]))).build();
        components.add(cs);
        return new Pair(components, (Object)bestModel);
    }
}

