/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.SentencePreProcessor;

public class MutipleEpochsSentenceIterator
implements SentenceIterator {
    private SentenceIterator iterator;
    private int numEpochs;
    private AtomicInteger counter = new AtomicInteger(0);

    public MutipleEpochsSentenceIterator(@NonNull SentenceIterator iterator, int numEpochs) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.numEpochs = numEpochs;
        this.iterator = iterator;
        this.iterator.reset();
    }

    @Override
    public String nextSentence() {
        return this.iterator.nextSentence();
    }

    @Override
    public boolean hasNext() {
        if (!this.iterator.hasNext()) {
            if (this.counter.get() < this.numEpochs - 1) {
                this.counter.incrementAndGet();
                this.iterator.reset();
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void reset() {
        this.counter.set(0);
        this.iterator.reset();
    }

    @Override
    public void finish() {
    }

    @Override
    public SentencePreProcessor getPreProcessor() {
        return this.iterator.getPreProcessor();
    }

    @Override
    public void setPreProcessor(SentencePreProcessor preProcessor) {
        this.iterator.setPreProcessor(preProcessor);
    }
}

