/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.embeddings.learning.impl.sequence;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.SequenceLearningAlgorithm;
import org.deeplearning4j.models.embeddings.learning.impl.elements.SkipGram;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBOW<T extends SequenceElement>
implements SequenceLearningAlgorithm<T> {
    protected VocabCache<T> vocabCache;
    protected WeightLookupTable<T> lookupTable;
    protected VectorsConfiguration configuration;
    protected int window;
    protected boolean useAdaGrad;
    protected double negative;
    protected SkipGram<T> skipGram = new SkipGram();
    private static final Logger log = LoggerFactory.getLogger(DBOW.class);

    @Override
    public ElementsLearningAlgorithm<T> getElementsLearningAlgorithm() {
        return this.skipGram;
    }

    @Override
    public String getCodeName() {
        return "PV-DBOW";
    }

    @Override
    public void configure(@NonNull VocabCache<T> vocabCache, @NonNull WeightLookupTable<T> lookupTable, @NonNull VectorsConfiguration configuration) {
        if (vocabCache == null) {
            throw new NullPointerException("vocabCache");
        }
        if (lookupTable == null) {
            throw new NullPointerException("lookupTable");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.vocabCache = vocabCache;
        this.lookupTable = lookupTable;
        this.window = configuration.getWindow();
        this.useAdaGrad = configuration.isUseAdaGrad();
        this.negative = configuration.getNegative();
        this.configuration = configuration;
        this.skipGram.configure(vocabCache, lookupTable, configuration);
    }

    @Override
    public void pretrain(SequenceIterator<T> iterator) {
    }

    @Override
    public double learnSequence(@NonNull Sequence<T> sequence, @NonNull AtomicLong nextRandom, double learningRate) {
        if (sequence == null) {
            throw new NullPointerException("sequence");
        }
        if (nextRandom == null) {
            throw new NullPointerException("nextRandom");
        }
        this.dbow(0, sequence, (int)nextRandom.get() % this.window, nextRandom, learningRate, false, null);
        return 0.0;
    }

    @Override
    public boolean isEarlyTerminationHit() {
        return false;
    }

    protected void dbow(int i, Sequence<T> sequence, int b, AtomicLong nextRandom, double alpha, boolean isInference, INDArray inferenceVector) {
        List<T> sentence = this.skipGram.applySubsampling(sequence, nextRandom).getElements();
        if (sequence.getSequenceLabel() == null) {
            return;
        }
        ArrayList<T> labels = new ArrayList<T>();
        labels.addAll(sequence.getSequenceLabels());
        if (sentence.isEmpty() || labels.isEmpty()) {
            return;
        }
        for (SequenceElement lastWord : labels) {
            for (SequenceElement word : sentence) {
                if (word == null) continue;
                this.skipGram.iterateSample(word, lastWord, nextRandom, alpha, isInference, inferenceVector);
            }
        }
        if (this.skipGram != null && this.skipGram.getBatch() != null && this.skipGram.getBatch() != null && this.skipGram.getBatch().size() >= this.configuration.getBatchSize()) {
            Nd4j.getExecutioner().exec(this.skipGram.getBatch());
            this.skipGram.getBatch().clear();
        }
    }

    @Override
    public INDArray inferSequence(Sequence<T> sequence, long nextRandom, double learningRate, double minLearningRate, int iterations) {
        AtomicLong nr = new AtomicLong(nextRandom);
        if (sequence.isEmpty()) {
            return null;
        }
        Random random = Nd4j.getRandomFactory().getNewRandomInstance(this.configuration.getSeed() * (long)sequence.hashCode(), (long)(this.lookupTable.layerSize() + 1));
        INDArray ret = Nd4j.rand((int[])new int[]{1, this.lookupTable.layerSize()}, (Random)random).subi((Number)0.5).divi((Number)this.lookupTable.layerSize());
        for (int iter = 0; iter < iterations; ++iter) {
            nr.set(Math.abs(nr.get() * 25214903917L + 11L));
            this.dbow(0, sequence, (int)nr.get() % this.window, nr, learningRate, true, ret);
            learningRate = (learningRate - minLearningRate) / (double)(iterations - iter) + minLearningRate;
        }
        this.finish();
        return ret;
    }

    @Override
    public void finish() {
        if (this.skipGram != null && this.skipGram.getBatch() != null && this.skipGram.getBatch().size() > 0) {
            Nd4j.getExecutioner().exec(this.skipGram.getBatch());
            this.skipGram.getBatch().clear();
        }
    }
}

