/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.word2vec;

import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.models.embeddings.WeightLookupTable;
import org.deeplearning4j.models.embeddings.learning.ElementsLearningAlgorithm;
import org.deeplearning4j.models.embeddings.loader.VectorsConfiguration;
import org.deeplearning4j.models.embeddings.reader.ModelUtils;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.sequencevectors.SequenceVectors;
import org.deeplearning4j.models.sequencevectors.interfaces.SequenceIterator;
import org.deeplearning4j.models.sequencevectors.interfaces.VectorsListener;
import org.deeplearning4j.models.sequencevectors.iterators.AbstractSequenceIterator;
import org.deeplearning4j.models.sequencevectors.transformers.impl.SentenceTransformer;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.invertedindex.InvertedIndex;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.StreamLineIterator;
import org.deeplearning4j.text.tokenization.tokenizerfactory.DefaultTokenizerFactory;
import org.deeplearning4j.text.tokenization.tokenizerfactory.TokenizerFactory;

public class Word2Vec
extends SequenceVectors<VocabWord> {
    private static final long serialVersionUID = 78249242142L;
    protected transient SentenceIterator sentenceIter;
    protected transient TokenizerFactory tokenizerFactory;

    public void setTokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
        if (tokenizerFactory == null) {
            throw new NullPointerException("tokenizerFactory");
        }
        this.tokenizerFactory = tokenizerFactory;
        if (this.sentenceIter != null) {
            SentenceTransformer transformer = new SentenceTransformer.Builder().iterator(this.sentenceIter).tokenizerFactory(this.tokenizerFactory).build();
            this.iterator = new AbstractSequenceIterator.Builder<VocabWord>(transformer).build();
        }
    }

    public void setSentenceIterator(@NonNull SentenceIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (this.tokenizerFactory != null) {
            SentenceTransformer transformer = new SentenceTransformer.Builder().iterator(iterator).tokenizerFactory(this.tokenizerFactory).allowMultithreading(this.configuration == null || this.configuration.isAllowParallelTokenization()).build();
            this.iterator = new AbstractSequenceIterator.Builder<VocabWord>(transformer).build();
        } else {
            log.error("Please call setTokenizerFactory() prior to setSentenceIter() call.");
        }
    }

    public void setSequenceIterator(@NonNull SequenceIterator<VocabWord> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        this.iterator = iterator;
    }

    public TokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    static /* synthetic */ int[] access$1802(Word2Vec x0, int[] x1) {
        x0.variableWindows = x1;
        return x1;
    }

    public static class Builder
    extends SequenceVectors.Builder<VocabWord> {
        protected SentenceIterator sentenceIterator;
        protected LabelAwareIterator labelAwareIterator;
        protected TokenizerFactory tokenizerFactory;
        protected boolean allowParallelTokenization = true;

        public Builder() {
        }

        protected Builder useExistingWordVectors(@NonNull WordVectors vec) {
            if (vec == null) {
                throw new NullPointerException("vec");
            }
            return this;
        }

        public Builder(@NonNull VectorsConfiguration configuration) {
            super(configuration);
            if (configuration == null) {
                throw new NullPointerException("configuration");
            }
            this.allowParallelTokenization = configuration.isAllowParallelTokenization();
        }

        public Builder iterate(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.sentenceIterator = new StreamLineIterator.Builder(iterator).setFetchSize(100).build();
            return this;
        }

        public Builder iterate(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.sentenceIterator = iterator;
            return this;
        }

        public Builder tokenizerFactory(@NonNull TokenizerFactory tokenizerFactory) {
            if (tokenizerFactory == null) {
                throw new NullPointerException("tokenizerFactory");
            }
            this.tokenizerFactory = tokenizerFactory;
            return this;
        }

        @Deprecated
        public Builder index(@NonNull InvertedIndex<VocabWord> index) {
            if (index == null) {
                throw new NullPointerException("index");
            }
            return this;
        }

        public Builder iterate(@NonNull SequenceIterator<VocabWord> iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            super.iterate(iterator);
            return this;
        }

        public Builder iterate(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator");
            }
            this.labelAwareIterator = iterator;
            return this;
        }

        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder iterations(int iterations) {
            super.iterations(iterations);
            return this;
        }

        public Builder epochs(int numEpochs) {
            super.epochs(numEpochs);
            return this;
        }

        public Builder layerSize(int layerSize) {
            super.layerSize(layerSize);
            return this;
        }

        public Builder learningRate(double learningRate) {
            super.learningRate(learningRate);
            return this;
        }

        public Builder minWordFrequency(int minWordFrequency) {
            super.minWordFrequency(minWordFrequency);
            return this;
        }

        public Builder minLearningRate(double minLearningRate) {
            super.minLearningRate(minLearningRate);
            return this;
        }

        public Builder resetModel(boolean reallyReset) {
            super.resetModel(reallyReset);
            return this;
        }

        public Builder vocabCache(@NonNull VocabCache<VocabWord> vocabCache) {
            if (vocabCache == null) {
                throw new NullPointerException("vocabCache");
            }
            super.vocabCache(vocabCache);
            return this;
        }

        public Builder lookupTable(@NonNull WeightLookupTable<VocabWord> lookupTable) {
            if (lookupTable == null) {
                throw new NullPointerException("lookupTable");
            }
            super.lookupTable(lookupTable);
            return this;
        }

        public Builder sampling(double sampling) {
            super.sampling(sampling);
            return this;
        }

        public Builder useAdaGrad(boolean reallyUse) {
            super.useAdaGrad(reallyUse);
            return this;
        }

        public Builder negativeSample(double negative) {
            super.negativeSample(negative);
            return this;
        }

        public Builder stopWords(@NonNull List<String> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            super.stopWords(stopList);
            return this;
        }

        public Builder trainElementsRepresentation(boolean trainElements) {
            throw new IllegalStateException("You can't change this option for Word2Vec");
        }

        public Builder trainSequencesRepresentation(boolean trainSequences) {
            throw new IllegalStateException("You can't change this option for Word2Vec");
        }

        public Builder stopWords(@NonNull Collection<VocabWord> stopList) {
            if (stopList == null) {
                throw new NullPointerException("stopList");
            }
            super.stopWords(stopList);
            return this;
        }

        public Builder windowSize(int windowSize) {
            super.windowSize(windowSize);
            return this;
        }

        public Builder seed(long randomSeed) {
            super.seed(randomSeed);
            return this;
        }

        public Builder workers(int numWorkers) {
            super.workers(numWorkers);
            return this;
        }

        public Builder modelUtils(@NonNull ModelUtils<VocabWord> modelUtils) {
            if (modelUtils == null) {
                throw new NullPointerException("modelUtils");
            }
            super.modelUtils(modelUtils);
            return this;
        }

        public Builder useVariableWindow(int ... windows) {
            super.useVariableWindow(windows);
            return this;
        }

        public Builder unknownElement(VocabWord element) {
            super.unknownElement(element);
            return this;
        }

        public Builder useUnknown(boolean reallyUse) {
            super.useUnknown(reallyUse);
            if (this.unknownElement == null) {
                this.unknownElement(new VocabWord(1.0, "UNK"));
            }
            return this;
        }

        public Builder setVectorsListeners(@NonNull Collection<VectorsListener<VocabWord>> vectorsListeners) {
            if (vectorsListeners == null) {
                throw new NullPointerException("vectorsListeners");
            }
            super.setVectorsListeners(vectorsListeners);
            return this;
        }

        public Builder elementsLearningAlgorithm(@NonNull String algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm");
            }
            super.elementsLearningAlgorithm(algorithm);
            return this;
        }

        public Builder elementsLearningAlgorithm(@NonNull ElementsLearningAlgorithm<VocabWord> algorithm) {
            if (algorithm == null) {
                throw new NullPointerException("algorithm");
            }
            super.elementsLearningAlgorithm(algorithm);
            return this;
        }

        public Builder allowParallelTokenization(boolean allow) {
            this.allowParallelTokenization = allow;
            return this;
        }

        public Builder enableScavenger(boolean reallyEnable) {
            super.enableScavenger(reallyEnable);
            return this;
        }

        public Builder useHierarchicSoftmax(boolean reallyUse) {
            super.useHierarchicSoftmax(reallyUse);
            return this;
        }

        public Builder usePreciseWeightInit(boolean reallyUse) {
            super.usePreciseWeightInit(reallyUse);
            return this;
        }

        public Word2Vec build() {
            SentenceTransformer transformer;
            this.presetTables();
            Word2Vec ret = new Word2Vec();
            if (this.sentenceIterator != null) {
                if (this.tokenizerFactory == null) {
                    this.tokenizerFactory = new DefaultTokenizerFactory();
                }
                transformer = new SentenceTransformer.Builder().iterator(this.sentenceIterator).tokenizerFactory(this.tokenizerFactory).allowMultithreading(this.allowParallelTokenization).build();
                this.iterator = new AbstractSequenceIterator.Builder<VocabWord>(transformer).build();
            }
            if (this.labelAwareIterator != null) {
                if (this.tokenizerFactory == null) {
                    this.tokenizerFactory = new DefaultTokenizerFactory();
                }
                transformer = new SentenceTransformer.Builder().iterator(this.labelAwareIterator).tokenizerFactory(this.tokenizerFactory).allowMultithreading(this.allowParallelTokenization).build();
                this.iterator = new AbstractSequenceIterator.Builder<VocabWord>(transformer).build();
            }
            ret.numEpochs = this.numEpochs;
            ret.numIterations = this.iterations;
            ret.vocab = this.vocabCache;
            ret.minWordFrequency = this.minWordFrequency;
            ret.learningRate.set(this.learningRate);
            ret.minLearningRate = this.minLearningRate;
            ret.sampling = this.sampling;
            ret.negative = this.negative;
            ret.layerSize = this.layerSize;
            ret.batchSize = this.batchSize;
            ret.learningRateDecayWords = this.learningRateDecayWords;
            ret.window = this.window;
            ret.resetModel = this.resetModel;
            ret.useAdeGrad = this.useAdaGrad;
            ret.stopWords = this.stopWords;
            ret.workers = this.workers;
            ret.useUnknown = this.useUnknown;
            ret.unknownElement = this.unknownElement;
            Word2Vec.access$1802(ret, this.variableWindows);
            ret.seed = this.seed;
            ret.enableScavenger = this.enableScavenger;
            ret.iterator = this.iterator;
            ret.lookupTable = this.lookupTable;
            ret.tokenizerFactory = this.tokenizerFactory;
            ret.modelUtils = this.modelUtils;
            ret.elementsLearningAlgorithm = this.elementsLearningAlgorithm;
            ret.sequenceLearningAlgorithm = this.sequenceLearningAlgorithm;
            this.configuration.setLearningRate(this.learningRate);
            this.configuration.setLayersSize(this.layerSize);
            this.configuration.setHugeModelExpected(this.hugeModelExpected);
            this.configuration.setWindow(this.window);
            this.configuration.setMinWordFrequency(this.minWordFrequency);
            this.configuration.setIterations(this.iterations);
            this.configuration.setSeed(this.seed);
            this.configuration.setBatchSize(this.batchSize);
            this.configuration.setLearningRateDecayWords(this.learningRateDecayWords);
            this.configuration.setMinLearningRate(this.minLearningRate);
            this.configuration.setSampling(this.sampling);
            this.configuration.setUseAdaGrad(this.useAdaGrad);
            this.configuration.setNegative(this.negative);
            this.configuration.setEpochs(this.numEpochs);
            this.configuration.setStopList(this.stopWords);
            this.configuration.setVariableWindows(this.variableWindows);
            this.configuration.setUseHierarchicSoftmax(this.useHierarchicSoftmax);
            this.configuration.setPreciseWeightInit(this.preciseWeightInit);
            this.configuration.setModelUtils(this.modelUtils.getClass().getCanonicalName());
            this.configuration.setAllowParallelTokenization(this.allowParallelTokenization);
            if (this.tokenizerFactory != null) {
                this.configuration.setTokenizerFactory(this.tokenizerFactory.getClass().getCanonicalName());
                if (this.tokenizerFactory.getTokenPreProcessor() != null) {
                    this.configuration.setTokenPreProcessor(this.tokenizerFactory.getTokenPreProcessor().getClass().getCanonicalName());
                }
            }
            ret.configuration = this.configuration;
            ret.trainSequenceVectors = false;
            ret.trainElementsVectors = true;
            ret.eventListeners = this.vectorsListeners;
            return ret;
        }
    }
}

