/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.termination;

import org.deeplearning4j.earlystopping.termination.EpochTerminationCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreImprovementEpochTerminationCondition
implements EpochTerminationCondition {
    private static Logger log = LoggerFactory.getLogger(ScoreImprovementEpochTerminationCondition.class);
    private int maxEpochsWithNoImprovement;
    private int bestEpoch = -1;
    private double bestScore;
    private double minImprovement = 0.0;

    public ScoreImprovementEpochTerminationCondition(int maxEpochsWithNoImprovement) {
        this.maxEpochsWithNoImprovement = maxEpochsWithNoImprovement;
    }

    public ScoreImprovementEpochTerminationCondition(int maxEpochsWithNoImprovement, double minImprovement) {
        this.maxEpochsWithNoImprovement = maxEpochsWithNoImprovement;
        this.minImprovement = minImprovement;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean terminate(int epochNum, double score) {
        if (this.bestEpoch == -1) {
            this.bestEpoch = epochNum;
            this.bestScore = score;
            return false;
        }
        double improvement = this.bestScore - score;
        if (improvement > this.minImprovement) {
            if (this.minImprovement > 0.0) {
                log.info("Epoch with score greater than threshold * * *");
            }
            this.bestScore = score;
            this.bestEpoch = epochNum;
            return false;
        }
        return epochNum >= this.bestEpoch + this.maxEpochsWithNoImprovement;
    }

    public String toString() {
        return "ScoreImprovementEpochTerminationCondition(maxEpochsWithNoImprovement=" + this.maxEpochsWithNoImprovement + ", minImprovement=" + this.minImprovement + ")";
    }
}

