/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.deeplearning4j.nn.params.GravesBidirectionalLSTMParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GravesBidirectionalLSTM
extends BaseRecurrentLayer {
    private double forgetGateBiasInit;

    private GravesBidirectionalLSTM(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        org.deeplearning4j.nn.layers.recurrent.GravesBidirectionalLSTM ret = new org.deeplearning4j.nn.layers.recurrent.GravesBidirectionalLSTM(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return GravesBidirectionalLSTMParamInitializer.getInstance();
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "WF": 
            case "RWF": 
            case "WB": 
            case "RWB": {
                return this.l1;
            }
            case "bF": 
            case "bB": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "WF": 
            case "RWF": 
            case "WB": 
            case "RWB": {
                return this.l2;
            }
            case "bF": 
            case "bB": {
                return 0.0;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "WF": 
            case "RWF": 
            case "WB": 
            case "RWB": {
                return this.learningRate;
            }
            case "bF": 
            case "bB": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public double getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public void setForgetGateBiasInit(double forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    public GravesBidirectionalLSTM() {
    }

    @Override
    public String toString() {
        return "GravesBidirectionalLSTM(super=" + super.toString() + ", forgetGateBiasInit=" + this.getForgetGateBiasInit() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GravesBidirectionalLSTM)) {
            return false;
        }
        GravesBidirectionalLSTM other = (GravesBidirectionalLSTM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Double.compare(this.getForgetGateBiasInit(), other.getForgetGateBiasInit()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GravesBidirectionalLSTM;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $forgetGateBiasInit = Double.doubleToLongBits(this.getForgetGateBiasInit());
        result = result * 59 + (int)($forgetGateBiasInit >>> 32 ^ $forgetGateBiasInit);
        return result;
    }

    public static class Builder
    extends BaseRecurrentLayer.Builder<Builder> {
        private double forgetGateBiasInit = 1.0;

        public Builder forgetGateBiasInit(double biasInit) {
            this.forgetGateBiasInit = biasInit;
            return this;
        }

        @Override
        public GravesBidirectionalLSTM build() {
            return new GravesBidirectionalLSTM(this);
        }

        @ConstructorProperties(value={"forgetGateBiasInit"})
        public Builder(double forgetGateBiasInit) {
            this.forgetGateBiasInit = forgetGateBiasInit;
        }

        public Builder() {
        }
    }
}

