/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.preprocessor.CnnToRnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToCnnPreProcessor;
import org.deeplearning4j.nn.conf.preprocessor.FeedForwardToRnnPreProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputTypeUtil {
    private static final Logger log = LoggerFactory.getLogger(InputTypeUtil.class);

    public static InputType getOutputTypeCnnLayers(InputType inputType, int[] kernelSize, int[] stride, int[] padding, int outputDepth, String layerName) {
        InputType.InputTypeConvolutional i = (InputType.InputTypeConvolutional)inputType;
        int inHeight = i.getHeight();
        int inWidth = i.getWidth();
        int padH = padding[0];
        int padW = padding[1];
        int kH = kernelSize[0];
        int kW = kernelSize[1];
        int sH = stride[0];
        int sW = stride[1];
        if (sH <= 0 || sW <= 0) {
            throw new IllegalStateException("Invalid strides for layer \"\" + layerName + \"\": must be > 0 (strideH = " + sH + ", strideW = " + sW + ")");
        }
        if (kH <= 0 || kH > inHeight + 2 * padH) {
            throw new IllegalStateException("Invalid input configuration for layer \"" + layerName + "\" kernel height: require 0 < kH <= inHeight + 2*padH; got (kH=" + kH + ", inHeight=" + inHeight + ", padH=" + padH + ")");
        }
        if (kW <= 0 || kW > inWidth + 2 * padW) {
            throw new IllegalStateException("Invalid input configuration for layer \"\" + layerName + \"\" kernel width: require 0 < kW <= inWidth + 2*padW; got (kW=" + kW + ", inWidth=" + inWidth + ", padW=" + padW + ")");
        }
        if ((inHeight - kH + 2 * padH) % sH != 0) {
            throw new IllegalStateException("Invalid input configuration (layer name = \"" + layerName + "\") for height: inHeight=" + inHeight + ", kernelH=" + kH + ", padH=" + padH + ", strideH=" + sH + "; (" + inHeight + "-" + kH + "+2*" + padH + ")/" + sH + " is not an integer");
        }
        if ((inWidth - kW + 2 * padW) % sW != 0) {
            throw new IllegalStateException("Invalid input configuration (layer name = \"" + layerName + "\") for width: inWidth=" + inWidth + ", kernelW=" + kW + ", padW=" + padW + ", strideW=" + sW + "; (" + inWidth + "-" + kW + "+2*" + padW + ")/" + sW + " is not an integer");
        }
        int hOut = (inHeight - kH + 2 * padH) / sH + 1;
        int wOut = (inWidth - kW + 2 * padW) / sW + 1;
        return InputType.convolutional(hOut, wOut, outputDepth);
    }

    public static InputPreProcessor getPreProcessorForInputTypeCnnLayers(InputType inputType, String layerName) {
        switch (inputType.getType()) {
            case FF: {
                log.info("Automatic addition of FF -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case RNN: {
                log.warn("Automatic addition of RNN -> CNN preprocessors: not yet implemented (layer name: \"" + layerName + "\")");
                return null;
            }
            case CNN: {
                return null;
            }
            case CNNFlat: {
                InputType.InputTypeConvolutionalFlat f = (InputType.InputTypeConvolutionalFlat)inputType;
                return new FeedForwardToCnnPreProcessor(f.getHeight(), f.getWidth(), f.getDepth());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }

    public static InputPreProcessor getPreprocessorForInputTypeRnnLayers(InputType inputType, String layerName) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for RNN layer (layer name = \"" + layerName + "\"): input type is null");
        }
        switch (inputType.getType()) {
            case FF: 
            case CNNFlat: {
                return new FeedForwardToRnnPreProcessor();
            }
            case RNN: {
                return null;
            }
            case CNN: {
                InputType.InputTypeConvolutional c = (InputType.InputTypeConvolutional)inputType;
                return new CnnToRnnPreProcessor(c.getHeight(), c.getWidth(), c.getDepth());
            }
        }
        throw new RuntimeException("Unknown input type: " + inputType);
    }
}

