/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.IterationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScoreIterationListener
implements IterationListener {
    private int printIterations = 10;
    private static final Logger log = LoggerFactory.getLogger(ScoreIterationListener.class);
    private boolean invoked = false;
    private long iterCount = 0L;

    public ScoreIterationListener(int printIterations) {
        this.printIterations = printIterations;
    }

    public ScoreIterationListener() {
    }

    @Override
    public boolean invoked() {
        return this.invoked;
    }

    @Override
    public void invoke() {
        this.invoked = true;
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (this.printIterations <= 0) {
            this.printIterations = 1;
        }
        if (this.iterCount % (long)this.printIterations == 0L) {
            this.invoke();
            double result = model.score();
            log.info("Score at iteration " + this.iterCount + " is " + result);
        }
        ++this.iterCount;
    }
}

