/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.recurrent;

import java.util.Map;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.GravesLSTM;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.recurrent.BaseRecurrentLayer;
import org.deeplearning4j.nn.layers.recurrent.FwdPassReturn;
import org.deeplearning4j.nn.layers.recurrent.LSTMHelpers;
import org.nd4j.linalg.api.ndarray.INDArray;

public class GravesBidirectionalLSTM
extends BaseRecurrentLayer<GravesLSTM> {
    public GravesBidirectionalLSTM(NeuralNetConfiguration conf) {
        super(conf);
    }

    public GravesBidirectionalLSTM(NeuralNetConfiguration conf, INDArray input) {
        super(conf, input);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon) {
        return this.backpropGradientHelper(epsilon, false, -1);
    }

    @Override
    public Pair<Gradient, INDArray> tbpttBackpropGradient(INDArray epsilon, int tbpttBackwardLength) {
        return this.backpropGradientHelper(epsilon, true, tbpttBackwardLength);
    }

    private Pair<Gradient, INDArray> backpropGradientHelper(INDArray epsilon, boolean truncatedBPTT, int tbpttBackwardLength) {
        if (truncatedBPTT) {
            throw new UnsupportedOperationException("you can not time step a bidirectional RNN, it has to run on a batch of data all at once");
        }
        FwdPassReturn fwdPass = this.activateHelperDirectional(true, null, null, true, true);
        Pair<Gradient, INDArray> forwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, this.input, this.getParam("RWF"), this.getParam("WF"), epsilon, truncatedBPTT, tbpttBackwardLength, fwdPass, true, "WF", "RWF", "bF", this.gradientViews);
        FwdPassReturn backPass = this.activateHelperDirectional(true, null, null, true, false);
        Pair<Gradient, INDArray> backwardsGradient = LSTMHelpers.backpropGradientHelper(this.conf, this.input, this.getParam("RWB"), this.getParam("WB"), epsilon, truncatedBPTT, tbpttBackwardLength, backPass, false, "WB", "RWB", "bB", this.gradientViews);
        DefaultGradient combinedGradient = new DefaultGradient();
        for (Map.Entry<String, INDArray> entry : forwardsGradient.getFirst().gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, INDArray> entry : backwardsGradient.getFirst().gradientForVariable().entrySet()) {
            combinedGradient.setGradientFor(entry.getKey(), entry.getValue());
        }
        DefaultGradient correctOrderedGradient = new DefaultGradient();
        for (String key : this.params.keySet()) {
            correctOrderedGradient.setGradientFor(key, combinedGradient.getGradientFor(key));
        }
        INDArray iNDArray = forwardsGradient.getSecond();
        INDArray backwardsEpsilon = backwardsGradient.getSecond();
        INDArray combinedEpsilon = iNDArray.addi(backwardsEpsilon);
        return new Pair<Gradient, INDArray>(correctOrderedGradient, combinedEpsilon);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.activate(x, true);
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        return this.activate(x, training);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.activateOutput(training, false);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activateOutput(true, false);
    }

    @Override
    public INDArray activate(boolean training) {
        return this.activateOutput(training, false);
    }

    @Override
    public INDArray activate() {
        return this.activateOutput(false, false);
    }

    private INDArray activateOutput(boolean training, boolean forBackprop) {
        FwdPassReturn forwardsEval = LSTMHelpers.activateHelper(this, this.conf, this.input, this.getParam("RWF"), this.getParam("WF"), this.getParam("bF"), training, null, null, forBackprop, true, "WF");
        FwdPassReturn backwardsEval = LSTMHelpers.activateHelper(this, this.conf, this.input, this.getParam("RWB"), this.getParam("WB"), this.getParam("bB"), training, null, null, forBackprop, false, "WB");
        INDArray fwdOutput = forwardsEval.fwdPassOutput;
        INDArray backOutput = backwardsEval.fwdPassOutput;
        INDArray totalOutput = fwdOutput.addi(backOutput);
        return totalOutput;
    }

    private FwdPassReturn activateHelperDirectional(boolean training, INDArray prevOutputActivations, INDArray prevMemCellState, boolean forBackprop, boolean forwards) {
        String recurrentKey = "RWF";
        String inputKey = "WF";
        String biasKey = "bF";
        if (!forwards) {
            recurrentKey = "RWB";
            inputKey = "WB";
            biasKey = "bB";
        }
        return LSTMHelpers.activateHelper(this, this.conf, this.input, this.getParam(recurrentKey), this.getParam(inputKey), this.getParam(biasKey), training, prevOutputActivations, prevMemCellState, forBackprop, forwards, inputKey);
    }

    @Override
    public INDArray activationMean() {
        return this.activate();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.RECURRENT;
    }

    @Override
    public Layer transpose() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public double calcL2() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL2() <= 0.0) {
            return 0.0;
        }
        double l2Norm = this.getParam("RWF").norm2Number().doubleValue();
        double sumSquaredWeights = l2Norm * l2Norm;
        l2Norm = this.getParam("WF").norm2Number().doubleValue();
        sumSquaredWeights += l2Norm * l2Norm;
        l2Norm = this.getParam("RWB").norm2Number().doubleValue();
        sumSquaredWeights += l2Norm * l2Norm;
        l2Norm = this.getParam("WB").norm2Number().doubleValue();
        return 0.5 * this.conf.getLayer().getL2() * (sumSquaredWeights += l2Norm * l2Norm);
    }

    @Override
    public double calcL1() {
        if (!this.conf.isUseRegularization() || this.conf.getLayer().getL1() <= 0.0) {
            return 0.0;
        }
        double l1 = this.getParam("RWF").norm1Number().doubleValue() + this.getParam("WF").norm1Number().doubleValue() + this.getParam("RWB").norm1Number().doubleValue() + this.getParam("WB").norm1Number().doubleValue();
        return this.conf.getLayer().getL1() * l1;
    }

    @Override
    public INDArray rnnTimeStep(INDArray input) {
        throw new UnsupportedOperationException("you can not time step a bidirectional RNN, it has to run on a batch of data all at once");
    }

    @Override
    public INDArray rnnActivateUsingStoredState(INDArray input, boolean training, boolean storeLastForTBPTT) {
        throw new UnsupportedOperationException("no such thing as stored state for bidirectional RNN");
    }
}

