/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ListDataSetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -7569201667767185411L;
    private int curr = 0;
    private int batch = 10;
    private List<org.nd4j.linalg.dataset.DataSet> list;
    private DataSetPreProcessor preProcessor;

    public ListDataSetIterator(Collection<org.nd4j.linalg.dataset.DataSet> coll, int batch) {
        this.list = new ArrayList<org.nd4j.linalg.dataset.DataSet>(coll);
        this.batch = batch;
    }

    public ListDataSetIterator(Collection<org.nd4j.linalg.dataset.DataSet> coll) {
        this(coll, 5);
    }

    public synchronized boolean hasNext() {
        return this.curr < this.list.size();
    }

    public synchronized org.nd4j.linalg.dataset.DataSet next() {
        return this.next(this.batch);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int totalExamples() {
        return this.list.size();
    }

    public int inputColumns() {
        return this.list.get(0).getFeatureMatrix().columns();
    }

    public int totalOutcomes() {
        return this.list.get(0).getLabels().columns();
    }

    public boolean resetSupported() {
        return true;
    }

    public boolean asyncSupported() {
        return false;
    }

    public synchronized void reset() {
        this.curr = 0;
    }

    public int batch() {
        return this.batch;
    }

    public synchronized int cursor() {
        return this.curr;
    }

    public int numExamples() {
        return this.list.size();
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return null;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        int end = this.curr + num;
        ArrayList<org.nd4j.linalg.dataset.DataSet> r = new ArrayList<org.nd4j.linalg.dataset.DataSet>();
        if (end >= this.list.size()) {
            end = this.list.size();
        }
        while (this.curr < end) {
            r.add(this.list.get(this.curr));
            ++this.curr;
        }
        org.nd4j.linalg.dataset.DataSet d = org.nd4j.linalg.dataset.DataSet.merge(r);
        if (this.preProcessor != null && !d.isPreProcessed()) {
            this.preProcessor.preProcess((DataSet)d);
            d.markAsPreProcessed();
        }
        return d;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

