/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;

public class SerializationUtils {
    private SerializationUtils() {
    }

    public static <T> T readObject(File file) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(FileUtils.openInputStream((File)file));
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static <T> T readObject(InputStream is) {
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(Serializable toSave) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(toSave);
            byte[] ret = bos.toByteArray();
            os.close();
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeObject(Serializable toSave, OutputStream writeTo) {
        try {
            ObjectOutputStream os = new ObjectOutputStream(writeTo);
            os.writeObject(toSave);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveObject(Object toSave, File saveTo) {
        try {
            FileOutputStream os1 = FileUtils.openOutputStream((File)saveTo);
            ObjectOutputStream os = new ObjectOutputStream(os1);
            os.writeObject(toSave);
            os.flush();
            os.close();
            ((OutputStream)os1).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

