/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.earlystopping.scorecalc;

import org.deeplearning4j.earlystopping.scorecalc.ScoreCalculator;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class DataSetLossCalculator
implements ScoreCalculator<MultiLayerNetwork> {
    private DataSetIterator dataSetIterator;
    @JsonProperty
    private boolean average;

    public DataSetLossCalculator(DataSetIterator dataSetIterator, boolean average) {
        this.dataSetIterator = dataSetIterator;
        this.average = average;
    }

    @Override
    public double calculateScore(MultiLayerNetwork network) {
        DataSet dataSet;
        this.dataSetIterator.reset();
        double lossSum = 0.0;
        int exCount = 0;
        while (this.dataSetIterator.hasNext() && (dataSet = (DataSet)this.dataSetIterator.next()) != null) {
            int nEx = dataSet.getFeatureMatrix().size(0);
            lossSum += network.score(dataSet) * (double)nEx;
            exCount += nEx;
        }
        if (this.average) {
            return lossSum / (double)exCount;
        }
        return lossSum;
    }

    public String toString() {
        return "DataSetLossCalculator(" + this.dataSetIterator + ",average=" + this.average + ")";
    }

    public DataSetLossCalculator() {
    }
}

