/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import java.util.Arrays;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.ndarray.INDArray;

public class ReshapeVertex
extends GraphVertex {
    protected int[] newShape;

    public ReshapeVertex(int ... newShape) {
        this.newShape = newShape;
    }

    @Override
    public ReshapeVertex clone() {
        return new ReshapeVertex(this.newShape);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ReshapeVertex)) {
            return false;
        }
        return Arrays.equals(((ReshapeVertex)o).newShape, this.newShape);
    }

    @Override
    public int hashCode() {
        return this.newShape.hashCode();
    }

    @Override
    public int numParams(boolean backprop) {
        return 0;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams) {
        return new org.deeplearning4j.nn.graph.vertex.impl.ReshapeVertex(graph, name, idx, this.newShape);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        if (first.getType() != InputType.Type.CNN) {
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() == first.getType()) continue;
                throw new InvalidInputTypeException("Invalid input: Reshape vertex cannot process activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
        } else {
            InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
            int fd = firstConv.getDepth();
            int fw = firstConv.getWidth();
            int fh = firstConv.getHeight();
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() != InputType.Type.CNN) {
                    throw new InvalidInputTypeException("Invalid input: Reshape vertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
                int od = otherConv.getDepth();
                int ow = otherConv.getWidth();
                int oh = otherConv.getHeight();
                if (fd == od && fw == ow && fh == oh) continue;
                throw new InvalidInputTypeException("Invalid input: Reshape vertex cannot process CNN activations of different sizes:first [depth,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
        }
        return first;
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, ReshapeVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public int[] getNewShape() {
        return this.newShape;
    }

    public void setNewShape(int[] newShape) {
        this.newShape = newShape;
    }

    public String toString() {
        return "ReshapeVertex(newShape=" + Arrays.toString(this.getNewShape()) + ")";
    }
}

