/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepyTrainingListener
implements TrainingListener {
    private static final Logger log = LoggerFactory.getLogger(SleepyTrainingListener.class);
    protected final transient ThreadLocal<AtomicLong> lastEE = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastES = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastFF = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastBP = new ThreadLocal();
    protected final transient ThreadLocal<AtomicLong> lastIteration = new ThreadLocal();
    protected long timerEE;
    protected long timerES;
    protected long timerFF;
    protected long timerBP;
    protected long timerIteration;
    protected SleepMode sleepMode;
    protected TimeMode timeMode;

    protected void sleep(long sleepTimeMs) {
        if (sleepTimeMs < 1L) {
            return;
        }
        switch (this.sleepMode) {
            case PARK: {
                LockSupport.parkNanos(sleepTimeMs * 1000000L);
                break;
            }
            case BUSY: {
                long target = System.currentTimeMillis() + sleepTimeMs;
                while (System.currentTimeMillis() < target) {
                }
                break;
            }
            case SLEEP: {
                try {
                    Thread.sleep(sleepTimeMs);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw new IllegalStateException("Unknown SleepMode value passed in: " + (Object)((Object)this.sleepMode));
            }
        }
    }

    protected void sleep(AtomicLong lastTime, long sleepTime) {
        if (sleepTime == 0L) {
            return;
        }
        if (this.timeMode == TimeMode.SIMPLE) {
            this.sleep(sleepTime);
            return;
        }
        if (lastTime == null) {
            this.sleep(sleepTime);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long delta = sleepTime - (currentTime - lastTime.get());
        this.sleep(delta);
    }

    @Override
    public void onEpochStart(Model model) {
        this.sleep(this.lastES.get(), this.timerES);
        if (this.lastES.get() == null) {
            this.lastES.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastES.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onEpochEnd(Model model) {
        this.sleep(this.lastEE.get(), this.timerEE);
        if (this.lastEE.get() == null) {
            this.lastEE.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastEE.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onForwardPass(Model model, List<INDArray> activations) {
        this.sleep(this.lastFF.get(), this.timerFF);
        if (this.lastFF.get() == null) {
            this.lastFF.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastFF.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onForwardPass(Model model, Map<String, INDArray> activations) {
        this.sleep(this.lastFF.get(), this.timerFF);
        if (this.lastFF.get() == null) {
            this.lastFF.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastFF.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        this.sleep(this.lastIteration.get(), this.timerIteration);
        if (this.lastIteration.get() == null) {
            this.lastIteration.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastIteration.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public void onBackwardPass(Model model) {
        this.sleep(this.lastBP.get(), this.timerBP);
        if (this.lastBP.get() == null) {
            this.lastBP.set(new AtomicLong(System.currentTimeMillis()));
        } else {
            this.lastBP.get().set(System.currentTimeMillis());
        }
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void onGradientCalculation(Model model) {
    }

    private static long $default$timerEE() {
        return 0L;
    }

    private static long $default$timerES() {
        return 0L;
    }

    private static long $default$timerFF() {
        return 0L;
    }

    private static long $default$timerBP() {
        return 0L;
    }

    private static long $default$timerIteration() {
        return 0L;
    }

    private static SleepMode $default$sleepMode() {
        return SleepMode.PARK;
    }

    private static TimeMode $default$timeMode() {
        return TimeMode.SIMPLE;
    }

    public static SleepyTrainingListenerBuilder builder() {
        return new SleepyTrainingListenerBuilder();
    }

    @ConstructorProperties(value={"timerEE", "timerES", "timerFF", "timerBP", "timerIteration", "sleepMode", "timeMode"})
    public SleepyTrainingListener(long timerEE, long timerES, long timerFF, long timerBP, long timerIteration, SleepMode sleepMode, TimeMode timeMode) {
        this.timerEE = timerEE;
        this.timerES = timerES;
        this.timerFF = timerFF;
        this.timerBP = timerBP;
        this.timerIteration = timerIteration;
        this.sleepMode = sleepMode;
        this.timeMode = timeMode;
    }

    public SleepyTrainingListener() {
    }

    public long getTimerEE() {
        return this.timerEE;
    }

    public long getTimerES() {
        return this.timerES;
    }

    public long getTimerFF() {
        return this.timerFF;
    }

    public long getTimerBP() {
        return this.timerBP;
    }

    public long getTimerIteration() {
        return this.timerIteration;
    }

    public SleepMode getSleepMode() {
        return this.sleepMode;
    }

    public TimeMode getTimeMode() {
        return this.timeMode;
    }

    public void setTimerEE(long timerEE) {
        this.timerEE = timerEE;
    }

    public void setTimerES(long timerES) {
        this.timerES = timerES;
    }

    public void setTimerFF(long timerFF) {
        this.timerFF = timerFF;
    }

    public void setTimerBP(long timerBP) {
        this.timerBP = timerBP;
    }

    public void setTimerIteration(long timerIteration) {
        this.timerIteration = timerIteration;
    }

    public void setSleepMode(SleepMode sleepMode) {
        this.sleepMode = sleepMode;
    }

    public void setTimeMode(TimeMode timeMode) {
        this.timeMode = timeMode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SleepyTrainingListener)) {
            return false;
        }
        SleepyTrainingListener other = (SleepyTrainingListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimerEE() != other.getTimerEE()) {
            return false;
        }
        if (this.getTimerES() != other.getTimerES()) {
            return false;
        }
        if (this.getTimerFF() != other.getTimerFF()) {
            return false;
        }
        if (this.getTimerBP() != other.getTimerBP()) {
            return false;
        }
        if (this.getTimerIteration() != other.getTimerIteration()) {
            return false;
        }
        SleepMode this$sleepMode = this.getSleepMode();
        SleepMode other$sleepMode = other.getSleepMode();
        if (this$sleepMode == null ? other$sleepMode != null : !((Object)((Object)this$sleepMode)).equals((Object)other$sleepMode)) {
            return false;
        }
        TimeMode this$timeMode = this.getTimeMode();
        TimeMode other$timeMode = other.getTimeMode();
        return !(this$timeMode == null ? other$timeMode != null : !((Object)((Object)this$timeMode)).equals((Object)other$timeMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SleepyTrainingListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timerEE = this.getTimerEE();
        result = result * 59 + (int)($timerEE >>> 32 ^ $timerEE);
        long $timerES = this.getTimerES();
        result = result * 59 + (int)($timerES >>> 32 ^ $timerES);
        long $timerFF = this.getTimerFF();
        result = result * 59 + (int)($timerFF >>> 32 ^ $timerFF);
        long $timerBP = this.getTimerBP();
        result = result * 59 + (int)($timerBP >>> 32 ^ $timerBP);
        long $timerIteration = this.getTimerIteration();
        result = result * 59 + (int)($timerIteration >>> 32 ^ $timerIteration);
        SleepMode $sleepMode = this.getSleepMode();
        result = result * 59 + ($sleepMode == null ? 43 : ((Object)((Object)$sleepMode)).hashCode());
        TimeMode $timeMode = this.getTimeMode();
        result = result * 59 + ($timeMode == null ? 43 : ((Object)((Object)$timeMode)).hashCode());
        return result;
    }

    public String toString() {
        return "SleepyTrainingListener(lastEE=" + this.lastEE + ", lastES=" + this.lastES + ", lastFF=" + this.lastFF + ", lastBP=" + this.lastBP + ", lastIteration=" + this.lastIteration + ", timerEE=" + this.getTimerEE() + ", timerES=" + this.getTimerES() + ", timerFF=" + this.getTimerFF() + ", timerBP=" + this.getTimerBP() + ", timerIteration=" + this.getTimerIteration() + ", sleepMode=" + (Object)((Object)this.getSleepMode()) + ", timeMode=" + (Object)((Object)this.getTimeMode()) + ")";
    }

    public static class SleepyTrainingListenerBuilder {
        private boolean timerEE$set;
        private long timerEE;
        private boolean timerES$set;
        private long timerES;
        private boolean timerFF$set;
        private long timerFF;
        private boolean timerBP$set;
        private long timerBP;
        private boolean timerIteration$set;
        private long timerIteration;
        private boolean sleepMode$set;
        private SleepMode sleepMode;
        private boolean timeMode$set;
        private TimeMode timeMode;

        SleepyTrainingListenerBuilder() {
        }

        public SleepyTrainingListenerBuilder timerEE(long timerEE) {
            this.timerEE = timerEE;
            this.timerEE$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerES(long timerES) {
            this.timerES = timerES;
            this.timerES$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerFF(long timerFF) {
            this.timerFF = timerFF;
            this.timerFF$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerBP(long timerBP) {
            this.timerBP = timerBP;
            this.timerBP$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timerIteration(long timerIteration) {
            this.timerIteration = timerIteration;
            this.timerIteration$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder sleepMode(SleepMode sleepMode) {
            this.sleepMode = sleepMode;
            this.sleepMode$set = true;
            return this;
        }

        public SleepyTrainingListenerBuilder timeMode(TimeMode timeMode) {
            this.timeMode = timeMode;
            this.timeMode$set = true;
            return this;
        }

        public SleepyTrainingListener build() {
            return new SleepyTrainingListener(this.timerEE$set ? this.timerEE : SleepyTrainingListener.$default$timerEE(), this.timerES$set ? this.timerES : SleepyTrainingListener.$default$timerES(), this.timerFF$set ? this.timerFF : SleepyTrainingListener.$default$timerFF(), this.timerBP$set ? this.timerBP : SleepyTrainingListener.$default$timerBP(), this.timerIteration$set ? this.timerIteration : SleepyTrainingListener.$default$timerIteration(), this.sleepMode$set ? this.sleepMode : SleepyTrainingListener.$default$sleepMode(), this.timeMode$set ? this.timeMode : SleepyTrainingListener.$default$timeMode());
        }

        public String toString() {
            return "SleepyTrainingListener.SleepyTrainingListenerBuilder(timerEE=" + this.timerEE + ", timerES=" + this.timerES + ", timerFF=" + this.timerFF + ", timerBP=" + this.timerBP + ", timerIteration=" + this.timerIteration + ", sleepMode=" + (Object)((Object)this.sleepMode) + ", timeMode=" + (Object)((Object)this.timeMode) + ")";
        }
    }

    public static enum TimeMode {
        ADDITIVE,
        SIMPLE;

    }

    public static enum SleepMode {
        PARK,
        SLEEP,
        BUSY;

    }
}

