/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.i18n;

import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.deeplearning4j.ui.api.I18N;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultI18N
implements I18N {
    private static final Logger log = LoggerFactory.getLogger(DefaultI18N.class);
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String FALLBACK_LANGUAGE = "en";
    public static final String DEFAULT_I8N_RESOURCES_DIR = "dl4j_i18n";
    private static DefaultI18N instance;
    private Map<String, Map<String, String>> messagesByLanguage = new HashMap<String, Map<String, String>>();
    private String currentLanguage = "en";
    private Set<String> loadedLanguages = Collections.synchronizedSet(new HashSet());

    public static synchronized I18N getInstance() {
        if (instance == null) {
            instance = new DefaultI18N();
        }
        return instance;
    }

    private DefaultI18N() {
        this.loadLanguageResources(this.currentLanguage);
    }

    private synchronized void loadLanguageResources(String languageCode) {
        if (this.loadedLanguages.contains(languageCode)) {
            return;
        }
        URL url = this.getClass().getResource("/dl4j_i18n/");
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new ResourcesScanner()}).setUrls(new URL[]{url}));
        String pattern = ".*" + languageCode;
        Set resources = reflections.getResources(Pattern.compile(pattern));
        HashMap<String, String> messages = new HashMap<String, String>();
        for (String s : resources) {
            if (!s.endsWith(languageCode)) continue;
            log.trace("Attempting to parse file: {}", (Object)s);
            this.parseFile(s, messages);
        }
        this.messagesByLanguage.put(languageCode, messages);
        this.loadedLanguages.add(languageCode);
    }

    private void parseFile(String filename, Map<String, String> results) {
        List lines;
        try {
            String path = filename.startsWith(DEFAULT_I8N_RESOURCES_DIR) ? "/" + filename : "/dl4j_i18n/" + filename;
            InputStream is = this.getClass().getResourceAsStream(path);
            lines = IOUtils.readLines((InputStream)is);
        }
        catch (Exception e) {
            log.debug("Error parsing UI I18N content file; skipping: {}", (Object)filename, (Object)e.getMessage());
            return;
        }
        int count = 0;
        for (String line : lines) {
            if (!line.matches(".+=.*")) {
                log.debug("Invalid line in I18N file: {}, \"{}\"", (Object)filename, (Object)line);
                continue;
            }
            int idx = line.indexOf(61);
            String key = line.substring(0, idx);
            String value = line.substring(Math.min(idx + 1, line.length()));
            results.put(key, value);
            ++count;
        }
        log.trace("Loaded {} messages from file {}", (Object)count, (Object)filename);
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(this.currentLanguage, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String langCode, String key) {
        String msg;
        Map<String, String> messagesForLanguage = this.messagesByLanguage.get(langCode);
        if (messagesForLanguage == null) {
            DefaultI18N defaultI18N = this;
            synchronized (defaultI18N) {
                if (this.messagesByLanguage.get(langCode) == null) {
                    this.loadLanguageResources(langCode);
                }
            }
            messagesForLanguage = this.messagesByLanguage.get(langCode);
        }
        if ((msg = messagesForLanguage.get(key)) == null && !"en".equals(langCode)) {
            return this.getMessage("en", key);
        }
        return msg;
    }

    @Override
    public String getDefaultLanguage() {
        return this.currentLanguage;
    }

    @Override
    public void setDefaultLanguage(String langCode) {
        this.currentLanguage = langCode;
        log.debug("UI: Set language to {}", (Object)langCode);
    }
}

