/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.module.train;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.berkeley.Triple;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.ui.api.FunctionType;
import org.deeplearning4j.ui.api.HttpMethod;
import org.deeplearning4j.ui.api.I18N;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.module.train.TrainModuleUtils;
import org.deeplearning4j.ui.stats.api.Histogram;
import org.deeplearning4j.ui.stats.api.StatsInitializationReport;
import org.deeplearning4j.ui.stats.api.StatsReport;
import org.deeplearning4j.ui.stats.api.StatsType;
import org.deeplearning4j.ui.views.html.training.TrainingHelp;
import org.deeplearning4j.ui.views.html.training.TrainingModel;
import org.deeplearning4j.ui.views.html.training.TrainingOverview;
import org.deeplearning4j.ui.views.html.training.TrainingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;
import play.twirl.api.Content;

public class TrainModule
implements UIModule {
    private static final Logger log = LoggerFactory.getLogger(TrainModule.class);
    public static final double NAN_REPLACEMENT_VALUE = 0.0;
    public static final int DEFAULT_MAX_CHART_POINTS = 512;
    public static final String CHART_MAX_POINTS_PROPERTY = "org.deeplearning4j.ui.maxChartPoints";
    private static final DecimalFormat df2 = new DecimalFormat("#.00");
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final int maxChartPoints;
    private Map<String, StatsStorage> knownSessionIDs = Collections.synchronizedMap(new LinkedHashMap());
    private String currentSessionID;
    private int currentWorkerIdx;
    private Map<String, AtomicInteger> workerIdxCount = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<Integer, String>> workerIdxToName = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> lastUpdateForSession = Collections.synchronizedMap(new HashMap());
    private static Triple<int[], float[], float[]> EMPTY_TRIPLE = new Triple((Object)new int[0], (Object)new float[0], (Object)new float[0]);

    public TrainModule() {
        String maxChartPointsProp = System.getProperty(CHART_MAX_POINTS_PROPERTY);
        int value = 512;
        if (maxChartPointsProp != null) {
            try {
                value = Integer.parseInt(maxChartPointsProp);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid system property: {} = {}", (Object)CHART_MAX_POINTS_PROPERTY, (Object)maxChartPointsProp);
            }
        }
        this.maxChartPoints = value >= 10 ? value : 512;
    }

    @Override
    public List<String> getCallbackTypeIDs() {
        return Collections.singletonList("StatsListener");
    }

    @Override
    public List<Route> getRoutes() {
        Route r = new Route("/train", HttpMethod.GET, FunctionType.Supplier, () -> Results.redirect((String)"/train/overview"));
        Route r2 = new Route("/train/overview", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)TrainingOverview.apply(I18NProvider.getInstance())));
        Route r2a = new Route("/train/overview/data", HttpMethod.GET, FunctionType.Supplier, this::getOverviewData);
        Route r3 = new Route("/train/model", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)TrainingModel.apply(I18NProvider.getInstance())));
        Route r3a = new Route("/train/model/graph", HttpMethod.GET, FunctionType.Supplier, this::getModelGraph);
        Route r3b = new Route("/train/model/data/:layerId", HttpMethod.GET, FunctionType.Function, this::getModelData);
        Route r4 = new Route("/train/system", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)TrainingSystem.apply(I18NProvider.getInstance())));
        Route r4a = new Route("/train/system/data", HttpMethod.GET, FunctionType.Supplier, this::getSystemData);
        Route r5 = new Route("/train/help", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((Content)TrainingHelp.apply(I18NProvider.getInstance())));
        Route r6 = new Route("/train/sessions/current", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((String)(this.currentSessionID == null ? "" : this.currentSessionID)));
        Route r6a = new Route("/train/sessions/all", HttpMethod.GET, FunctionType.Supplier, this::listSessions);
        Route r6b = new Route("/train/sessions/info", HttpMethod.GET, FunctionType.Supplier, this::sessionInfo);
        Route r6c = new Route("/train/sessions/set/:to", HttpMethod.GET, FunctionType.Function, this::setSession);
        Route r6d = new Route("/train/sessions/lastUpdate/:sessionId", HttpMethod.GET, FunctionType.Function, this::getLastUpdateForSession);
        Route r7 = new Route("/train/workers/currentByIdx", HttpMethod.GET, FunctionType.Supplier, () -> Results.ok((String)String.valueOf(this.currentWorkerIdx)));
        Route r7a = new Route("/train/workers/setByIdx/:to", HttpMethod.GET, FunctionType.Function, this::setWorkerByIdx);
        return Arrays.asList(r, r2, r2a, r3, r3a, r3b, r4, r4a, r5, r6, r6a, r6b, r6c, r6d, r7, r7a);
    }

    @Override
    public synchronized void reportStorageEvents(Collection<StatsStorageEvent> events) {
        for (StatsStorageEvent sse : events) {
            Long lastUpdate;
            if (!"StatsListener".equals(sse.getTypeID())) continue;
            if (sse.getEventType() == StatsStorageListener.EventType.PostStaticInfo && "StatsListener".equals(sse.getTypeID())) {
                this.knownSessionIDs.put(sse.getSessionID(), sse.getStatsStorage());
            }
            if ((lastUpdate = this.lastUpdateForSession.get(sse.getSessionID())) == null) {
                this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
                continue;
            }
            if (sse.getTimestamp() <= lastUpdate) continue;
            this.lastUpdateForSession.put(sse.getSessionID(), sse.getTimestamp());
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
    }

    @Override
    public synchronized void onAttach(StatsStorage statsStorage) {
        for (String sessionID : statsStorage.listSessionIDs()) {
            for (String typeID : statsStorage.listTypeIDsForSession(sessionID)) {
                if (!"StatsListener".equals(typeID)) continue;
                this.knownSessionIDs.put(sessionID, statsStorage);
            }
        }
        if (this.currentSessionID == null) {
            this.getDefaultSession();
        }
    }

    @Override
    public void onDetach(StatsStorage statsStorage) {
        for (String s : this.knownSessionIDs.keySet()) {
            if (this.knownSessionIDs.get(s) != statsStorage) continue;
            this.knownSessionIDs.remove(s);
        }
    }

    private void getDefaultSession() {
        if (this.currentSessionID != null) {
            return;
        }
        long mostRecentTime = Long.MIN_VALUE;
        String sessionID = null;
        for (Map.Entry<String, StatsStorage> entry : this.knownSessionIDs.entrySet()) {
            Persistable p;
            long thisTime;
            List staticInfos = entry.getValue().getAllStaticInfos(entry.getKey(), "StatsListener");
            if (staticInfos == null || staticInfos.size() == 0 || (thisTime = (p = (Persistable)staticInfos.get(0)).getTimeStamp()) <= mostRecentTime) continue;
            mostRecentTime = thisTime;
            sessionID = entry.getKey();
        }
        if (sessionID != null) {
            this.currentSessionID = sessionID;
        }
    }

    private synchronized String getWorkerIdForIndex(int workerIdx) {
        String sid = this.currentSessionID;
        if (sid == null) {
            return null;
        }
        Map<Integer, String> idxToId = this.workerIdxToName.get(sid);
        if (idxToId == null) {
            idxToId = Collections.synchronizedMap(new HashMap());
            this.workerIdxToName.put(sid, idxToId);
        }
        if (idxToId.containsKey(workerIdx)) {
            return idxToId.get(workerIdx);
        }
        AtomicInteger counter = this.workerIdxCount.get(sid);
        if (counter == null) {
            counter = new AtomicInteger(0);
            this.workerIdxCount.put(sid, counter);
        }
        StatsStorage ss = this.knownSessionIDs.get(sid);
        ArrayList allWorkerIds = new ArrayList(ss.listWorkerIDsForSessionAndType(sid, "StatsListener"));
        Collections.sort(allWorkerIds);
        for (String s : allWorkerIds) {
            if (idxToId.containsValue(s)) continue;
            idxToId.put(counter.getAndIncrement(), s);
        }
        return idxToId.get(workerIdx);
    }

    private Result listSessions() {
        return Results.ok((JsonNode)Json.toJson(this.knownSessionIDs.keySet()));
    }

    private Result sessionInfo() {
        HashMap dataEachSession = new HashMap();
        for (Map.Entry<String, StatsStorage> entry : this.knownSessionIDs.entrySet()) {
            HashMap<String, Object> dataThisSession = new HashMap<String, Object>();
            String sid = entry.getKey();
            StatsStorage ss = entry.getValue();
            List workerIDs = ss.listWorkerIDsForSessionAndType(sid, "StatsListener");
            int workerCount = workerIDs == null ? 0 : workerIDs.size();
            List staticInfo = ss.getAllStaticInfos(sid, "StatsListener");
            long initTime = Long.MAX_VALUE;
            if (staticInfo != null) {
                for (Persistable p : staticInfo) {
                    initTime = Math.min(p.getTimeStamp(), initTime);
                }
            }
            long lastUpdateTime = Long.MIN_VALUE;
            List lastUpdatesAllWorkers = ss.getLatestUpdateAllWorkers(sid, "StatsListener");
            for (Persistable p : lastUpdatesAllWorkers) {
                lastUpdateTime = Math.max(lastUpdateTime, p.getTimeStamp());
            }
            dataThisSession.put("numWorkers", workerCount);
            dataThisSession.put("initTime", initTime == Long.MAX_VALUE ? "" : Long.valueOf(initTime));
            dataThisSession.put("lastUpdate", lastUpdateTime == Long.MIN_VALUE ? "" : Long.valueOf(lastUpdateTime));
            if (workerCount > 0) {
                dataThisSession.put("workers", workerIDs);
            }
            if (staticInfo != null && staticInfo.size() > 0) {
                StatsInitializationReport sr = (StatsInitializationReport)staticInfo.get(0);
                String modelClassName = sr.getModelClassName();
                if (modelClassName.endsWith("MultiLayerNetwork")) {
                    modelClassName = "MultiLayerNetwork";
                } else if (modelClassName.endsWith("ComputationGraph")) {
                    modelClassName = "ComputationGraph";
                }
                int numLayers = sr.getModelNumLayers();
                long numParams = sr.getModelNumParams();
                dataThisSession.put("modelType", modelClassName);
                dataThisSession.put("numLayers", numLayers);
                dataThisSession.put("numParams", numParams);
            } else {
                dataThisSession.put("modelType", "");
                dataThisSession.put("numLayers", "");
                dataThisSession.put("numParams", "");
            }
            dataEachSession.put(sid, dataThisSession);
        }
        return Results.ok((JsonNode)Json.toJson(dataEachSession));
    }

    private Result setSession(String newSessionID) {
        if (this.knownSessionIDs.containsKey(newSessionID)) {
            this.currentSessionID = newSessionID;
            this.currentWorkerIdx = 0;
            return Results.ok();
        }
        return Results.badRequest((String)("Unknown session ID: " + newSessionID));
    }

    private Result getLastUpdateForSession(String sessionID) {
        Long lastUpdate = this.lastUpdateForSession.get(sessionID);
        if (lastUpdate != null) {
            return Results.ok((String)String.valueOf(lastUpdate));
        }
        return Results.ok((String)"-1");
    }

    private Result setWorkerByIdx(String newWorkerIdx) {
        try {
            this.currentWorkerIdx = Integer.parseInt(newWorkerIdx);
        }
        catch (NumberFormatException e) {
            log.debug("Invaild call to setWorkerByIdx", (Throwable)e);
        }
        return Results.ok();
    }

    private Result getOverviewData() {
        Persistable p;
        Persistable u;
        List updates;
        Long lastUpdate = this.lastUpdateForSession.get(this.currentSessionID);
        if (lastUpdate == null) {
            lastUpdate = -1L;
        }
        I18N i18N = I18NProvider.getInstance();
        boolean noData = this.currentSessionID == null;
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(this.currentSessionID);
        String wid = this.getWorkerIdForIndex(this.currentWorkerIdx);
        if (wid == null) {
            noData = true;
        }
        ArrayList<Integer> scoresIterCount = new ArrayList<Integer>();
        ArrayList<Double> scores = new ArrayList<Double>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("updateTimestamp", lastUpdate);
        result.put("scores", scores);
        result.put("scoresIter", scoresIterCount);
        List list = updates = noData ? null : ss.getAllUpdatesAfter(this.currentSessionID, "StatsListener", wid, 0L);
        if (updates == null || updates.size() == 0) {
            noData = true;
        }
        HashMap updateRatios = new HashMap();
        result.put("updateRatios", updateRatios);
        HashMap stdevActivations = new HashMap();
        HashMap stdevGradients = new HashMap();
        HashMap stdevUpdates = new HashMap();
        result.put("stdevActivations", stdevActivations);
        result.put("stdevGradients", stdevGradients);
        result.put("stdevUpdates", stdevUpdates);
        if (!noData && (u = (Persistable)updates.get(0)) instanceof StatsReport) {
            Map stdAct;
            Map stdUpdate;
            Map stdGrad;
            StatsReport sp = (StatsReport)u;
            Map map = sp.getMeanMagnitudes(StatsType.Parameters);
            if (map != null) {
                for (Object s : map.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    updateRatios.put(s, new ArrayList());
                }
            }
            if ((stdGrad = sp.getStdev(StatsType.Gradients)) != null) {
                for (Object s : stdGrad.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    stdevGradients.put(s, new ArrayList());
                }
            }
            if ((stdUpdate = sp.getStdev(StatsType.Updates)) != null) {
                for (Object s : stdUpdate.keySet()) {
                    if (!((String)s).toLowerCase().endsWith("w")) continue;
                    stdevUpdates.put(s, new ArrayList());
                }
            }
            if ((stdAct = sp.getStdev(StatsType.Activations)) != null) {
                for (String s : stdAct.keySet()) {
                    stdevActivations.put(s, new ArrayList());
                }
            }
        }
        StatsReport last = null;
        int offset = 0;
        int countSinceLastOffsetReset = 0;
        if (!noData) {
            int totalUpdates = updates.size();
            int subsamplingFrequency = 1;
            if (totalUpdates > this.maxChartPoints) {
                subsamplingFrequency = totalUpdates / this.maxChartPoints;
            }
            int pCount = -1;
            int lastUpdateIdx = updates.size() - 1;
            for (Persistable u2 : updates) {
                double d;
                ++pCount;
                if (!(u2 instanceof StatsReport)) continue;
                last = (StatsReport)u2;
                int iterCount = last.getIterationCount();
                ++countSinceLastOffsetReset;
                if (iterCount == 0) {
                    offset += countSinceLastOffsetReset;
                    countSinceLastOffsetReset = 0;
                }
                iterCount += offset;
                if (pCount > 0 && subsamplingFrequency > 1 && pCount % subsamplingFrequency != 0 && pCount != lastUpdateIdx) continue;
                scoresIterCount.add(iterCount);
                double lastScore = last.getScore();
                scores.add(lastScore);
                Map updateMM = last.getMeanMagnitudes(StatsType.Updates);
                Map paramMM = last.getMeanMagnitudes(StatsType.Parameters);
                if (updateMM != null && paramMM != null && updateMM.size() > 0 && paramMM.size() > 0) {
                    for (String s : updateRatios.keySet()) {
                        double currParam;
                        List ratioHistory = (List)updateRatios.get(s);
                        double currUpdate = (Double)updateMM.get(s);
                        double ratio = currUpdate / (currParam = ((Double)paramMM.get(s)).doubleValue());
                        if (Double.isNaN(ratio)) {
                            ratioHistory.add(0.0);
                            continue;
                        }
                        ratioHistory.add(ratio);
                    }
                }
                Map stdGrad = last.getStdev(StatsType.Gradients);
                Map stdUpd = last.getStdev(StatsType.Updates);
                Map stdAct = last.getStdev(StatsType.Activations);
                if (stdGrad != null) {
                    for (String s : stdevGradients.keySet()) {
                        d = (Double)stdGrad.get(s);
                        ((List)stdevGradients.get(s)).add(d);
                    }
                }
                if (stdUpd != null) {
                    for (String s : stdevUpdates.keySet()) {
                        d = (Double)stdUpd.get(s);
                        ((List)stdevUpdates.get(s)).add(d);
                    }
                }
                if (stdAct == null) continue;
                for (String s : stdevActivations.keySet()) {
                    d = (Double)stdAct.get(s);
                    ((List)stdevActivations.get(s)).add(d);
                }
            }
        }
        String[][] perfInfo = new String[][]{{i18N.getMessage("train.overview.perftable.startTime"), ""}, {i18N.getMessage("train.overview.perftable.totalRuntime"), ""}, {i18N.getMessage("train.overview.perftable.lastUpdate"), ""}, {i18N.getMessage("train.overview.perftable.totalParamUpdates"), ""}, {i18N.getMessage("train.overview.perftable.updatesPerSec"), ""}, {i18N.getMessage("train.overview.perftable.examplesPerSec"), ""}};
        if (last != null) {
            perfInfo[2][1] = String.valueOf(dateFormat.format(new Date(last.getTimeStamp())));
            perfInfo[3][1] = String.valueOf(last.getTotalMinibatches());
            perfInfo[4][1] = String.valueOf(df2.format(last.getMinibatchesPerSecond()));
            perfInfo[5][1] = String.valueOf(df2.format(last.getExamplesPerSecond()));
        }
        result.put("perf", perfInfo);
        String[][] modelInfo = new String[][]{{i18N.getMessage("train.overview.modeltable.modeltype"), ""}, {i18N.getMessage("train.overview.modeltable.nLayers"), ""}, {i18N.getMessage("train.overview.modeltable.nParams"), ""}};
        if (!noData && (p = ss.getStaticInfo(this.currentSessionID, "StatsListener", wid)) != null) {
            String modelType;
            StatsInitializationReport initReport = (StatsInitializationReport)p;
            int nLayers = initReport.getModelNumLayers();
            long numParams = initReport.getModelNumParams();
            String className = initReport.getModelClassName();
            if (className.endsWith("MultiLayerNetwork")) {
                modelType = "MultiLayerNetwork";
            } else if (className.endsWith("ComputationGraph")) {
                modelType = "ComputationGraph";
            } else {
                modelType = className;
                if (modelType.lastIndexOf(46) > 0) {
                    modelType = modelType.substring(modelType.lastIndexOf(46) + 1);
                }
            }
            modelInfo[0][1] = modelType;
            modelInfo[1][1] = String.valueOf(nLayers);
            modelInfo[2][1] = String.valueOf(numParams);
        }
        result.put("model", modelInfo);
        return Results.ok((JsonNode)Json.toJson(result));
    }

    private Result getModelGraph() {
        List allStatic;
        boolean noData = this.currentSessionID == null;
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(this.currentSessionID);
        List list = allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(this.currentSessionID, "StatsListener");
        if (allStatic.size() == 0) {
            return Results.ok();
        }
        TrainModuleUtils.GraphInfo gi = this.getGraphInfo();
        if (gi == null) {
            return Results.ok();
        }
        return Results.ok((JsonNode)Json.toJson((Object)gi));
    }

    private TrainModuleUtils.GraphInfo getGraphInfo() {
        Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> conf = this.getConfig();
        if (conf == null) {
            return null;
        }
        if (conf.getFirst() != null) {
            return TrainModuleUtils.buildGraphInfo((MultiLayerConfiguration)conf.getFirst());
        }
        if (conf.getSecond() != null) {
            return TrainModuleUtils.buildGraphInfo((ComputationGraphConfiguration)conf.getSecond());
        }
        if (conf.getThird() != null) {
            return TrainModuleUtils.buildGraphInfo((NeuralNetConfiguration)conf.getThird());
        }
        return null;
    }

    private Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> getConfig() {
        List allStatic;
        boolean noData = this.currentSessionID == null;
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(this.currentSessionID);
        List list = allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(this.currentSessionID, "StatsListener");
        if (allStatic.size() == 0) {
            return null;
        }
        StatsInitializationReport p = (StatsInitializationReport)allStatic.get(0);
        String modelClass = p.getModelClassName();
        String config = p.getModelConfigJson();
        if (modelClass.endsWith("MultiLayerNetwork")) {
            MultiLayerConfiguration conf = MultiLayerConfiguration.fromJson((String)config);
            return new Triple((Object)conf, null, null);
        }
        if (modelClass.endsWith("ComputationGraph")) {
            ComputationGraphConfiguration conf = ComputationGraphConfiguration.fromJson((String)config);
            return new Triple(null, (Object)conf, null);
        }
        try {
            NeuralNetConfiguration layer = (NeuralNetConfiguration)NeuralNetConfiguration.mapper().readValue(config, NeuralNetConfiguration.class);
            return new Triple(null, null, (Object)layer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Result getModelData(String str) {
        int pCount;
        Long lastUpdateTime = this.lastUpdateForSession.get(this.currentSessionID);
        if (lastUpdateTime == null) {
            lastUpdateTime = -1L;
        }
        int layerIdx = Integer.parseInt(str);
        I18N i18N = I18NProvider.getInstance();
        boolean noData = this.currentSessionID == null;
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(this.currentSessionID);
        String wid = this.getWorkerIdForIndex(this.currentWorkerIdx);
        if (wid == null) {
            noData = true;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("updateTimestamp", lastUpdateTime);
        Triple<MultiLayerConfiguration, ComputationGraphConfiguration, NeuralNetConfiguration> conf = this.getConfig();
        if (conf == null) {
            return Results.ok((JsonNode)Json.toJson(result));
        }
        TrainModuleUtils.GraphInfo gi = this.getGraphInfo();
        if (gi == null) {
            return Results.ok((JsonNode)Json.toJson(result));
        }
        String[][] layerInfoTable = this.getLayerInfoTable(layerIdx, gi, i18N, noData, ss, wid);
        result.put("layerInfo", layerInfoTable);
        ArrayList<Persistable> updates = noData ? null : ss.getAllUpdatesAfter(this.currentSessionID, "StatsListener", wid, 0L);
        ArrayList<Integer> iterationCounts = null;
        if (updates != null && updates.size() > this.maxChartPoints) {
            int subsamplingFrequency = updates.size() / this.maxChartPoints;
            ArrayList<Persistable> subsampled = new ArrayList<Persistable>();
            iterationCounts = new ArrayList();
            pCount = -1;
            int lastUpdateIdx = updates.size() - 1;
            int offset = 0;
            int countSinceLastOffsetReset = 0;
            for (Persistable p : updates) {
                if (!(p instanceof StatsReport)) continue;
                StatsReport sr = (StatsReport)p;
                ++pCount;
                ++countSinceLastOffsetReset;
                int iterCount = sr.getIterationCount();
                if (iterCount == 0) {
                    offset += countSinceLastOffsetReset;
                    countSinceLastOffsetReset = 0;
                }
                iterCount += offset;
                if (pCount > 0 && subsamplingFrequency > 1 && pCount % subsamplingFrequency != 0 && pCount != lastUpdateIdx) continue;
                subsampled.add(p);
                iterationCounts.add(iterCount);
            }
            updates = subsampled;
        } else if (updates != null) {
            int offset = 0;
            int countSinceLastOffsetReset = 0;
            iterationCounts = new ArrayList<Integer>(updates.size());
            pCount = -1;
            for (Persistable p : updates) {
                if (!(p instanceof StatsReport)) continue;
                StatsReport sr = (StatsReport)p;
                ++pCount;
                ++countSinceLastOffsetReset;
                int iterCount = sr.getIterationCount();
                if (iterCount == 0) {
                    offset += countSinceLastOffsetReset;
                    countSinceLastOffsetReset = 0;
                }
                iterationCounts.add(iterCount += offset);
            }
        }
        ModelType mt = conf.getFirst() != null ? ModelType.MLN : (conf.getSecond() != null ? ModelType.CG : ModelType.Layer);
        MeanMagnitudes mm = this.getLayerMeanMagnitudes(layerIdx, gi, (List<Persistable>)updates, iterationCounts, mt);
        HashMap<String, Object> mmRatioMap = new HashMap<String, Object>();
        mmRatioMap.put("layerParamNames", mm.getRatios().keySet());
        mmRatioMap.put("iterCounts", mm.getIterations());
        mmRatioMap.put("ratios", mm.getRatios());
        mmRatioMap.put("paramMM", mm.getParamMM());
        mmRatioMap.put("updateMM", mm.getUpdateMM());
        result.put("meanMag", mmRatioMap);
        Triple<int[], float[], float[]> activationsData = this.getLayerActivations(layerIdx, gi, updates, iterationCounts);
        HashMap<String, Object> activationMap = new HashMap<String, Object>();
        activationMap.put("iterCount", activationsData.getFirst());
        activationMap.put("mean", activationsData.getSecond());
        activationMap.put("stdev", activationsData.getThird());
        result.put("activations", activationMap);
        Map<String, Object> lrs = this.getLayerLearningRates(layerIdx, gi, updates, iterationCounts, mt);
        result.put("learningRates", lrs);
        Persistable lastUpdate = updates != null && updates.size() > 0 ? (Persistable)updates.get(updates.size() - 1) : null;
        Map<String, Object> paramHistograms = TrainModule.getHistograms(layerIdx, gi, StatsType.Parameters, lastUpdate);
        result.put("paramHist", paramHistograms);
        Map<String, Object> updateHistograms = TrainModule.getHistograms(layerIdx, gi, StatsType.Updates, lastUpdate);
        result.put("updateHist", updateHistograms);
        return Results.ok((JsonNode)Json.toJson(result));
    }

    public Result getSystemData() {
        Long lastUpdate = this.lastUpdateForSession.get(this.currentSessionID);
        if (lastUpdate == null) {
            lastUpdate = -1L;
        }
        I18N i18n = I18NProvider.getInstance();
        boolean noData = this.currentSessionID == null;
        StatsStorage ss = noData ? null : this.knownSessionIDs.get(this.currentSessionID);
        List allStatic = noData ? Collections.EMPTY_LIST : ss.getAllStaticInfos(this.currentSessionID, "StatsListener");
        List latestUpdates = noData ? Collections.EMPTY_LIST : ss.getLatestUpdateAllWorkers(this.currentSessionID, "StatsListener");
        long lastUpdateTime = -1L;
        if (latestUpdates == null || latestUpdates.size() == 0) {
            noData = true;
        } else {
            for (Persistable p : latestUpdates) {
                lastUpdateTime = Math.max(lastUpdateTime, p.getTimeStamp());
            }
        }
        long fromTime = lastUpdateTime - 300000L;
        List lastNMinutes = noData ? null : ss.getAllUpdatesAfter(this.currentSessionID, "StatsListener", fromTime);
        Map<String, Object> mem = TrainModule.getMemory(allStatic, lastNMinutes, i18n);
        Pair<Map<String, Object>, Map<String, Object>> hwSwInfo = TrainModule.getHardwareSoftwareInfo(allStatic, i18n);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("updateTimestamp", lastUpdate);
        ret.put("memory", mem);
        ret.put("hardware", hwSwInfo.getFirst());
        ret.put("software", hwSwInfo.getSecond());
        return Results.ok((JsonNode)Json.toJson(ret));
    }

    private static String getLayerType(Layer layer) {
        String layerType = "n/a";
        if (layer != null) {
            try {
                layerType = layer.getClass().getSimpleName().replaceAll("Layer$", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return layerType;
    }

    private String[][] getLayerInfoTable(int layerIdx, TrainModuleUtils.GraphInfo gi, I18N i18N, boolean noData, StatsStorage ss, String wid) {
        ArrayList<String[]> layerInfoRows;
        block13: {
            NeuralNetConfiguration nnc;
            Layer layer;
            String layerType;
            block15: {
                String modelClass;
                block16: {
                    String vertexName;
                    MultiLayerConfiguration conf;
                    block18: {
                        block17: {
                            String configJson;
                            block14: {
                                Persistable p;
                                layerInfoRows = new ArrayList<String[]>();
                                layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerName"), gi.getVertexNames().get(layerIdx)});
                                layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerType"), ""});
                                if (noData || (p = ss.getStaticInfo(this.currentSessionID, "StatsListener", wid)) == null) break block13;
                                StatsInitializationReport initReport = (StatsInitializationReport)p;
                                configJson = initReport.getModelConfigJson();
                                modelClass = initReport.getModelClassName();
                                layerType = "";
                                layer = null;
                                nnc = null;
                                if (!modelClass.endsWith("MultiLayerNetwork")) break block14;
                                conf = MultiLayerConfiguration.fromJson((String)configJson);
                                int confIdx = layerIdx - 1;
                                if (confIdx >= 0) {
                                    nnc = conf.getConf(confIdx);
                                    layer = nnc.getLayer();
                                } else {
                                    layerType = "Input";
                                }
                                break block15;
                            }
                            if (!modelClass.endsWith("ComputationGraph")) break block16;
                            conf = ComputationGraphConfiguration.fromJson((String)configJson);
                            vertexName = gi.getVertexNames().get(layerIdx);
                            Map vertices = conf.getVertices();
                            if (!vertices.containsKey(vertexName) || !(vertices.get(vertexName) instanceof LayerVertex)) break block17;
                            LayerVertex lv = (LayerVertex)vertices.get(vertexName);
                            nnc = lv.getLayerConf();
                            layer = nnc.getLayer();
                            break block15;
                        }
                        if (!conf.getNetworkInputs().contains(vertexName)) break block18;
                        layerType = "Input";
                        break block15;
                    }
                    GraphVertex gv = (GraphVertex)conf.getVertices().get(vertexName);
                    if (gv == null) break block15;
                    layerType = gv.getClass().getSimpleName();
                    break block15;
                }
                if (modelClass.endsWith("VariationalAutoencoder")) {
                    layerType = gi.getVertexTypes().get(layerIdx);
                    Map<String, String> map = gi.getVertexInfo().get(layerIdx);
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        layerInfoRows.add(new String[]{entry.getKey(), entry.getValue()});
                    }
                }
            }
            if (layer != null) {
                layerType = TrainModule.getLayerType(layer);
            }
            if (layer != null) {
                String activationFn = null;
                if (layer instanceof FeedForwardLayer) {
                    FeedForwardLayer ffl = (FeedForwardLayer)layer;
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerNIn"), String.valueOf(ffl.getNIn())});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerSize"), String.valueOf(ffl.getNOut())});
                    activationFn = layer.getActivationFn().toString();
                }
                int nParams = layer.initializer().numParams(nnc);
                layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerNParams"), String.valueOf(nParams)});
                if (nParams > 0) {
                    WeightInit wi = layer.getWeightInit();
                    String str = wi.toString();
                    if (wi == WeightInit.DISTRIBUTION) {
                        str = str + layer.getDist();
                    }
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerWeightInit"), str});
                    Updater u = layer.getUpdater();
                    String us = u == null ? "" : u.toString();
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerUpdater"), us});
                }
                if (layer instanceof ConvolutionLayer || layer instanceof SubsamplingLayer) {
                    int[] padding;
                    int[] stride;
                    int[] kernel;
                    if (layer instanceof ConvolutionLayer) {
                        ConvolutionLayer cl = (ConvolutionLayer)layer;
                        kernel = cl.getKernelSize();
                        stride = cl.getStride();
                        padding = cl.getPadding();
                    } else {
                        SubsamplingLayer ssl = (SubsamplingLayer)layer;
                        kernel = ssl.getKernelSize();
                        stride = ssl.getStride();
                        padding = ssl.getPadding();
                        activationFn = null;
                        layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerSubsamplingPoolingType"), ssl.getPoolingType().toString()});
                    }
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnKernel"), Arrays.toString(kernel)});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnStride"), Arrays.toString(stride)});
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerCnnPadding"), Arrays.toString(padding)});
                }
                if (activationFn != null) {
                    layerInfoRows.add(new String[]{i18N.getMessage("train.model.layerinfotable.layerActivationFn"), activationFn});
                }
            }
            ((String[])layerInfoRows.get((int)1))[1] = layerType;
        }
        return (String[][])layerInfoRows.toArray((T[])new String[layerInfoRows.size()][0]);
    }

    private MeanMagnitudes getLayerMeanMagnitudes(int layerIdx, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts, ModelType modelType) {
        String layerType;
        if (gi == null) {
            return new MeanMagnitudes(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }
        String layerName = gi.getVertexNames().get(layerIdx);
        if (modelType != ModelType.CG) {
            layerName = gi.getOriginalVertexName().get(layerIdx);
        }
        if ("input".equalsIgnoreCase(layerType = gi.getVertexTypes().get(layerIdx))) {
            return new MeanMagnitudes(Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        }
        ArrayList<Integer> iterCounts = new ArrayList<Integer>();
        HashMap<String, List<Double>> ratioValues = new HashMap<String, List<Double>>();
        HashMap<String, List<Double>> outParamMM = new HashMap<String, List<Double>>();
        HashMap<String, List<Double>> outUpdateMM = new HashMap<String, List<Double>>();
        if (updates != null) {
            int pCount = -1;
            for (Persistable u : updates) {
                ++pCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                if (iterationCounts != null) {
                    iterCounts.add(iterationCounts.get(pCount));
                } else {
                    int iterCount = sp.getIterationCount();
                    iterCounts.add(iterCount);
                }
                Map paramMM = sp.getMeanMagnitudes(StatsType.Parameters);
                Map updateMM = sp.getMeanMagnitudes(StatsType.Updates);
                for (String s : paramMM.keySet()) {
                    String prefix;
                    if (!s.startsWith(prefix = modelType == ModelType.Layer ? layerName : layerName + "_")) continue;
                    String layerParam = s.substring(prefix.length());
                    double pmm = (Double)paramMM.get(s);
                    double umm = (Double)updateMM.get(s);
                    if (Double.isNaN(pmm)) {
                        pmm = 0.0;
                    }
                    if (Double.isNaN(umm)) {
                        umm = 0.0;
                    }
                    double ratio = umm == 0.0 && pmm == 0.0 ? 0.0 : umm / pmm;
                    ArrayList<Double> list = (ArrayList<Double>)ratioValues.get(layerParam);
                    if (list == null) {
                        list = new ArrayList<Double>();
                        ratioValues.put(layerParam, list);
                    }
                    list.add(ratio);
                    ArrayList<Double> pmmList = (ArrayList<Double>)outParamMM.get(layerParam);
                    if (pmmList == null) {
                        pmmList = new ArrayList<Double>();
                        outParamMM.put(layerParam, pmmList);
                    }
                    pmmList.add(pmm);
                    ArrayList<Double> ummList = (ArrayList<Double>)outUpdateMM.get(layerParam);
                    if (ummList == null) {
                        ummList = new ArrayList<Double>();
                        outUpdateMM.put(layerParam, ummList);
                    }
                    ummList.add(umm);
                }
            }
        }
        return new MeanMagnitudes(iterCounts, ratioValues, outParamMM, outUpdateMM);
    }

    private Triple<int[], float[], float[]> getLayerActivations(int index, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts) {
        if (gi == null) {
            return EMPTY_TRIPLE;
        }
        String type = gi.getVertexTypes().get(index);
        if ("input".equalsIgnoreCase(type)) {
            return EMPTY_TRIPLE;
        }
        List<String> origNames = gi.getOriginalVertexName();
        if (index < 0 || index >= origNames.size()) {
            return EMPTY_TRIPLE;
        }
        String layerName = origNames.get(index);
        int size = updates == null ? 0 : updates.size();
        int[] iterCounts = new int[size];
        float[] mean = new float[size];
        float[] stdev = new float[size];
        int used = 0;
        if (updates != null) {
            int uCount = -1;
            for (Persistable u : updates) {
                ++uCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                iterCounts[used] = iterationCounts == null ? sp.getIterationCount() : iterationCounts.get(uCount).intValue();
                Map means = sp.getMean(StatsType.Activations);
                Map stdevs = sp.getStdev(StatsType.Activations);
                if (means == null || !means.containsKey(layerName)) continue;
                mean[used] = ((Double)means.get(layerName)).floatValue();
                stdev[used] = ((Double)stdevs.get(layerName)).floatValue();
                if (Float.isNaN(mean[used])) {
                    mean[used] = 0.0f;
                }
                if (Float.isNaN(stdev[used])) {
                    stdev[used] = 0.0f;
                }
                ++used;
            }
        }
        if (used != iterCounts.length) {
            iterCounts = Arrays.copyOf(iterCounts, used);
            mean = Arrays.copyOf(mean, used);
            stdev = Arrays.copyOf(stdev, used);
        }
        return new Triple((Object)iterCounts, (Object)mean, (Object)stdev);
    }

    private Map<String, Object> getLayerLearningRates(int layerIdx, TrainModuleUtils.GraphInfo gi, List<Persistable> updates, List<Integer> iterationCounts, ModelType modelType) {
        if (gi == null) {
            return Collections.emptyMap();
        }
        String layerName = gi.getOriginalVertexName().get(layerIdx);
        int size = updates == null ? 0 : updates.size();
        int[] iterCounts = new int[size];
        HashMap<String, float[]> byName = new HashMap<String, float[]>();
        int used = 0;
        if (updates != null) {
            int uCount = -1;
            for (Persistable u : updates) {
                ++uCount;
                if (!(u instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)u;
                iterCounts[used] = iterationCounts == null ? sp.getIterationCount() : iterationCounts.get(uCount).intValue();
                Map lrs = sp.getLearningRates();
                String prefix = modelType == ModelType.Layer ? layerName : layerName + "_";
                for (String p : lrs.keySet()) {
                    if (!p.startsWith(prefix)) continue;
                    String layerParamName = p.substring(Math.min(p.length(), prefix.length()));
                    if (!byName.containsKey(layerParamName)) {
                        byName.put(layerParamName, new float[size]);
                    }
                    float[] lrThisParam = (float[])byName.get(layerParamName);
                    lrThisParam[used] = ((Double)lrs.get(p)).floatValue();
                }
                ++used;
            }
        }
        ArrayList paramNames = new ArrayList(byName.keySet());
        Collections.sort(paramNames);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("iterCounts", iterCounts);
        ret.put("paramNames", paramNames);
        ret.put("lrs", byName);
        return ret;
    }

    private static Map<String, Object> getHistograms(int layerIdx, TrainModuleUtils.GraphInfo gi, StatsType statsType, Persistable p) {
        if (p == null) {
            return null;
        }
        if (!(p instanceof StatsReport)) {
            return null;
        }
        StatsReport sr = (StatsReport)p;
        String layerName = gi.getOriginalVertexName().get(layerIdx);
        Map map = sr.getHistograms(statsType);
        ArrayList<String> paramNames = new ArrayList<String>();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (layerName != null) {
            for (String s : map.keySet()) {
                if (!s.startsWith(layerName)) continue;
                String paramName = s.charAt(layerName.length()) == '_' ? s.substring(layerName.length() + 1) : s.substring(layerName.length());
                paramNames.add(paramName);
                Histogram h = (Histogram)map.get(s);
                HashMap<String, Object> thisHist = new HashMap<String, Object>();
                double min = h.getMin();
                double max = h.getMax();
                if (Double.isNaN(min)) {
                    min = 0.0;
                    max = 0.0;
                }
                thisHist.put("min", min);
                thisHist.put("max", max);
                thisHist.put("bins", h.getNBins());
                thisHist.put("counts", h.getBinCounts());
                ret.put(paramName, thisHist);
            }
        }
        ret.put("paramNames", paramNames);
        return ret;
    }

    private static Map<String, Object> getMemory(List<Persistable> staticInfoAllWorkers, List<Persistable> updatesLastNMinutes, I18N i18n) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        HashSet<String> jvmIDs = new HashSet<String>();
        HashMap<String, String> workersToJvms = new HashMap<String, String>();
        HashMap<String, Integer> workerNumDevices = new HashMap<String, Integer>();
        HashMap<String, String[]> deviceNames = new HashMap<String, String[]>();
        for (Persistable p : staticInfoAllWorkers) {
            StatsInitializationReport init = (StatsInitializationReport)p;
            String jvmuid = init.getSwJvmUID();
            workersToJvms.put(p.getWorkerID(), jvmuid);
            jvmIDs.add(jvmuid);
            int nDevices = init.getHwNumDevices();
            workerNumDevices.put(p.getWorkerID(), nDevices);
            if (nDevices <= 0) continue;
            String[] deviceNamesArr = init.getHwDeviceDescription();
            deviceNames.put(p.getWorkerID(), deviceNamesArr);
        }
        ArrayList jvmList = new ArrayList(jvmIDs);
        Collections.sort(jvmList);
        int count = 0;
        for (String jvm : jvmList) {
            ArrayList<String> workersForJvm = new ArrayList<String>();
            for (String s : workersToJvms.keySet()) {
                if (!((String)workersToJvms.get(s)).equals(jvm)) continue;
                workersForJvm.add(s);
            }
            Collections.sort(workersForJvm);
            String wid = (String)workersForJvm.get(0);
            int numDevices = (Integer)workerNumDevices.get(wid);
            HashMap<String, Object> jvmData = new HashMap<String, Object>();
            ArrayList<Long> timestamps = new ArrayList<Long>();
            ArrayList<Float> fracJvm = new ArrayList<Float>();
            ArrayList<Float> fracOffHeap = new ArrayList<Float>();
            long[] lastBytes = new long[2 + numDevices];
            long[] lastMaxBytes = new long[2 + numDevices];
            ArrayList fracDeviceMem = null;
            if (numDevices > 0) {
                fracDeviceMem = new ArrayList(numDevices);
                for (int i = 0; i < numDevices; ++i) {
                    fracDeviceMem.add(new ArrayList());
                }
            }
            for (Persistable p : updatesLastNMinutes) {
                if (!p.getWorkerID().equals(wid) || !(p instanceof StatsReport)) continue;
                StatsReport sp = (StatsReport)p;
                timestamps.add(sp.getTimeStamp());
                long jvmCurrentBytes = sp.getJvmCurrentBytes();
                long jvmMaxBytes = sp.getJvmMaxBytes();
                long ohCurrentBytes = sp.getOffHeapCurrentBytes();
                long ohMaxBytes = sp.getOffHeapMaxBytes();
                double jvmFrac = (double)jvmCurrentBytes / (double)jvmMaxBytes;
                double offheapFrac = (double)ohCurrentBytes / (double)ohMaxBytes;
                if (Double.isNaN(jvmFrac)) {
                    jvmFrac = 0.0;
                }
                if (Double.isNaN(offheapFrac)) {
                    offheapFrac = 0.0;
                }
                fracJvm.add(Float.valueOf((float)jvmFrac));
                fracOffHeap.add(Float.valueOf((float)offheapFrac));
                lastBytes[0] = jvmCurrentBytes;
                lastBytes[1] = ohCurrentBytes;
                lastMaxBytes[0] = jvmMaxBytes;
                lastMaxBytes[1] = ohMaxBytes;
                if (numDevices <= 0) continue;
                long[] devBytes = sp.getDeviceCurrentBytes();
                long[] devMaxBytes = sp.getDeviceMaxBytes();
                for (int i = 0; i < numDevices; ++i) {
                    double frac = (double)devBytes[i] / (double)devMaxBytes[i];
                    if (Double.isNaN(frac)) {
                        frac = 0.0;
                    }
                    ((List)fracDeviceMem.get(i)).add(Float.valueOf((float)frac));
                    lastBytes[2 + i] = devBytes[i];
                    lastMaxBytes[2 + i] = devMaxBytes[i];
                }
            }
            ArrayList<ArrayList<Float>> fracUtilized = new ArrayList<ArrayList<Float>>();
            fracUtilized.add(fracJvm);
            fracUtilized.add(fracOffHeap);
            String[] seriesNames = new String[2 + numDevices];
            seriesNames[0] = i18n.getMessage("train.system.hwTable.jvmCurrent");
            seriesNames[1] = i18n.getMessage("train.system.hwTable.offHeapCurrent");
            boolean[] isDevice = new boolean[2 + numDevices];
            String[] devNames = (String[])deviceNames.get(wid);
            for (int i = 0; i < numDevices; ++i) {
                seriesNames[2 + i] = devNames != null && devNames.length > i ? devNames[i] : "";
                fracUtilized.add((ArrayList<Float>)fracDeviceMem.get(i));
                isDevice[2 + i] = true;
            }
            jvmData.put("times", timestamps);
            jvmData.put("isDevice", isDevice);
            jvmData.put("seriesNames", seriesNames);
            jvmData.put("values", fracUtilized);
            jvmData.put("currentBytes", lastBytes);
            jvmData.put("maxBytes", lastMaxBytes);
            ret.put(String.valueOf(count), jvmData);
            ++count;
        }
        return ret;
    }

    private static Pair<Map<String, Object>, Map<String, Object>> getHardwareSoftwareInfo(List<Persistable> staticInfoAllWorkers, I18N i18n) {
        HashMap retHw = new HashMap();
        HashMap retSw = new HashMap();
        HashSet<String> jvmIDs = new HashSet<String>();
        HashMap<String, StatsInitializationReport> staticByJvm = new HashMap<String, StatsInitializationReport>();
        for (Persistable p : staticInfoAllWorkers) {
            StatsInitializationReport init = (StatsInitializationReport)p;
            String jvmuid = init.getSwJvmUID();
            jvmIDs.add(jvmuid);
            staticByJvm.put(jvmuid, init);
        }
        ArrayList jvmList = new ArrayList(jvmIDs);
        Collections.sort(jvmList);
        int count = 0;
        for (String jvm : jvmList) {
            String datatype;
            StatsInitializationReport sr = (StatsInitializationReport)staticByJvm.get(jvm);
            ArrayList<String[]> hwInfo = new ArrayList<String[]>();
            int numDevices = sr.getHwNumDevices();
            String[] deviceDescription = sr.getHwDeviceDescription();
            long[] devTotalMem = sr.getHwDeviceTotalMemory();
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.jvmMax"), String.valueOf(sr.getHwJvmMaxMemory())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.offHeapMax"), String.valueOf(sr.getHwOffHeapMaxMemory())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.jvmProcs"), String.valueOf(sr.getHwJvmAvailableProcessors())});
            hwInfo.add(new String[]{i18n.getMessage("train.system.hwTable.computeDevices"), String.valueOf(numDevices)});
            for (int i = 0; i < numDevices; ++i) {
                String label = i18n.getMessage("train.system.hwTable.deviceName") + " (" + i + ")";
                String name = deviceDescription == null || i >= deviceDescription.length ? String.valueOf(i) : deviceDescription[i];
                hwInfo.add(new String[]{label, name});
                String memLabel = i18n.getMessage("train.system.hwTable.deviceMemory") + " (" + i + ")";
                String memBytes = devTotalMem == null | i >= devTotalMem.length ? "-" : String.valueOf(devTotalMem[i]);
                hwInfo.add(new String[]{memLabel, memBytes});
            }
            retHw.put(String.valueOf(count), hwInfo);
            String nd4jBackend = sr.getSwNd4jBackendClass();
            if (nd4jBackend != null && nd4jBackend.contains(".")) {
                String temp;
                int idx = nd4jBackend.lastIndexOf(46);
                switch (nd4jBackend = nd4jBackend.substring(idx + 1)) {
                    case "CpuNDArrayFactory": {
                        temp = "CPU";
                        break;
                    }
                    case "JCublasNDArrayFactory": {
                        temp = "CUDA";
                        break;
                    }
                    default: {
                        temp = nd4jBackend;
                    }
                }
                nd4jBackend = temp;
            }
            datatype = (datatype = sr.getSwNd4jDataTypeName()) == null ? "" : datatype.toLowerCase();
            ArrayList<String[]> swInfo = new ArrayList<String[]>();
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.os"), sr.getSwOsName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.hostname"), sr.getSwHostName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.osArch"), sr.getSwArch()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.jvmName"), sr.getSwJvmName()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.jvmVersion"), sr.getSwJvmVersion()});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.nd4jBackend"), nd4jBackend});
            swInfo.add(new String[]{i18n.getMessage("train.system.swTable.nd4jDataType"), datatype});
            retSw.put(String.valueOf(count), swInfo);
            ++count;
        }
        return new Pair(retHw, retSw);
    }

    private static class MeanMagnitudes {
        private List<Integer> iterations;
        private Map<String, List<Double>> ratios;
        private Map<String, List<Double>> paramMM;
        private Map<String, List<Double>> updateMM;

        @ConstructorProperties(value={"iterations", "ratios", "paramMM", "updateMM"})
        public MeanMagnitudes(List<Integer> iterations, Map<String, List<Double>> ratios, Map<String, List<Double>> paramMM, Map<String, List<Double>> updateMM) {
            this.iterations = iterations;
            this.ratios = ratios;
            this.paramMM = paramMM;
            this.updateMM = updateMM;
        }

        public List<Integer> getIterations() {
            return this.iterations;
        }

        public Map<String, List<Double>> getRatios() {
            return this.ratios;
        }

        public Map<String, List<Double>> getParamMM() {
            return this.paramMM;
        }

        public Map<String, List<Double>> getUpdateMM() {
            return this.updateMM;
        }

        public void setIterations(List<Integer> iterations) {
            this.iterations = iterations;
        }

        public void setRatios(Map<String, List<Double>> ratios) {
            this.ratios = ratios;
        }

        public void setParamMM(Map<String, List<Double>> paramMM) {
            this.paramMM = paramMM;
        }

        public void setUpdateMM(Map<String, List<Double>> updateMM) {
            this.updateMM = updateMM;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MeanMagnitudes)) {
                return false;
            }
            MeanMagnitudes other = (MeanMagnitudes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Integer> this$iterations = this.getIterations();
            List<Integer> other$iterations = other.getIterations();
            if (this$iterations == null ? other$iterations != null : !((Object)this$iterations).equals(other$iterations)) {
                return false;
            }
            Map<String, List<Double>> this$ratios = this.getRatios();
            Map<String, List<Double>> other$ratios = other.getRatios();
            if (this$ratios == null ? other$ratios != null : !((Object)this$ratios).equals(other$ratios)) {
                return false;
            }
            Map<String, List<Double>> this$paramMM = this.getParamMM();
            Map<String, List<Double>> other$paramMM = other.getParamMM();
            if (this$paramMM == null ? other$paramMM != null : !((Object)this$paramMM).equals(other$paramMM)) {
                return false;
            }
            Map<String, List<Double>> this$updateMM = this.getUpdateMM();
            Map<String, List<Double>> other$updateMM = other.getUpdateMM();
            return !(this$updateMM == null ? other$updateMM != null : !((Object)this$updateMM).equals(other$updateMM));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MeanMagnitudes;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Integer> $iterations = this.getIterations();
            result = result * 59 + ($iterations == null ? 43 : ((Object)$iterations).hashCode());
            Map<String, List<Double>> $ratios = this.getRatios();
            result = result * 59 + ($ratios == null ? 43 : ((Object)$ratios).hashCode());
            Map<String, List<Double>> $paramMM = this.getParamMM();
            result = result * 59 + ($paramMM == null ? 43 : ((Object)$paramMM).hashCode());
            Map<String, List<Double>> $updateMM = this.getUpdateMM();
            result = result * 59 + ($updateMM == null ? 43 : ((Object)$updateMM).hashCode());
            return result;
        }

        public String toString() {
            return "TrainModule.MeanMagnitudes(iterations=" + this.getIterations() + ", ratios=" + this.getRatios() + ", paramMM=" + this.getParamMM() + ", updateMM=" + this.getUpdateMM() + ")";
        }
    }

    private static enum ModelType {
        MLN,
        CG,
        Layer;

    }
}

