/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.play;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.ui.api.Route;
import org.deeplearning4j.ui.api.UIModule;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.i18n.I18NProvider;
import org.deeplearning4j.ui.module.convolutional.ConvolutionalListenerModule;
import org.deeplearning4j.ui.module.defaultModule.DefaultModule;
import org.deeplearning4j.ui.module.flow.FlowListenerModule;
import org.deeplearning4j.ui.module.histogram.HistogramModule;
import org.deeplearning4j.ui.module.remote.RemoteReceiverModule;
import org.deeplearning4j.ui.module.train.TrainModule;
import org.deeplearning4j.ui.module.tsne.TsneModule;
import org.deeplearning4j.ui.play.misc.FunctionUtil;
import org.deeplearning4j.ui.play.staticroutes.Assets;
import org.deeplearning4j.ui.play.staticroutes.I18NRoute;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;
import org.deeplearning4j.ui.storage.impl.QueueStatsStorageListener;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.Store;
import org.reflections.scanners.SubTypesScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Mode;
import play.api.routing.Router;
import play.mvc.Results;
import play.routing.RoutingDsl;
import play.server.Server;

public class PlayUIServer
extends UIServer {
    private static final Logger log = LoggerFactory.getLogger(PlayUIServer.class);
    public static final String UI_SERVER_PORT_PROPERTY = "org.deeplearning4j.ui.port";
    public static final int DEFAULT_UI_PORT = 9000;
    public static final String UI_CUSTOM_MODULE_PROPERTY = "org.deeplearning4j.ui.custommodule.enable";
    public static final String ASSETS_ROOT_DIRECTORY = "deeplearning4jUiAssets/";
    private Server server;
    private final BlockingQueue<StatsStorageEvent> eventQueue = new LinkedBlockingQueue<StatsStorageEvent>();
    private List<Pair<StatsStorage, StatsStorageListener>> listeners = new ArrayList<Pair<StatsStorage, StatsStorageListener>>();
    private List<StatsStorage> statsStorageInstances = new ArrayList<StatsStorage>();
    private List<UIModule> uiModules = new ArrayList<UIModule>();
    private RemoteReceiverModule remoteReceiverModule;
    private Map<String, List<UIModule>> typeIDModuleMap = new ConcurrentHashMap<String, List<UIModule>>();
    private long uiProcessingDelay = 500L;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Thread uiEventRoutingThread;
    @Parameter(names={"-r", "-enableRemote"}, description="Whether to enable remote or not", arity=1)
    private boolean enableRemote;
    private int port;

    public PlayUIServer() {
        int n;
        RoutingDsl routingDsl = new RoutingDsl();
        routingDsl.GET("/setlang/:to").routeTo(FunctionUtil.function(new I18NRoute()));
        routingDsl.GET("/lang/getCurrent").routeTo(() -> Results.ok((String)I18NProvider.getInstance().getDefaultLanguage()));
        routingDsl.GET("/assets/*file").routeTo(FunctionUtil.function(new Assets(ASSETS_ROOT_DIRECTORY)));
        this.uiModules.add(new DefaultModule());
        this.uiModules.add(new HistogramModule());
        this.uiModules.add(new TrainModule());
        this.uiModules.add(new ConvolutionalListenerModule());
        this.uiModules.add(new FlowListenerModule());
        this.uiModules.add(new TsneModule());
        this.remoteReceiverModule = new RemoteReceiverModule();
        this.uiModules.add(this.remoteReceiverModule);
        String customModulePropertyStr = System.getProperty(UI_CUSTOM_MODULE_PROPERTY);
        boolean useCustomModules = false;
        if (customModulePropertyStr != null) {
            useCustomModules = Boolean.parseBoolean(customModulePropertyStr);
        }
        if (useCustomModules) {
            ArrayList excludeClasses = new ArrayList();
            for (UIModule u : this.uiModules) {
                excludeClasses.add(u.getClass());
            }
            List<UIModule> list = this.getCustomUIModules(excludeClasses);
            this.uiModules.addAll(list);
        }
        for (UIModule m : this.uiModules) {
            List<Route> routes = m.getRoutes();
            block8: for (Route route : routes) {
                RoutingDsl.PathPatternMatcher ppm = routingDsl.match(route.getHttpMethod().name(), route.getRoute());
                switch (route.getFunctionType()) {
                    case Supplier: {
                        ppm.routeTo(FunctionUtil.function0(route.getSupplier()));
                        continue block8;
                    }
                    case Function: {
                        ppm.routeTo(FunctionUtil.function(route.getFunction()));
                        continue block8;
                    }
                }
                throw new RuntimeException("Not yet implemented");
            }
            List<String> typeIDs = m.getCallbackTypeIDs();
            for (String typeID : typeIDs) {
                List<UIModule> list = this.typeIDModuleMap.get(typeID);
                if (list == null) {
                    list = Collections.synchronizedList(new ArrayList());
                    this.typeIDModuleMap.put(typeID, list);
                }
                list.add(m);
            }
        }
        String portProperty = System.getProperty(UI_SERVER_PORT_PROPERTY);
        int port = 9000;
        if (portProperty != null) {
            try {
                port = Integer.parseInt(portProperty);
            }
            catch (NumberFormatException e) {
                log.warn("Could not parse {} property: NumberFormatException for property value \"{}\". Defaulting to port {}. Set property to 0 for random port", new Object[]{UI_SERVER_PORT_PROPERTY, portProperty, port});
            }
        }
        Router router = routingDsl.build();
        this.server = Server.forRouter((Router)router, (Mode)Mode.DEV, (int)port);
        this.port = port;
        String addr = this.server.mainAddress().toString();
        if (addr.startsWith("/0:0:0:0:0:0:0:0") && (n = addr.lastIndexOf(58)) > 0) {
            addr = "http://localhost:" + addr.substring(n + 1);
        }
        log.info("UI Server started at {}", (Object)addr);
        this.uiEventRoutingThread = new Thread(new StatsEventRouterRunnable());
        this.uiEventRoutingThread.setDaemon(true);
        this.uiEventRoutingThread.start();
    }

    public void runMain(String[] args) {
        JCommander jcmdr = new JCommander((Object)this);
        try {
            jcmdr.parse(args);
        }
        catch (ParameterException e) {
            jcmdr.usage();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
        PlayUIServer server = new PlayUIServer();
        if (this.enableRemote) {
            server.enableRemoteListener();
        }
    }

    public static void main(String[] args) {
        new PlayUIServer().runMain(args);
    }

    private List<UIModule> getCustomUIModules(List<Class<?>> excludeClasses) {
        List<String> classNames = Collections.singletonList(UIModule.class.getName());
        Reflections reflections = new Reflections(new Object[0]);
        Store store = reflections.getStore();
        Iterable subtypesByName = store.getAll(SubTypesScanner.class.getSimpleName(), classNames);
        HashSet subtypeClasses = Sets.newHashSet((Iterable)ReflectionUtils.forNames((Iterable)subtypesByName, (ClassLoader[])new ClassLoader[0]));
        ArrayList<Class> toCreate = new ArrayList<Class>();
        for (Class c : subtypeClasses) {
            if (excludeClasses.contains(c)) continue;
            toCreate.add(c);
        }
        ArrayList<UIModule> ret = new ArrayList<UIModule>(toCreate.size());
        for (Class c : toCreate) {
            UIModule m;
            try {
                m = (UIModule)c.newInstance();
            }
            catch (Exception e) {
                log.warn("Could not create instance of custom UIModule of type {}; skipping", (Object)c, (Object)e);
                continue;
            }
            log.debug("Created instance of custom UI module: {}", (Object)c);
            ret.add(m);
        }
        return ret;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public synchronized void attach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        QueueStatsStorageListener listener = new QueueStatsStorageListener(this.eventQueue);
        this.listeners.add((Pair<StatsStorage, StatsStorageListener>)new Pair((Object)statsStorage, (Object)listener));
        statsStorage.registerStatsStorageListener((StatsStorageListener)listener);
        this.statsStorageInstances.add(statsStorage);
        for (UIModule uiModule : this.uiModules) {
            uiModule.onAttach(statsStorage);
        }
        log.info("StatsStorage instance attached to UI: {}", (Object)statsStorage);
    }

    @Override
    public synchronized void detach(StatsStorage statsStorage) {
        if (statsStorage == null) {
            throw new IllegalArgumentException("StatsStorage cannot be null");
        }
        if (!this.statsStorageInstances.contains(statsStorage)) {
            return;
        }
        boolean found = false;
        for (Pair<StatsStorage, StatsStorageListener> p : this.listeners) {
            if (p.getFirst() != statsStorage) continue;
            statsStorage.deregisterStatsStorageListener((StatsStorageListener)p.getSecond());
            this.listeners.remove(p);
            found = true;
        }
        for (UIModule uiModule : this.uiModules) {
            uiModule.onDetach(statsStorage);
        }
        if (found) {
            log.info("StatsStorage instance detached from UI: {}", (Object)statsStorage);
        }
    }

    @Override
    public boolean isAttached(StatsStorage statsStorage) {
        return this.statsStorageInstances.contains(statsStorage);
    }

    @Override
    public List<StatsStorage> getStatsStorageInstances() {
        return new ArrayList<StatsStorage>(this.statsStorageInstances);
    }

    @Override
    public void enableRemoteListener() {
        if (this.remoteReceiverModule.isEnabled()) {
            return;
        }
        this.enableRemoteListener((StatsStorageRouter)new InMemoryStatsStorage(), true);
    }

    @Override
    public void enableRemoteListener(StatsStorageRouter statsStorage, boolean attach) {
        this.remoteReceiverModule.setEnabled(true);
        this.remoteReceiverModule.setStatsStorage(statsStorage);
        if (attach && statsStorage instanceof StatsStorage) {
            this.attach((StatsStorage)statsStorage);
        }
    }

    @Override
    public void disableRemoteListener() {
        this.remoteReceiverModule.setEnabled(false);
    }

    @Override
    public boolean isRemoteListenerEnabled() {
        return this.remoteReceiverModule.isEnabled();
    }

    @Override
    public void stop() {
        this.server.stop();
    }

    private class StatsEventRouterRunnable
    implements Runnable {
        private StatsEventRouterRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runHelper();
            }
            catch (Exception e) {
                log.error("Unexpected exception from Event routing runnable", (Throwable)e);
            }
        }

        private void runHelper() throws Exception {
            log.debug("PlayUIServer.StatsEventRouterRunnable started");
            while (!PlayUIServer.this.shutdown.get()) {
                ArrayList<StatsStorageEvent> events = new ArrayList<StatsStorageEvent>();
                StatsStorageEvent sse = (StatsStorageEvent)PlayUIServer.this.eventQueue.take();
                events.add(sse);
                PlayUIServer.this.eventQueue.drainTo(events);
                for (UIModule m : PlayUIServer.this.uiModules) {
                    List<String> callbackTypes = m.getCallbackTypeIDs();
                    ArrayList<StatsStorageEvent> out = new ArrayList<StatsStorageEvent>();
                    for (StatsStorageEvent e : events) {
                        if (!callbackTypes.contains(e.getTypeID())) continue;
                        out.add(e);
                    }
                    m.reportStorageEvents(out);
                }
                try {
                    Thread.sleep(PlayUIServer.this.uiProcessingDelay);
                }
                catch (InterruptedException e) {
                    if (PlayUIServer.this.shutdown.get()) continue;
                    throw new RuntimeException("Unexpected interrupted exception", e);
                }
            }
        }
    }
}

