/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.actor.core;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Cancellable;
import akka.actor.UntypedActor;
import akka.cluster.Cluster;
import akka.cluster.ClusterEvent;
import akka.contrib.pattern.DistributedPubSubExtension;
import akka.contrib.pattern.DistributedPubSubMediator;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.ArrayList;
import java.util.List;

public class ClusterListener
extends UntypedActor {
    LoggingAdapter log = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    Cluster cluster = Cluster.get((ActorSystem)this.getContext().system());
    protected ActorRef mediator = DistributedPubSubExtension.get((ActorSystem)this.getContext().system()).mediator();
    public static final String TOPICS = "topics";
    private List<String> topics = new ArrayList<String>();
    private Cancellable topicTask;

    public void preStart() {
        this.cluster.subscribe(this.getSelf(), new Class[]{ClusterEvent.MemberEvent.class});
        this.mediator.tell((Object)new DistributedPubSubMediator.Subscribe(TOPICS, this.getSelf()), this.getSelf());
        this.log.info("Subscribed to cluster events");
    }

    public void postStop() {
        this.cluster.unsubscribe(this.getSelf());
        this.log.info("UnSubscribed to cluster events");
        if (this.topicTask != null) {
            this.topicTask.cancel();
        }
    }

    public void onReceive(Object message) {
        if (message instanceof ClusterEvent.MemberUp) {
            ClusterEvent.MemberUp mUp = (ClusterEvent.MemberUp)message;
            this.log.info("Member is Up: {}", (Object)mUp.member());
        } else if (message instanceof ClusterEvent.UnreachableMember) {
            ClusterEvent.UnreachableMember mUnreachable = (ClusterEvent.UnreachableMember)message;
            this.log.info("Member detected as unreachable: {}", (Object)mUnreachable.member());
        } else if (message instanceof ClusterEvent.MemberRemoved) {
            ClusterEvent.MemberRemoved mRemoved = (ClusterEvent.MemberRemoved)message;
            this.log.info("Member is Removed: {}", (Object)mRemoved.member());
        } else if (!(message instanceof ClusterEvent.MemberEvent)) {
            if (message instanceof DistributedPubSubMediator.SubscribeAck) {
                DistributedPubSubMediator.SubscribeAck ack = (DistributedPubSubMediator.SubscribeAck)message;
                this.topics.add(ack.subscribe().topic());
            } else if (message instanceof DistributedPubSubMediator.UnsubscribeAck) {
                DistributedPubSubMediator.UnsubscribeAck unsub = (DistributedPubSubMediator.UnsubscribeAck)message;
                this.topics.remove(unsub.unsubscribe().topic());
            } else if (message instanceof List) {
                this.log.info("Topics sent " + message);
            } else {
                this.unhandled(message);
            }
        }
    }
}

