/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.actor.core;

import java.io.File;
import java.io.Serializable;
import org.deeplearning4j.scaleout.actor.core.ModelSaver;
import org.deeplearning4j.util.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultModelSaver
implements ModelSaver {
    private static final long serialVersionUID = -7563476748417989927L;
    private File file;
    private boolean rewrite = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultModelSaver.class);

    public DefaultModelSaver(File file) {
        this(file, false);
    }

    public DefaultModelSaver(File file, boolean rewrite) {
        this.file = file;
        this.rewrite = rewrite;
    }

    public DefaultModelSaver() {
        this.file = new File("nn-model.bin");
    }

    @Override
    public void save(Serializable ser) {
        if (!this.rewrite) {
            String path = this.file.getAbsolutePath();
            if (this.file.exists()) {
                this.file.renameTo(new File(this.file.getParentFile(), this.file.getName() + "-" + System.currentTimeMillis()));
            }
            this.file = new File(path);
        }
        log.info("Saving to " + this.file);
        SerializationUtils.saveObject((Object)ser, (File)this.file);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public <E> E load(Class<E> clazz) {
        return (E)SerializationUtils.readObject((File)this.file);
    }
}

