/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.scaleout.zookeeper;

import java.io.IOException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperBuilder
implements Watcher {
    private String host = "localhost";
    private int port = 2181;
    private int timeout = 10000;
    private Watcher watcher;
    private ZooKeeper keeper;
    private static final Logger log = LoggerFactory.getLogger(ZookeeperBuilder.class);

    public ZooKeeper build() {
        try {
            this.keeper = new ZooKeeper(this.host + ":" + this.port, this.timeout, (Watcher)this);
            while (this.keeper.getState() != ZooKeeper.States.CONNECTED) {
                Thread.sleep(15000L);
                log.info("Waiting to connect to zookeeper");
            }
            return this.keeper;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public ZookeeperBuilder setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    public ZookeeperBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public ZookeeperBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public ZookeeperBuilder setSessionTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public void process(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            log.info("Synced");
        } else if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
            this.keeper = this.build();
        } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
            this.keeper = this.build();
        }
        if (this.watcher != null) {
            this.watcher.process(event);
        }
        log.info("Processed event...");
    }
}

