/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.sbe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingEncoder;
import org.deeplearning4j.ui.stats.sbe.MetaAttribute;
import org.deeplearning4j.ui.stats.sbe.StorageMetaDataDecoder;

public class StorageMetaDataEncoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final StorageMetaDataEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final ExtraMetaDataBytesEncoder extraMetaDataBytes = new ExtraMetaDataBytesEncoder();

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public StorageMetaDataEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 8);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long timeStampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeStampMinValue() {
        return -9223372036854775807L;
    }

    public static long timeStampMaxValue() {
        return Long.MAX_VALUE;
    }

    public StorageMetaDataEncoder timeStamp(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static long extraMetaDataBytesId() {
        return 2L;
    }

    public ExtraMetaDataBytesEncoder extraMetaDataBytesCount(int count) {
        this.extraMetaDataBytes.wrap(this.parentMessage, this.buffer, count);
        return this.extraMetaDataBytes;
    }

    public static int sessionIDId() {
        return 4;
    }

    public static String sessionIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int sessionIDHeaderLength() {
        return 4;
    }

    public StorageMetaDataEncoder putSessionID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder putSessionID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder sessionID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int typeIDId() {
        return 5;
    }

    public static String typeIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String typeIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int typeIDHeaderLength() {
        return 4;
    }

    public StorageMetaDataEncoder putTypeID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder putTypeID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder typeID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int workerIDId() {
        return 6;
    }

    public static String workerIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String workerIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int workerIDHeaderLength() {
        return 4;
    }

    public StorageMetaDataEncoder putWorkerID(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder putWorkerID(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder workerID(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int initTypeClassId() {
        return 7;
    }

    public static String initTypeClassCharacterEncoding() {
        return "UTF-8";
    }

    public static String initTypeClassMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int initTypeClassHeaderLength() {
        return 4;
    }

    public StorageMetaDataEncoder putInitTypeClass(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder putInitTypeClass(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder initTypeClass(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int updateTypeClassId() {
        return 8;
    }

    public static String updateTypeClassCharacterEncoding() {
        return "UTF-8";
    }

    public static String updateTypeClassMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int updateTypeClassHeaderLength() {
        return 4;
    }

    public StorageMetaDataEncoder putUpdateTypeClass(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder putUpdateTypeClass(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public StorageMetaDataEncoder updateTypeClass(String value) {
        byte[] bytes;
        try {
            bytes = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalArgumentException("length > max value for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        StorageMetaDataDecoder writer = new StorageMetaDataDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 8, 0);
        return writer.appendTo(builder);
    }

    public static class ExtraMetaDataBytesEncoder {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingEncoder dimensions = new GroupSizeEncodingEncoder();
        private StorageMetaDataEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StorageMetaDataEncoder parentMessage, MutableDirectBuffer buffer, int count) {
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.actingVersion = 0;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.dimensions.blockLength(1);
            this.dimensions.numInGroup(count);
            this.index = -1;
            this.count = count;
            this.blockLength = 1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 1;
        }

        public ExtraMetaDataBytesEncoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static byte bytesNullValue() {
            return -128;
        }

        public static byte bytesMinValue() {
            return -127;
        }

        public static byte bytesMaxValue() {
            return 127;
        }

        public ExtraMetaDataBytesEncoder bytes(byte value) {
            this.buffer.putByte(this.offset + 0, value);
            return this;
        }
    }
}

