/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.storage;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.deeplearning4j.api.storage.Persistable;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageEvent;
import org.deeplearning4j.api.storage.StatsStorageListener;
import org.deeplearning4j.api.storage.StorageMetaData;
import org.deeplearning4j.ui.storage.BaseCollectionStatsStorage;

public class InMemoryStatsStorage
extends BaseCollectionStatsStorage {
    private final String uid;

    public InMemoryStatsStorage() {
        String str = UUID.randomUUID().toString();
        this.uid = str.substring(0, Math.min(str.length(), 8));
        this.sessionIDs = Collections.synchronizedSet(new HashSet());
        this.storageMetaData = new ConcurrentHashMap();
        this.staticInfo = new ConcurrentHashMap();
    }

    @Override
    protected synchronized Map<Long, Persistable> getUpdateMap(String sessionID, String typeID, String workerID, boolean createIfRequired) {
        BaseCollectionStatsStorage.SessionTypeWorkerId id = new BaseCollectionStatsStorage.SessionTypeWorkerId(sessionID, typeID, workerID);
        if (this.updates.containsKey(id)) {
            return (Map)this.updates.get(id);
        }
        if (!createIfRequired) {
            return null;
        }
        ConcurrentHashMap<Long, Persistable> updateMap = new ConcurrentHashMap<Long, Persistable>();
        this.updates.put(id, updateMap);
        return updateMap;
    }

    @Override
    public void putStaticInfo(Persistable staticInfo) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(staticInfo);
        if (!this.sessionIDs.contains(staticInfo.getSessionID())) {
            this.sessionIDs.add(staticInfo.getSessionID());
        }
        BaseCollectionStatsStorage.SessionTypeWorkerId id = new BaseCollectionStatsStorage.SessionTypeWorkerId(staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID());
        this.staticInfo.put(id, staticInfo);
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostStaticInfo, staticInfo.getSessionID(), staticInfo.getTypeID(), staticInfo.getWorkerID(), staticInfo.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    @Override
    public void putUpdate(Persistable update) {
        List<StatsStorageEvent> sses = this.checkStorageEvents(update);
        Map<Long, Persistable> updateMap = this.getUpdateMap(update.getSessionID(), update.getTypeID(), update.getWorkerID(), true);
        updateMap.put(update.getTimeStamp(), update);
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostUpdate, update.getSessionID(), update.getTypeID(), update.getWorkerID(), update.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    @Override
    public void putStorageMetaData(StorageMetaData storageMetaData) {
        List<StatsStorageEvent> sses = this.checkStorageEvents((Persistable)storageMetaData);
        BaseCollectionStatsStorage.SessionTypeId id = new BaseCollectionStatsStorage.SessionTypeId(storageMetaData.getSessionID(), storageMetaData.getTypeID());
        this.storageMetaData.put(id, storageMetaData);
        StatsStorageEvent sse = null;
        if (this.listeners.size() > 0) {
            sse = new StatsStorageEvent((StatsStorage)this, StatsStorageListener.EventType.PostMetaData, storageMetaData.getSessionID(), storageMetaData.getTypeID(), storageMetaData.getWorkerID(), storageMetaData.getTimeStamp());
        }
        for (StatsStorageListener l : this.listeners) {
            l.notify(sse);
        }
        this.notifyListeners(sses);
    }

    public void close() throws IOException {
    }

    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return "InMemoryStatsStorage(uid=" + this.uid + ")";
    }
}

