/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.nearestneighbors.word2vec;

import io.dropwizard.views.View;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.map.HashedMap;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.models.embeddings.loader.WordVectorSerializer;
import org.deeplearning4j.models.embeddings.wordvectors.WordVectors;
import org.deeplearning4j.models.word2vec.VocabWord;
import org.deeplearning4j.models.word2vec.wordstore.VocabCache;
import org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsQuery;
import org.deeplearning4j.ui.nearestneighbors.word2vec.NearestNeighborsView;
import org.deeplearning4j.ui.uploads.FileResource;
import org.deeplearning4j.util.SerializationUtils;

@Path(value="/word2vec")
public class NearestNeighborsResource
extends FileResource {
    private WordVectors vectors;

    public NearestNeighborsResource(String filePath) {
        super(filePath);
    }

    @GET
    public View get() {
        return new NearestNeighborsView();
    }

    @POST
    @Path(value="/vocab")
    @Produces(value={"application/json"})
    public Response getVocab() {
        ArrayList<String> words = new ArrayList<String>();
        VocabCache vocabCache = this.vectors.vocab();
        for (VocabWord word : vocabCache.vocabWords()) {
            words.add(word.getWord());
        }
        return Response.ok(new ArrayList(words)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/words")
    public Response getWords(NearestNeighborsQuery query) {
        Collection nearestNeighors = this.vectors.wordsNearest(query.getWord(), query.getNumWords());
        HashedMap map = new HashedMap();
        for (String s : nearestNeighors) {
            map.put(s, 0.0);
        }
        return Response.ok((Object)map).build();
    }

    @Override
    public void handleUpload(File path) {
        try {
            this.vectors = path.getAbsolutePath().endsWith(".ser") ? (WordVectors)SerializationUtils.readObject((File)path) : WordVectorSerializer.fromPair((Pair)WordVectorSerializer.loadTxt((File)path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

