/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui;

import java.util.concurrent.LinkedBlockingQueue;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.deeplearning4j.berkeley.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebReporter {
    private static final WebReporter INSTANCE = new WebReporter();
    protected LinkedBlockingQueue<Pair<WebTarget, Entity>> queue = new LinkedBlockingQueue();
    private static final Logger log = LoggerFactory.getLogger(WebReporter.class);

    private WebReporter() {
        ReporterThread thread = new ReporterThread(this.queue);
        thread.start();
        throw new RuntimeException("Not implemented");
    }

    public static WebReporter getInstance() {
        return INSTANCE;
    }

    public void queueReport(WebTarget target, Entity entity) {
        this.queue.add((Pair<WebTarget, Entity>)Pair.makePair((Object)target, (Object)entity));
    }

    public void postReport(WebTarget target, Entity entity) {
        Response resp = target.request(new String[]{"application/json"}).accept(new String[]{"application/json"}).post(entity);
        log.debug("{}", (Object)resp);
    }

    private class ReporterThread
    extends Thread
    implements Runnable {
        private LinkedBlockingQueue<Pair<WebTarget, Entity>> queue;

        public ReporterThread(LinkedBlockingQueue<Pair<WebTarget, Entity>> queue) {
            if (queue == null) {
                throw new NullPointerException("queue");
            }
            this.queue = queue;
            this.setName("DL4j Ui WebReporter thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    Pair<WebTarget, Entity> pair = this.queue.take();
                    WebReporter.this.postReport((WebTarget)pair.getFirst(), (Entity)pair.getSecond());
                    continue;
                }
                catch (Exception e) {
                    log.error("Exception caught but ignored: " + e.getMessage());
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
    }
}

