/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.weights;

import lombok.NonNull;
import org.deeplearning4j.api.storage.StatsStorage;
import org.deeplearning4j.api.storage.StatsStorageRouter;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.ui.UiConnectionInfo;
import org.deeplearning4j.ui.UiUtils;
import org.deeplearning4j.ui.api.UIServer;
import org.deeplearning4j.ui.stats.StatsListener;
import org.deeplearning4j.ui.stats.api.StatsUpdateConfiguration;
import org.deeplearning4j.ui.stats.impl.DefaultStatsUpdateConfiguration;
import org.deeplearning4j.ui.storage.InMemoryStatsStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HistogramIterationListener
extends StatsListener {
    private static final Logger log = LoggerFactory.getLogger(HistogramIterationListener.class);
    private boolean openBrowser;
    private boolean firstIteration = true;
    private String path;
    private static final String subPath = "weights";

    public HistogramIterationListener(@NonNull UiConnectionInfo connection, int iterations) {
        this((StatsStorage)new InMemoryStatsStorage(), iterations, true);
        if (connection == null) {
            throw new NullPointerException("connection");
        }
    }

    public HistogramIterationListener(int iterations) {
        this(iterations, true);
    }

    public HistogramIterationListener(int iterations, boolean openBrowser) {
        this((StatsStorage)new InMemoryStatsStorage(), iterations, openBrowser);
    }

    public HistogramIterationListener(StatsStorage ssr, int iterations, boolean openBrowser) {
        super((StatsStorageRouter)ssr, null, HistogramIterationListener.getUpdateConfiguration(iterations), null, null);
        int port = -1;
        try {
            UIServer server = UIServer.getInstance();
            port = server.getPort();
        }
        catch (Exception e) {
            log.error("Error initializing UI server", (Throwable)e);
            throw new RuntimeException(e);
        }
        UIServer.getInstance().attach(ssr);
        this.path = "http://localhost:" + port + "/" + subPath;
        this.openBrowser = openBrowser;
        System.out.println("UI Histogram URL: " + this.path);
    }

    public void iterationDone(Model model, int iteration) {
        super.iterationDone(model, iteration);
        if (this.openBrowser && this.firstIteration) {
            StringBuilder builder = new StringBuilder("http://localhost:").append(UIServer.getInstance().getPort()).append("/");
            builder.append(subPath).append("?sid=").append(super.getSessionID());
            UiUtils.tryOpenBrowser(builder.toString(), log);
            this.firstIteration = false;
        }
    }

    private static StatsUpdateConfiguration getUpdateConfiguration(int iterations) {
        return new DefaultStatsUpdateConfiguration.Builder().reportingFrequency(iterations).build();
    }
}

